unit Phnmain;

interface

uses
  PhnBook, About, OpenTbl, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, Menus, Buttons, ExtCtrls, DB, DBCtrls, DBTables, StdCtrls, Report;

type
  TMain = class(TForm)
    MainMenu1: TMainMenu;
    Help1: TMenuItem;
    About1: TMenuItem;
    HowtoUseHelp1: TMenuItem;
		Contents1: TMenuItem;
    Panel1: TPanel;
    btnOpenBook: TBitBtn;
    btnCopy: TBitBtn;
    btnPrint: TBitBtn;
    btnCloseBook: TBitBtn;
		dlgPrinterSetup: TPrinterSetupDialog;
    Window1: TMenuItem;
    CloseAll1: TMenuItem;
    ArrangeIcons1: TMenuItem;
		Cascade1: TMenuItem;
    Tile1: TMenuItem;
    btnPrevious: TBitBtn;
		btnNext: TBitBtn;
		btnFirst: TBitBtn;
		btnLast: TBitBtn;
		btnMove: TBitBtn;
		btnAdd: TBitBtn;
    btnDelete: TBitBtn;
		File2: TMenuItem;
    Exit1: TMenuItem;
    N3: TMenuItem;
    PrintSetup1: TMenuItem;
    Print1: TMenuItem;
    N5: TMenuItem;
    Close1: TMenuItem;
    Open1: TMenuItem;
    New1: TMenuItem;
    Edit1: TMenuItem;
    Paste1: TMenuItem;
    Copy1: TMenuItem;
		Cut1: TMenuItem;
		N6: TMenuItem;
		Move1: TMenuItem;
		Copy2: TMenuItem;
    Previous1: TMenuItem;
    Next1: TMenuItem;
		Delete1: TMenuItem;
		Add1: TMenuItem;
		N7: TMenuItem;
		Undo1: TMenuItem;
		First1: TMenuItem;
		Last1: TMenuItem;
		Panel2: TPanel;
		btnChecked: TBitBtn;
		btnHelp: TBitBtn;
    btnSearch: TSpeedButton;
		PhoneReport: TReport;
    DeletePBTable: TMenuItem;
    Tag1: TMenuItem;
		UntagAll1: TMenuItem;
    Utilities1: TMenuItem;
    PackDatabase1: TMenuItem;
    RepairDatabase1: TMenuItem;
    N1: TMenuItem;
		N2: TMenuItem;
    Rename1: TMenuItem;
		procedure Contents1Click(Sender: TObject);
		procedure HowtoUseHelp1Click(Sender: TObject);
		procedure PrintSetup1Click(Sender: TObject);
		procedure About1Click(Sender: TObject);
		procedure btnOpenBookClick(Sender: TObject);
		procedure Tile1Click(Sender: TObject);
		procedure CloseAll1Click(Sender: TObject);
		procedure Cascade1Click(Sender: TObject);
		procedure ArrangeIcons1Click(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure Close1Click(Sender: TObject);
		//procedure FormResize(Sender: TObject);
		procedure btnFirstClick(Sender: TObject);
		procedure btnPreviousClick(Sender: TObject);
		procedure btnNextClick(Sender: TObject);
		procedure btnLastClick(Sender: TObject);
		procedure btnAddClick(Sender: TObject);
		procedure btnDeleteClick(Sender: TObject);
		procedure Undo1Click(Sender: TObject);
		procedure btnSearchClick(Sender: TObject);
		procedure Print1Click(Sender: TObject);
		procedure Exit1Click(Sender: TObject);
		procedure New1Click(Sender: TObject);
		procedure DeletePBTableClick(Sender: TObject);
		procedure btnCheckedClick(Sender: TObject);
		procedure btnCopyClick(Sender: TObject);
		procedure UntagAll1Click(Sender: TObject);
		procedure btnMoveClick(Sender: TObject);
    procedure PackDatabase1Click(Sender: TObject);
    procedure RepairDatabase1Click(Sender: TObject);
    procedure Rename1Click(Sender: TObject);
	private
		{ Private declarations }
		procedure WMGetMinMaxInfo(var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
		function BuildPhoneBookDB: Boolean;
	public
		{ Public declarations }
		procedure ChangeButtonStatus( TurnOn: Boolean );
	end;

	TPhoneTypeInfo = class(TObject)
		Code: Byte;
		Description: String[10];
	end;

var
	Main: TMain;
	DBEngine: Variant;
	PBWorkspace: Variant;
	PhoneBookDB: Variant;
	PhoneTypeCodes, PhoneTypeDesc: TStringList;
	TableNameList: TStringList;
	TableNameListStatic: TStringList;
	TablesInUse: TStringList;
	//PhoneChildren: TStringList;
	MakingChanges: Boolean;
	CurrPhoneBook: TPhoneBook;
	AppPath: String;

const
	CHAR_QUOTE: Char = '''';
	// DAO constants;
	dbDate				=  8; // Date/Time
	dbText				= 10; // Text
	dbMemo				= 12; // Memo
	dbBoolean			=  1; // Yes/No
	dbInteger			=  3; // Integer
	dbLong				=  4; // Long
	dbCurrency		=  5; // Currency
	dbSingle			=  6; // Single
	dbDouble			=  7; // Double
	dbByte				=  2; // Byte
	dbLongBinary	= 11; // Long Binary (OLE Object)

	dbFailOnError = 128;
	dbSQLPassThrough = 64;

	MainTablePrefix: String = 'PhoneBook_';
	NumbersTablePrefix: String = 'PhoneNumbers_';
	TablePrefixLen = 10; //Length( MainTablePrefix );

	Field_EntryID				= 'EntryID';
	Field_LastName			= 'LastName';
	Field_FirstName			= 'FirstName';
	Field_Company				= 'Company';
	Field_Address1			= 'Address1';
	Field_Address2			= 'Address2';
	Field_City					= 'City';
	Field_State					= 'State';
	Field_Zip						= 'Zip';
	Field_EMailAddress	= 'EMailAddress';
	Field_Comment				= 'Comment';

	Field_PhoneType			= 'PhoneType';
	Field_PhoneNumber		= 'PhoneNumber';
	Field_Extension			= 'Extension';
	Field_Notes					= 'Notes';

implementation

uses
	PhnSearch, OLEAuto, GeneralLib, NewPBDlg, DeleteTbl, TagRecChgDlg,
  DestTbls, PBQRRpt, RenTblChcs;

{$R *.DFM}

var
	iStartingWidth: Smallint;
  iStartingHeight: Smallint;
	//iCheckBtnLeft: Smallint;
  //iHelpBtnLeft: Smallint;

procedure TMain.WMGetMinMaxInfo(var Msg: TWMGetMinMaxInfo);
begin
	inherited;
	with Msg.MinMaxInfo^ do
	begin
		ptMinTrackSize.x:= iStartingWidth;
		ptMaxTrackSize.x:= Screen.Width;
		ptMinTrackSize.y:= iStartingHeight;
		ptMaxTrackSize.y:= Screen.Height;
	end;
end;

procedure TMain.Contents1Click(Sender: TObject);
begin
	//Application.HelpCommand(HELP_CONTENTS,0);
end;

procedure TMain.HowtoUseHelp1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP,0)
end;

procedure TMain.PrintSetup1Click(Sender: TObject);
begin
	dlgPrinterSetup.Execute;
end;

procedure TMain.About1Click(Sender: TObject);
begin
  AboutPB.ShowModal;
end;

procedure TMain.btnOpenBookClick(Sender: TObject);

begin
	{Open a table within the Access Phone Book database}
	OpenTable.ShowModal;
end;

procedure TMain.CloseAll1Click(Sender: TObject);
var
  iCount: Integer;

begin
  for iCount := 0 to MDIChildCount - 1 do
		MDIChildren[iCount].Close
end;

procedure TMain.Cascade1Click(Sender: TObject);
begin
  cascade;
end;

procedure TMain.ArrangeIcons1Click(Sender: TObject);
begin
	ArrangeIcons;
end;

procedure TMain.Tile1Click(Sender: TObject);
begin
	Tile;
end;

procedure TMain.FormCreate(Sender: TObject);

var
	i, TableCount, TableNameLen, PhoneTypeCount: Byte;
	TableName: String[32];
	PhoneTypesTable: Variant;
	PhoneTypeRec: TPhoneTypeInfo;
	PhoneTypesDef, FieldDef: Variant;

begin
	AppPath := GetPathFile( Application.ExeName, True );
	try
		DBEngine := CreateOleObject( 'DAO.DBEngine.35' ); //Look for newest DAO first.  Doesn't work with running complex Access Query!
	except
		try
			DBEngine := CreateOleObject( 'DAO.DBEngine' );
		except
			ShowMessage( 'Unable to instantiate the DAO engine.' + chr(13) +
									'You must have the Microsoft DAO installed on your machine.' +
									'  This product is a part of MS Access, MS VB 4.0/5.0, etc.' );
			Application.Terminate;
		end;
	end;
	PBWorkspace := DBEngine.Workspaces[0];

	if (not FileExists( AppPath + 'PhoneBook.mdb' )) then
	begin

		if (not BuildPhoneBookDB) then // This will be called if the PhoneBook database has never been created or has been erased.
			begin // Trouble in paradise!
				MessageDlg( 'Cannot create the Phonebook database!', mtError, [mbOK], 0 );
				Application.Terminate;
			end;

	end
	else
		PhoneBookDB := PBWorkspace.OpenDatabase( AppPath + 'PhoneBook.mdb' );

	TablesInUse := TStringList.Create;
	TableCount := PhoneBookDB.TableDefs.Count;
	TableNameList := TStringList.Create;
	TableNameListStatic := TStringList.Create;

	if (TableCount > 0) then
	begin

		for i := 0 to TableCount - 1 do
		begin
			TableName := PhoneBookDB.TableDefs[i].Name;
			TableNameLen := Length( TableName );

			if (Copy( TableName, 1, TablePrefixLen ) = MainTablePrefix) then
			begin
				TableName := Copy( TableName, TablePrefixLen + 1, TableNameLen - TablePrefixLen );
				TableNameList.Add( TableName );
				TableNameListStatic.Add( TableName );
			end;

		end;

	end
	else
		btnOpenBook.Enabled := False;

	PhoneTypeCodes := TStringList.Create;
	PhoneTypeDesc := TStringList.Create;
	PhoneTypesTable := PhoneBookDB.OpenRecordset( 'PhoneTypes' );
	PhoneTypesTable.Index := 'PrimaryKey';
	PhoneTypeCount := PhoneTypesTable.RecordCount;
	PhoneTypesTable.MoveFirst;
	//PhoneTypeRec := TPhoneTypeInfo.Create;

	for i := 1 to PhoneTypeCount do
	begin
		PhoneTypeRec := TPhoneTypeInfo.Create;
		PhoneTypeRec.Code := PhoneTypesTable.Fields['Code'].Value;
		PhoneTypeRec.Description := PhoneTypesTable.Fields['Description'].Value;
		PhoneTypeCodes.AddObject( IntToStr( PhoneTypeRec.Code ), PhoneTypeRec ); // Search for Description by Code.
		PhoneTypeDesc.AddObject( PhoneTypeRec.Description, PhoneTypeRec ); // Search for Code by Description.
		PhoneTypesTable.MoveNext;
	end;

	//PhoneTypeRec.Free;
	iStartingHeight := self.Height;
	iStartingWidth := self.Width;
	//PhoneChildren := TStringList.Create;
	MakingChanges := False;
end;

function TMain.BuildPhoneBookDB: Boolean;

var
	PhoneTypesDef, ReportBaseDef, ReportNumbersDef, FieldDef, IndexDef: Variant;
	SQLQuery: String;

const
	dbVersion30 = 32;
	dbLangGeneral = ';LANGID=0x0409;CP=1252;COUNTRY=0';

begin
	try
		PhoneBookDB := PBWorkspace.CreateDatabase( AppPath + 'Phonebook.mdb', dbLangGeneral, dbVersion30 );
		PhoneTypesDef := PhoneBookDB.CreateTableDef( 'PhoneTypes' );
		FieldDef := PhoneTypesDef.CreateField( 'Code', dbByte );
		PhoneTypesDef.Fields.Append( FieldDef );

		IndexDef := PhoneTypesDef.CreateIndex( 'PrimaryKey' );
		IndexDef.Primary := True;
		IndexDef.Unique := True;
		FieldDef := PhoneTypesDef.CreateField( 'Code', dbByte );
		IndexDef.Fields.Append( FieldDef );
		PhoneTypesDef.Indexes.Append( IndexDef );

		FieldDef := PhoneTypesDef.CreateField( 'Description', dbText, 10 );
		PhoneTypesDef.Fields.Append( FieldDef );
		PhoneBookDB.TableDefs.Append( PhoneTypesDef );

		// Add data.
		PhoneBookDB.OpenRecordSet( 'PhoneTypes' );
		SQLQuery := 'INSERT INTO PhoneTypes(Code, Description) VALUES (''1'',''Business'')';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		SQLQuery := 'INSERT INTO PhoneTypes(Code, Description) VALUES (''2'',''Car'')';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		SQLQuery := 'INSERT INTO PhoneTypes(Code, Description) VALUES (''3'',''Cellular'')';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		SQLQuery := 'INSERT INTO PhoneTypes(Code, Description) VALUES (''4'',''Fax'')';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		SQLQuery := 'INSERT INTO PhoneTypes(Code, Description) VALUES (''5'',''Home'')';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		SQLQuery := 'INSERT INTO PhoneTypes(Code, Description) VALUES (''6'',''Pager'')';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		SQLQuery := 'INSERT INTO PhoneTypes(Code, Description) VALUES (''7'',''Other'')';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );

		ReportBaseDef := PhoneBookDB.CreateTableDef( 'ReportBase' );
		FieldDef := ReportBaseDef.CreateField( 'EntryID', dbInteger );
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'LastName',			dbText, 20 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'FirstName',		dbText, 15 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'Company',			dbText, 30 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'Address1',			dbText, 30 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'Address2',			dbText, 30 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'City',					dbText, 30 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'State',				dbText, 2 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'Zip',					dbText, 10 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'EMailAddress', dbText, 30 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		FieldDef := ReportBaseDef.CreateField( 'Comment',			dbText, 60 );
		FieldDef.AllowZeroLength := True;
		ReportBaseDef.Fields.Append( FieldDef );
		PhoneBookDB.TableDefs.Append( ReportBaseDef );

		ReportNumbersDef := PhoneBookDB.CreateTableDef( 'ReportNumbers' );
		FieldDef := ReportNumbersDef.CreateField( 'EntryID', dbInteger );
		ReportNumbersDef.Fields.Append( FieldDef );
		FieldDef := ReportNumbersDef.CreateField( 'PhoneNumber',	dbText, 14 );
		ReportNumbersDef.Fields.Append( FieldDef );
		FieldDef := ReportNumbersDef.CreateField( 'Extension',	dbText, 5 );
		FieldDef.AllowZeroLength := True;
		ReportNumbersDef.Fields.Append( FieldDef );
		FieldDef := ReportNumbersDef.CreateField( 'PhoneType',	dbByte );
		ReportNumbersDef.Fields.Append( FieldDef );
		FieldDef := ReportNumbersDef.CreateField( 'Notes',	dbText, 50 );
		FieldDef.AllowZeroLength := True;
		ReportNumbersDef.Fields.Append( FieldDef );
		PhoneBookDB.TableDefs.Append( ReportNumbersDef );

		IndexDef := ReportNumbersDef.CreateIndex( 'EntryID' );
		FieldDef := ReportNumbersDef.CreateField( 'EntryID',		dbInteger );
		IndexDef.Fields.Append( FieldDef );
		ReportNumbersDef.Indexes.Append( IndexDef );

		BuildPhoneBookDB := True;
	except
		BuildPhoneBookDB := False;
	end;
end;

procedure TMain.FormDestroy(Sender: TObject);

var
	i: Byte;

begin
	TableNameList.Free;
	//TableNameListStatic.Free;
	//TablesInUse.Free;
	//PhoneChildren.Free;

	if (PhoneTypeCodes <> nil) then //Only do this if no exiting application abruptly!
	begin

		for i := 0 to PhoneTypeCodes.Count - 1 do
		begin
			TPhoneTypeInfo(PhoneTypeCodes.Objects[i]).Free;
			// This statement is not needed because the above statement already frees up the same object.
			//TPhoneTypeInfo(PhoneTypeDesc.Objects[i]).Free;
		end;

		PhoneTypeCodes.Free;
		PhoneTypeDesc.Free;
		PhoneBookDB.Close;
		PBWorkspace := Null;
		DBEngine := Null;
	end;
end;

procedure TMain.Close1Click(Sender: TObject);
begin
	CurrPhoneBook.Close1Click( Sender );
end;

procedure TMain.btnFirstClick(Sender: TObject);
begin
	CurrPhoneBook.MoveFirst;
end;

procedure TMain.btnPreviousClick(Sender: TObject);
begin
	CurrPhoneBook.MovePrevious;
end;

procedure TMain.btnNextClick(Sender: TObject);
begin
	CurrPhoneBook.MoveNext;
end;

procedure TMain.btnLastClick(Sender: TObject);
begin
	CurrPhoneBook.MoveLast;
end;

procedure TMain.btnAddClick(Sender: TObject);
begin
	CurrPhoneBook.AddRecord;
end;

procedure TMain.btnDeleteClick(Sender: TObject);

var
	x, RecNo, Err, TotRecs: Integer;
	Cancel: Boolean;

begin
	Cancel := False;
	Err := 0;
	with CurrPhoneBook do
	begin
		TotRecs := iif( MarkedRecs.Count > 0, MarkedRecs.Count, 1 );

		if (MarkedRecs.Count > 0) then
		begin
			TaggedRecChanges.ChangeType := 'DELETE';

			if (TaggedRecChanges.ShowModal = mrOK) then
			begin

				if TaggedRecChanges.TaggedRecs then
				begin
					Screen.Cursor := crHourglass;

					for x := 0 to MarkedRecs.Count - 1 do
					begin
						RecNo := StrToInt( MarkedRecs.Strings[0] );
						Err := DeleteRecord( RecNo );
						if (Err <> 0) then break;
						if ( RecNo = EntryID) then MoveNext;
						MarkedRecs.Delete( 0 );
					end;

					Screen.Cursor := crDefault;
					UnTagAll1.Enabled := False;
				end
				else
				begin
					RecNo := EntryID;
					Err := DeleteRecord( RecNo );
					MoveNext;
				end;

			end
			else
				Cancel := True;

		end
		else
		begin

			if (MessageDlg( 'Are you sure you wish to DELETE this record?',
										mtWarning, [mbYes, mbNo], 0 ) = mrYes) then
			begin
				RecNo := EntryID;
				Err := DeleteRecord( RecNo );
				MoveNext;
			end
			else
				Cancel := True;

		end;

		if (Err <> 0) then
			ShowMessage( 'Error while trying to delete records.' )
		else
		begin
			if (not Cancel) then ShowMessage( IntToStr( TotRecs ) + ' Phone Book record(s) deleted.' );
		end;

	end;
end;

procedure TMain.ChangeButtonStatus( TurnOn: Boolean );

var
	ChangeOK: Boolean;

begin
	ChangeOK := False;

	if TurnOn then
	begin
		if (not btnPrint.Visible) then
			ChangeOK := True
	end
	else
		if (btnPrint.Visible and (TablesInUse.Count = 0)) then
			ChangeOK := True;

	if ChangeOK then
		begin
			btnCloseBook.Enabled	:= TurnOn;
			btnPrint.Visible			:= TurnOn;
			btnCopy.Visible				:= TurnOn;
			btnMove.Visible				:= TurnOn;
			btnFirst.Visible			:= TurnOn;
			btnPrevious.Visible		:= TurnOn;
			btnNext.Visible				:= TurnOn;
			btnLast.Visible				:= TurnOn;
			btnSearch.Visible 		:= TurnOn;
			//edtSearch.Visible		:= TurnOn;
			//edtSearch.Enabled		:= TurnOn;
			btnChecked.Visible		:= TurnOn;
			btnAdd.Visible 				:= TurnOn;
			btnDelete.Visible 		:= TurnOn;
			Edit1.Visible 				:= TurnOn;
			//View1.Visible					:= TurnOn;
			Utilities1.Enabled		:= not TurnOn; //Utilities should only be available if no Phone Books are open.
		end;

end;

procedure TMain.Undo1Click(Sender: TObject);
begin
	CurrPhoneBook.UndoChanges;
end;

procedure TMain.btnSearchClick(Sender: TObject);
begin
	PhoneSearch.ShowModal;
end;

procedure TMain.Print1Click(Sender: TObject);

var
	TempQuery: Variant;
	BaseName, NumbersName,	BaseQuery, NumbersQuery: String;

const
	RS_SUCCESS	= 0;
	RS_BUSY			= 1;

begin
	Screen.Cursor := crHourglass;
	// Blow out reporting databases and fill them in with the properly sorted info.
	BaseName := MainTablePrefix + CurrPhoneBook.TableName;
	NumbersName := NumbersTablePrefix + CurrPhoneBook.TableName;
	try
		// Clear out old report information first...
		TempQuery := PhoneBookDB.CreateQueryDef( '', 'DELETE FROM ReportBase;' );
		TempQuery.Execute( dbFailOnError );
		TempQuery := PhoneBookDB.CreateQueryDef( '', 'DELETE FROM ReportNumbers;' );
		TempQuery.Execute( dbFailOnError );
		// Import all the base phonebook information...
		BaseQuery := 'INSERT INTO ReportBase ( EntryID, LastName, FirstName, Company, Address1, Address2, City, State, Zip, ' +
									'EMailAddress, Comment ) SELECT ' + BaseName + '.EntryID, ' + BaseName + '.LastName, ' +
									BaseName + '.FirstName, ' + BaseName + '.Company, ' + BaseName + '.Address1, ' + BaseName + '.Address2, ' +
									BaseName + '.City, ' + BaseName + '.State, ' + BaseName + '.Zip, ' + BaseName + '.EMailAddress, ' +
									BaseName + '.Comment FROM ' + BaseName + ' ORDER BY ' +
												'[' + BaseName + '].[Company]+[' + BaseName + '].[LastName]+[' + BaseName + '].[FirstName];';
		{BaseQuery := 'INSERT INTO ReportBase ( EntryID, LastName, FirstName, Company, Address1, Address2, City, State, Zip, ' +
									'EMailAddress, Comment ) SELECT ' + BaseName + '.EntryID, ' + BaseName + '.LastName, ' +
									BaseName + '.FirstName, ' + BaseName + '.Company, ' + BaseName + '.Address1, ' + BaseName + '.Address2, ' +
									BaseName + '.City, ' + BaseName + '.State, ' + BaseName + '.Zip, ' + BaseName + '.EMailAddress, ' +
									BaseName + '.Comment FROM ' + BaseName + ' ORDER BY IIf(Trim$([' + BaseName + '].[Company])<>'''',' +
									'[' + BaseName + '].[Company],[' + BaseName + '].[LastName]+[' + BaseName + '].[FirstName]);';}
		TempQuery := PhoneBookDB.CreateQueryDef( '', BaseQuery );
		TempQuery.Execute( dbFailOnError );
		// Import all the phone number information...
		NumbersQuery := 'INSERT INTO ReportNumbers ( EntryID, PhoneNumber, PhoneType, Extension, Notes ) ' +
										'SELECT ' + NumbersName + '.EntryID, ' + NumbersName + '.PhoneNumber, ' +
										NumbersName + '.PhoneType, ' + NumbersName + '.Extension, ' + NumbersName + '.Notes ' +
										'FROM ' + NumbersName + ';';
		TempQuery := PhoneBookDB.CreateQueryDef( '', NumbersQuery );
		TempQuery.Execute( dbFailOnError );
		// Create fake phone numbers "(000) 000-0000" for those entries in the PhoneBase that
		// have no Phone Numbers listed so that they will show up in the phone listing, anyway.
		{NumbersQuery := 'INSERT INTO ReportNumbers ( EntryID, PhoneNumber, PhoneType, Extension, Notes ) ' +
										'SELECT ' + BaseName + '.EntryID, ''(000) 000-0000'', 7, '''', '''' ' +
										'FROM ' + BaseName + ' ' +
										'WHERE ' + BaseName + '.EntryID NOT IN (SELECT ' + NumbersName + '.EntryID FROM ' + NumbersName + ')' + ';';
		TempQuery := PhoneBookDB.CreateQueryDef( '', NumbersQuery );
		TempQuery.Execute( dbFailOnError );}
		QRPhoneReport.PBRpt.Preview;

		{with PhoneReport do
		begin
			InitialValues.Clear;
			InitialValues.Add( '@ReportOwner = <'	+	CurrPhoneBook.TableName +	'>' );
			//InitialValues.Add( '@PhoneBookName = <'	+			MainTablePrefix +	OwnerName +			'>' );
			//InitialValues.Add( '@PhoneNumbersName = <' +	NumbersTablePrefix + OwnerName +	'>' );
			//RunMacro( '"RunMacro", "SetPhoneBook", " "' );
			ReCalcReport;
			PhoneReport.Run;
		end;}
	finally
			Screen.Cursor := crDefault;
	end;

end;

procedure TMain.Exit1Click(Sender: TObject);
begin
	DBEngine := Unassigned;
	Close;
end;

procedure TMain.New1Click(Sender: TObject);
begin
	NewPhoneBookDlg.ShowModal;
end;

procedure TMain.DeletePBTableClick(Sender: TObject);
begin
	DeleteTable.ShowModal;
end;

procedure TMain.btnCheckedClick(Sender: TObject);
begin

	with CurrPhoneBook do
	begin

		if (btnChecked.Caption = 'Tag') then
		begin
			MarkedRecs.Add( IntToStr( EntryID ) );
			btnChecked.Caption := 'UnTag';
			Tag1.Caption := '&UnTag';
		end
		else //Unmark record.
		begin
			MarkedRecs.Delete( MarkedRecs.IndexOf( IntToStr( EntryID ) ) );
			btnChecked.Caption := 'Tag';
			Tag1.Caption := '&Tag';
		end;

		UnTagAll1.Enabled := (MarkedRecs.Count > 0)
	end;
end;

procedure TMain.btnCopyClick(Sender: TObject);

var
	x, Err, TotRecs: Integer;
	Cancel: Boolean;

begin
	Cancel := False;
	Err := 0;
	with CurrPhoneBook do
	begin
		TotRecs := iif( MarkedRecs.Count > 0, MarkedRecs.Count, 1 );

		if (TableNameListStatic.Count > 1) then
		begin

			if (DestTable.ShowModal = mrOK) then
			begin

				if (MarkedRecs.Count > 0) then
				begin
					TaggedRecChanges.ChangeType := 'COPY';

					if (TaggedRecChanges.ShowModal = mrOK) then
					begin

						if TaggedRecChanges.TaggedRecs then
						begin
							Screen.Cursor := crHourglass;

							for x := 0 to MarkedRecs.Count - 1 do
							begin
								Err := CopyRecord( DestTable.TableName, StrToInt( MarkedRecs.Strings[x] ) );
								if (Err <> 0) then break;
							end;

							Screen.Cursor := crDefault;
						end
						else
							Err := CopyRecord( DestTable.TableName, EntryID );
					end;

				end
				else
					Err := CopyRecord( DestTable.TableName, EntryID );
			end
			else
				Cancel := True;

			if (Err <> 0) then
				ShowMessage( 'Error while trying to copy records.' )
			else
			begin
				if (not Cancel) then ShowMessage( IntToStr( TotRecs ) + ' Phone Book record(s) copied.' );
			end;

		end

		else
			ShowMessage( 'There are no other tables to allow a COPY!' );
	end;

end;

procedure TMain.btnMoveClick(Sender: TObject);

var
	x, RecNo, Err, TotRecs: Integer;
	Cancel : Boolean;

begin
	Cancel := False;
	Err := 0;
	with CurrPhoneBook do
	begin
		TotRecs := iif( MarkedRecs.Count > 0, MarkedRecs.Count, 1 );

		if (TableNameListStatic.Count > 1) then
		begin

			if (DestTable.ShowModal = mrOK) then
			begin

				if (MarkedRecs.Count > 0) then
				begin
					TaggedRecChanges.ChangeType := 'MOVE';

					if (TaggedRecChanges.ShowModal = mrOK) then
					begin

						if TaggedRecChanges.TaggedRecs then
						begin
							Screen.Cursor := crHourglass;

							for x := 0 to MarkedRecs.Count - 1 do
							begin
								Err := CopyRecord( DestTable.TableName, StrToInt( MarkedRecs.Strings[0] ) );
								if (Err <> 0) then break;
								RecNo := StrToInt( MarkedRecs.Strings[0] );
								Err := DeleteRecord( RecNo );
								if (RecNo = EntryID) then MoveNext;
								if (Err <> 0) then break;
								MarkedRecs.Delete( 0 );
							end;

							Screen.Cursor := crDefault;
						end
						else
						begin
							Err := CopyRecord( DestTable.TableName, EntryID );

							if (Err = 0) then
							begin
								RecNo := EntryID;
								Err := DeleteRecord( RecNo );
								MoveNext;
							end;

						end;
					end;

				end
				else
				begin
					Err := CopyRecord( DestTable.TableName, EntryID );

					if (Err = 0) then
					begin
						RecNo := EntryID;
						Err := DeleteRecord( RecNo );
						MoveNext;
					end;

				end;
			end
			else
				Cancel := True;

			if (Err <> 0) then
				ShowMessage( 'Error while trying to move records.' )
			else
			begin
				if (not Cancel) then ShowMessage( IntToStr( TotRecs ) + ' Phone Book record(s) moved.' );
			end;

		end
		else
			ShowMessage( 'There are no other tables to allow a MOVE!' );
	end;

end;

procedure TMain.UntagAll1Click(Sender: TObject);
begin
	CurrPhoneBook.MarkedRecs.Clear;
	UntagAll1.Enabled := False;

	if (btnChecked.Caption = 'UnTag') then
	begin
		btnChecked.Caption := 'Tag';
		Tag1.Caption := '&Tag';
	end;

end;

procedure TMain.PackDatabase1Click(Sender: TObject);
begin

	if (MessageDlg( 'Are you sure you wish to PACK the database now?', mtWarning, [mbYes, mbNo], 0 ) = mrYes) then
	begin
		try

			if (FileExists( AppPath + 'PhoneBook.mdb' )) then
			begin
				Screen.Cursor := crHourglass;
				PhoneBookDB.Close;
				DBEngine.CompactDatabase( AppPath + 'PhoneBook.mdb', 'NewPB.mdb' );
				DeleteFile( PChar(AppPath + 'OldPB.mdb') );
				RenameFile( AppPath + 'PhoneBook.mdb', AppPath + 'OldPB.mdb' );
				RenameFile( AppPath + 'NewPB.mdb', AppPath + 'PhoneBook.mdb' );
				PhoneBookDB := PBWorkspace.OpenDatabase( AppPath + 'PhoneBook.mdb' );
				Screen.Cursor := crDefault;
				ShowMessage( 'The Phone Book database has been PACKED.' );
			end
			else
				ShowMessage( 'ERROR - Phone Book database cannot be found.' );

		except
			Screen.Cursor := crDefault;
			ShowMessage( 'Error while trying to pack Phone Book database.' );
		end;
	end;

end;

procedure TMain.RepairDatabase1Click(Sender: TObject);
begin

	if (MessageDlg( 'Are you sure you wish to REPAIR the database now?', mtWarning, [mbYes, mbNo], 0 ) = mrYes) then
	begin
		try

			if (FileExists( AppPath + 'PhoneBook.mdb' )) then
			begin
				Screen.Cursor := crHourglass;
				PhoneBookDB.Close;
				DBEngine.RepairDatabase( AppPath + 'PhoneBook.mdb' );
				DBEngine.CompactDatabase( AppPath + 'PhoneBook.mdb', 'NewPB.mdb' );
				DeleteFile( PChar(AppPath + 'OldPB.mdb') );
				RenameFile( AppPath + 'PhoneBook.mdb', AppPath + 'OldPB.mdb' );
				RenameFile( AppPath + 'NewPB.mdb', AppPath + 'PhoneBook.mdb' );
				PhoneBookDB := PBWorkspace.OpenDatabase( AppPath + 'PhoneBook.mdb' );
				Screen.Cursor := crDefault;
				ShowMessage( 'The Phone Book database has been REPAIRED.' );
			end
			else
				ShowMessage( 'ERROR - Phone Book database cannot be found.' );
		except
			Screen.Cursor := crDefault;
			ShowMessage( 'Error while trying to repair Phone Book database.' );
		end;

	end;

end;

procedure TMain.Rename1Click(Sender: TObject);
begin
	RenameTableChoices.ShowModal;
end;

end.
