unit Phnbook;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Mask, DBCtrls, DB,
	DBTables, PhoneGrid, Report;

type

	TPhoneInfo = class(TObject)
		EntryID: Integer;
		PhoneType: Byte;
		PhoneNumber: String[10];
		Extension: String[5];
		Notes: String;
	end;

	TPhoneBook = class(TForm)
		Label1: TLabel;
		Label3: TLabel;
		Label4: TLabel;
		Label5: TLabel;
		Label6: TLabel;
		Label7: TLabel;
		Label8: TLabel;
		Label9: TLabel;
		Label10: TLabel;
		lbPhoneNumbers: TListBox;
		cmdAddNumber: TBitBtn;
		btnRemoveNumber: TBitBtn;
		btnEditNumber: TBitBtn;
		edtLastName: TEdit;
		edtFirstName: TEdit;
		edtCompany: TEdit;
		edtAddress1: TEdit;
		edtAddress2: TEdit;
		edtCity: TEdit;
		edtState: TEdit;
		edtComment: TEdit;
		Label2: TLabel;
		edtEMailAddress: TEdit;
		edtZipCode: TMaskEdit;
    MainMenu1: TMainMenu;
    View1: TMenuItem;
    Sort1: TMenuItem;
    CompanyIndex: TMenuItem;
    FirstNameIndex: TMenuItem;
    LastNameIndex: TMenuItem;
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure Close1Click(Sender: TObject);
		procedure cmdAddNumberClick(Sender: TObject);
		procedure btnRemoveNumberClick(Sender: TObject);
		procedure lbPhoneNumbersClick(Sender: TObject);
		procedure btnEditNumberClick(Sender: TObject);
		procedure FormActivate(Sender: TObject);
		procedure edtLastNameExit(Sender: TObject);
		procedure edtFirstNameExit(Sender: TObject);
		procedure edtCompanyExit(Sender: TObject);
		procedure edtAddress1Exit(Sender: TObject);
		procedure edtAddress2Exit(Sender: TObject);
		procedure edtCityExit(Sender: TObject);
		procedure edtStateExit(Sender: TObject);
		procedure edtZipCodeExit(Sender: TObject);
		procedure edtCommentExit(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure edtEMailAddressExit(Sender: TObject);
		procedure edtLastNameChange(Sender: TObject);
		procedure edtFirstNameChange(Sender: TObject);
		procedure edtEMailAddressChange(Sender: TObject);
		procedure edtCompanyChange(Sender: TObject);
		procedure edtCommentChange(Sender: TObject);
		procedure edtCityChange(Sender: TObject);
		procedure edtAddress2Change(Sender: TObject);
		procedure edtAddress1Change(Sender: TObject);
		procedure edtStateChange(Sender: TObject);
		procedure edtZipCodeChange(Sender: TObject);
		procedure Tag1Click(Sender: TObject);
		procedure LastNameIndexClick(Sender: TObject);
    procedure FirstNameIndexClick(Sender: TObject);
    procedure CompanyIndexClick(Sender: TObject);
    procedure edtLastNameKeyPress(Sender: TObject; var Key: Char);
	private
		{ Private declarations }
		OldLastName: String[20];
		OldFirstName: String[15];
		OldCompany: String[30];
		OldAddress1: String[30];
		OldAddress2: String[30];
		OldCity: String[30];
		OldState: String[2];
		OldZipCode: String[10];
		OldComment: String[60];
		OldEMailAddress: String[30];
		NewRecord: Boolean;
		LastNameChanged, FirstNameChanged, CompanyChanged, Address1Changed, Address2Changed,
			CityChanged, StateChanged, ZipCodeChanged, CommentChanged, EMailAddressChanged: Boolean;
		FCurrIndex: ANSIString;
		FEntryID: Integer;
		FTableName: String;
		procedure ClearPhoneNumbers;
		procedure ClearPhoneChanges;
	public
		{ Public declarations }
		PhoneBase: Variant;
		PhoneNumbers: Variant;
		PhoneChanges: TList;
		MarkedRecs: TStringList;
		property CurrIndex: ANSIString read FCurrIndex write FCurrIndex;
		property EntryID: Integer read FEntryID write FEntryID;
		property TableName: String read FTableName write FTableName;
		procedure GetPhoneInfo;
		procedure ClearPhoneInfo;
		procedure GetBaseData;
		procedure GetPhoneNumberList;
		procedure UndoChanges;
		procedure AddRecord;
		function CopyRecord( DestTableName: String; RecNo: Integer ): Integer;
		function DeleteRecord( RecNo: Integer ): Integer;
		procedure MoveFirst;
		procedure MovePrevious;
		procedure MoveNext;
		procedure MoveLast;
		function AddPhoneNumber( PhoneInfo: TPhoneInfo ): Boolean;
		function ModifyPhoneNumber( PhoneInfo, OldPhoneInfo: TPhoneInfo ): Boolean;
		function DeletePhoneNumber( PhoneInfo: TPhoneInfo ): Boolean;
	end;

	TChange = (AddRec, ModifyRec, DeleteRec);

	TPhoneChange = class(TObject)
		ChangeType: TChange;
		PhoneInfo: TPhoneInfo;
		OldPhoneInfo: TPhoneInfo;
	end;

	const
		PhoneBasePKIndex		= 'PrimaryKey';
		PhoneBaseLNIndex		= 'LastName';
		PhoneBaseFNIndex		= 'FirstName';
		PhoneBaseCOIndex		= 'Company';
		PhoneNumberPKIndex	= 'PrimaryKey';
		PhoneNumberIDIndex	= 'EntryID';

implementation

uses
	PhnMain, AddNmbr, GeneralLib;
{$R *.DFM}


procedure TPhoneBook.FormClose(Sender: TObject;	var Action: TCloseAction);

var
	TableName: String;

begin
	Action := caFree;
	//UpdatePhoneBook;
	ClearPhoneNumbers;
	PhoneNumbers.Close;
	PhoneBase.Close;
	TableName := Copy( self.Caption, 1, Pos( '''', self.Caption ) - 1 );
	//PhoneChildren.Delete(PhoneChildren.IndexOf( TableName ));
	{Replace table name as option from which to choose.}
	TableNameList.Add( TableName );
	TablesInUse.Delete( TablesInUse.IndexOf( TableName ) );
	Main.ChangeButtonStatus( False );
	PhoneChanges.Free;
	MarkedRecs.Free;
end;

procedure TPhoneBook.Close1Click(Sender: TObject);
begin
	Close;
end;

procedure TPhoneBook.GetBaseData;

begin
	EntryID								:= GetVarInteger( PhoneBase.Fields[Field_EntryID].Value );
	edtLastName.Text			:= GetVarString( PhoneBase.Fields[Field_LastName].Value );
	edtFirstName.Text 		:= GetVarString( PhoneBase.Fields[Field_FirstName].Value );
	edtCompany.Text				:= GetVarString( PhoneBase.Fields[Field_Company].Value );
	edtAddress1.Text			:= GetVarString( PhoneBase.Fields[Field_Address1].Value );
	edtAddress2.Text			:= GetVarString( PhoneBase.Fields[Field_Address2].Value );
	edtCity.Text					:= GetVarString( PhoneBase.Fields[Field_City].Value );
	edtState.Text					:= GetVarString( PhoneBase.Fields[Field_State].Value );
	edtZipCode.Text				:= GetVarString( PhoneBase.Fields[Field_Zip].Value );
	edtComment.Text				:= GetVarString( PhoneBase.Fields[Field_Comment].Value );
	edtEMailAddress.Text	:= GetVarString( PhoneBase.Fields[Field_EMailAddress].Value );
	//Reset "Old" text values to allow for checking if changes were made.
	OldLastName			:= edtLastName.Text;
	OldFirstName		:= edtFirstName.Text;
	OldCompany			:= edtCompany.Text;
	OldAddress1			:= edtAddress1.Text;
	OldAddress2			:= edtAddress2.Text;
	OldCity					:= edtCity.Text;
	OldState				:= edtState.Text;
	OldZipCode			:= edtZipCode.Text;
	OldComment			:= edtComment.Text;
	OldEMailAddress := edtEMailAddress.Text;
	LastNameChanged			:= False;
	FirstNameChanged		:= False;
	CompanyChanged			:= False;
	Address1Changed			:= False;
	Address2Changed			:= False;
	CityChanged					:= False;
	StateChanged				:= False;
	ZipCodeChanged			:= False;
	CommentChanged			:= False;
	EMailAddressChanged	:= False;

	if (MarkedRecs.IndexOf( IntToStr( EntryID ) ) <> -1) then
		Main.btnChecked.Caption := 'UnTag'
	else
		Main.btnChecked.Caption := 'Tag'

end;

procedure TPhoneBook.GetPhoneInfo;
begin
	GetBaseData;
	GetPhoneNumberList;
	ClearPhoneChanges;
	edtLastName.SetFocus;
end;

procedure TPhoneBook.ClearPhoneInfo;
begin
	edtLastName.Text			:= '';
	edtFirstName.Text			:= '';
	edtCompany.Text				:= '';
	edtAddress1.Text			:= '';
	edtAddress2.Text			:= '';
	edtCity.Text					:= '';
	edtState.Text					:= '';
	edtZipCode.Text				:= '';
	edtComment.Text				:= '';
	edtEMailAddress.Text	:= '';
end;

procedure TPhoneBook.GetPhoneNumberList;

var
	bContinue: Boolean;
	PhoneNumber: String[10];
	PhoneNumberFmt: String[14];
	Extension: String[5];
	ExtensionFmt: String[6];
	PhoneType: String[10];
	PhoneInfo: TPhoneInfo;
	Notes: String;

begin
	ClearPhoneNumbers;
	PhoneNumbers.Seek( '=', EntryID );
	bContinue := not VarAsType(PhoneNumbers.NoMatch, varBoolean);
	//PhoneInfo := TPhoneInfo.Create;

	while bContinue and (VarAsType(PhoneNumbers.Fields[Field_EntryID].Value, varInteger)= EntryID) do
	begin
		PhoneNumber := GetVarString( PhoneNumbers.Fields[Field_PhoneNumber].Value );
		PhoneNumberFmt := ExpandPhone( PhoneNumber );
		Extension := GetVarString( PhoneNumbers.Fields[Field_Extension].Value );
		ExtensionFmt := iif( Trim( Extension ) <> '', 'x' + Extension, '' );
		Notes := GetVarString( PhoneNumbers.Fields[Field_Notes].Value );
		PhoneType := TPhoneTypeInfo(PhoneTypeCodes.Objects[PhoneTypeCodes.IndexOf(
									GetVarString( PhoneNumbers.Fields[Field_PhoneType].Value ) )]).Description;
		PhoneInfo := TPhoneInfo.Create;
		PhoneInfo.EntryID := EntryID;
		PhoneInfo.PhoneType := VarAsType( PhoneNumbers.Fields[Field_PhoneType].Value, varByte );
		PhoneInfo.PhoneNumber := PhoneNumber;
		PhoneInfo.Extension := Extension;
		PhoneInfo.Notes := Notes;
		lbPhoneNumbers.Items.AddObject(	Format( '%-8.8s: %-14.14s %-6.6s %s', [PhoneType, PhoneNumberFmt, ExtensionFmt, Notes] ),
																				PhoneInfo );
		PhoneNumbers.MoveNext;
		bContinue := not VarAsType(PhoneNumbers.EOF, varBoolean);
	end;

	//PhoneInfo.Free; // Destroyed when Phone Numbers are cleared.
end;

procedure TPhoneBook.cmdAddNumberClick(Sender: TObject);
begin
	AddPhoneDlg.NewRecord := True;
	AddPhoneDlg.ShowModal;
end;

procedure TPhoneBook.btnEditNumberClick(Sender: TObject);
begin
	AddPhoneDlg.NewRecord := False;
	AddPhoneDlg.ShowModal;
end;

procedure TPhoneBook.btnRemoveNumberClick(Sender: TObject);

var
	wResult: Word;
	UserString: ANSIString;
	Counter: Byte;
	DeletedPhone: TPhoneChange;

begin

	if (lbPhoneNumbers.SelCount = 0) then
		wResult := mrNo
	else
	begin

		if (lbPhoneNumbers.SelCount > 1) then
			UserString := 'these Phone Numbers'
		else
			UserString := 'this Phone Number';

		wResult := MessageDlg( 'Are you sure you wish to delete ' +
																UserString + '?', mtWarning, [mbYes, mbNo], 0 );
	end;

	if wResult = mrYes then
	begin

		for Counter := lbPhoneNumbers.Items.Count - 1 downto 0 do
		begin

			if lbPhoneNumbers.Selected[Counter] then
			begin
				DeletedPhone := TPhoneChange.Create;
				DeletedPhone.ChangeType := DeleteRec;
				DeletedPhone.PhoneInfo := TPhoneInfo.Create;
				with TPhoneInfo(lbPhoneNumbers.Items.Objects[Counter]) do
				begin
					DeletedPhone.PhoneInfo.EntryID			:= EntryID;
					DeletedPhone.PhoneInfo.PhoneType		:= PhoneType;
					DeletedPhone.PhoneInfo.PhoneNumber	:= PhoneNumber;
					DeletedPhone.PhoneInfo.Extension		:= Extension;
					DeletedPhone.PhoneInfo.Notes				:= Notes;
				end;
				//DeletedPhone.PhoneInfo := TPhoneInfo(lbPhoneNumbers.Items.Objects[Counter]);
				DeletePhoneNumber( DeletedPhone.PhoneInfo );
				lbPhoneNumbers.Items.Delete( Counter );
				PhoneChanges.Add( DeletedPhone );
			end;

		end;

		//DeletedPhone.Free; // Destroyed when changes are cleared.
	end;

end;

procedure TPhoneBook.lbPhoneNumbersClick(Sender: TObject);
begin

	if (lbPhoneNumbers.SelCount > 0) then
		begin
			btnEditNumber.Enabled := True;
			btnRemoveNumber.Enabled := True;
		end
	else
		begin
			btnEditNumber.Enabled := False;
			btnRemoveNumber.Enabled := False;
		end

end;

procedure TPhoneBook.ClearPhoneNumbers;

var
	i: Byte;

begin

	if (lbPhoneNumbers.Items.Count > 0) then
	begin

		for i := 0 to lbPhoneNumbers.Items.Count - 1 do
			TPhoneInfo(lbPhoneNumbers.Items.Objects[i]).Free;

		lbPhoneNumbers.Clear;
		btnEditNumber.Enabled := False;
		btnRemoveNumber.Enabled := False;
	end;

end;

procedure TPhoneBook.ClearPhoneChanges;

var
	i: Byte;

begin

	if (PhoneChanges.Count > 0) then
	begin

		for i := 0 to PhoneChanges.Count - 1 do
		begin

			if TPhoneChange(PhoneChanges.Items[i]).ChangeType = ModifyRec then
				TPhoneInfo(TPhoneChange(PhoneChanges.Items[i]).OldPhoneInfo).Free;

			TPhoneInfo(TPhoneChange(PhoneChanges.Items[i]).PhoneInfo).Free;
			TPhoneChange(PhoneChanges.Items[i]).Free;
		end;

		PhoneChanges.Clear;
	end;

end;

function TPhoneBook.AddPhoneNumber( PhoneInfo: TPhoneInfo ): Boolean;

var
	OldIndex: ANSIString;

begin
	Screen.Cursor := crHourglass;
	AddPhoneNumber := False;
	try
		OldIndex := PhoneNumbers.Index;
		PhoneNumbers.Index := PhoneNumberPKIndex;
		PhoneNumbers.Seek( '=', EntryID, PhoneInfo.PhoneNumber, PhoneInfo.Extension );
		PhoneNumbers.Index := OldIndex;

		if VarAsType( PhoneNumbers.NoMatch, varBoolean ) then
		begin
			PhoneNumbers.AddNew;
			PhoneNumbers.Fields[Field_EntryID].Value			:= PhoneInfo.EntryID;
			PhoneNumbers.Fields[Field_PhoneType].Value		:= PhoneInfo.PhoneType;
			PhoneNumbers.Fields[Field_PhoneNumber].Value	:= PhoneInfo.PhoneNumber;
			PhoneNumbers.Fields[Field_Extension].Value		:= PhoneInfo.Extension;
			PhoneNumbers.Fields[Field_Notes].Value				:= PhoneInfo.Notes;
			PhoneNumbers.Update;
			AddPhoneNumber := True;
		end;

	except
		Screen.Cursor := crDefault;
		ShowMessage( 'Error while trying to Add Phone Number ' +
									ExpandPhone( PhoneInfo.PhoneNumber ) + ' ' +
									iif( Trim( PhoneInfo.Extension ) <> '', 'x', '' ) +
									Trim( PhoneInfo.Extension ) + '.' );
	end;

	Screen.Cursor := crDefault;
end;

function TPhoneBook.ModifyPhoneNumber( PhoneInfo, OldPhoneInfo: TPhoneInfo ): Boolean;

var
	OldIndex: ANSIString;
	BookMark: Variant; //ANSIString;

begin
	Screen.Cursor := crHourglass;
	ModifyPhoneNumber := False;
	try
		OldIndex := PhoneNumbers.Index;
		PhoneNumbers.Index := PhoneNumberPKIndex;
		PhoneNumbers.Seek( '=', EntryID, OldPhoneInfo.PhoneNumber, OldPhoneInfo.Extension );

		if (not VarAsType( PhoneNumbers.NoMatch, varBoolean )) then
		begin
			BookMark := PhoneNumbers.BookMark;
			PhoneNumbers.Edit;
			PhoneNumbers.Fields[Field_PhoneType].Value		:= PhoneInfo.PhoneType;
			PhoneNumbers.Fields[Field_PhoneNumber].Value	:= PhoneInfo.PhoneNumber;
			PhoneNumbers.Fields[Field_Extension].Value		:= PhoneInfo.Extension;
			PhoneNumbers.Fields[Field_Notes].Value				:= PhoneInfo.Notes;
			PhoneNumbers.Update;
			ModifyPhoneNumber := True;
			PhoneNumbers.Index := OldIndex;
			PhoneNumbers.BookMark := VarAsType( BookMark, varOleStr );
		end
		else
			PhoneNumbers.Index := OldIndex;

	except
		Screen.Cursor := crDefault;
		ShowMessage( 'Error while trying to Modify Phone Number ' +
									ExpandPhone( PhoneInfo.PhoneNumber ) + ' ' +
									iif( Trim( PhoneInfo.Extension ) <> '', 'x', '' ) +
									Trim( PhoneInfo.Extension ) + '.' );
	end;

	Screen.Cursor := crDefault;
end;

function TPhoneBook.DeletePhoneNumber( PhoneInfo: TPhoneInfo ): Boolean;

var
	OldIndex: ANSIString;

begin
	Screen.Cursor := crHourglass;
	DeletePhoneNumber := False;
	try
		OldIndex := PhoneNumbers.Index;
		PhoneNumbers.Index := PhoneNumberPKIndex;
		PhoneNumbers.Seek( '=', EntryID, PhoneInfo.PhoneNumber, PhoneInfo.Extension );

		if (not VarAsType( PhoneNumbers.NoMatch, varBoolean )) then
		begin
			PhoneNumbers.Delete;
			DeletePhoneNumber := True;
		end;

		PhoneNumbers.Index := OldIndex;
	except
		Screen.Cursor := crDefault;
		ShowMessage( 'Error while trying to Delete Phone Number ' +
									ExpandPhone( PhoneInfo.PhoneNumber ) + ' ' +
									iif( Trim( PhoneInfo.Extension ) <> '', 'x', '' ) +
									Trim( PhoneInfo.Extension ) + '.' );
	end;

	Screen.Cursor := crDefault;
end;

procedure TPhoneBook.FormActivate(Sender: TObject);
begin
	CurrPhoneBook := self; //Make sure the most recently focused Phone Book is the one acted upon.
	with Main do
	begin

		if (MarkedRecs.IndexOf( IntToStr( EntryID ) ) <> -1) then
		begin
			btnChecked.Caption := 'UnTag';
			Tag1.Caption := '&UnTag';
			UnTagAll1.Enabled := (MarkedRecs.Count > 0);
		end
		else
		begin
			btnChecked.Caption := 'Tag';
			Tag1.Caption := '&Tag';
			UnTagAll1.Enabled := (MarkedRecs.Count > 0);
		end;

	end;

end;

procedure TPhoneBook.edtLastNameExit(Sender: TObject);
begin

	if ((OldLastName <> edtLastName.Text) and LastNameChanged) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_LastName].Value	:= edtLastName.Text;
		PhoneBase.Update;
	end;

	LastNameChanged := False;
end;

procedure TPhoneBook.edtFirstNameExit(Sender: TObject);
begin

	if ((OldFirstName <> edtFirstName.Text) and FirstNameChanged) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_FirstName].Value	:= edtFirstName.Text;
		PhoneBase.Update;
	end;

	FirstNameChanged := False;
end;

procedure TPhoneBook.edtCompanyExit(Sender: TObject);
begin

	if ((OldCompany <> edtCompany.Text) and CompanyChanged) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_Company].Value	:= edtCompany.Text;
		PhoneBase.Update;
	end;

	CompanyChanged := False;
end;

procedure TPhoneBook.edtAddress1Exit(Sender: TObject);
begin

	if ((OldAddress1 <> edtAddress1.Text) and Address1Changed) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_Address1].Value	:= edtAddress1.Text;
		PhoneBase.Update;
	end;

	Address1Changed := False;
end;

procedure TPhoneBook.edtAddress2Exit(Sender: TObject);
begin

	if ((OldAddress2 <> edtAddress2.Text) and Address2Changed) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_Address2].Value	:= edtAddress2.Text;
		PhoneBase.Update;
	end;

	Address2Changed := False;
end;

procedure TPhoneBook.edtCityExit(Sender: TObject);
begin

	if ((OldCity <> edtCity.Text) and CityChanged) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_City].Value	:= edtCity.Text;
		PhoneBase.Update;
	end;

	CityChanged := False;
end;

procedure TPhoneBook.edtStateExit(Sender: TObject);
begin

	if ((OldState <> edtState.Text) and StateChanged) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_State].Value	:= edtState.Text;
		PhoneBase.Update;
	end;

	StateChanged := False;
end;

procedure TPhoneBook.edtZipCodeExit(Sender: TObject);
begin

	if ((OldZipCode <> edtZipCode.Text) and ZipCodeChanged) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_Zip].Value	:= edtZipCode.Text;
		PhoneBase.Update;
	end;

	ZipCodeChanged := False;
end;

procedure TPhoneBook.edtCommentExit(Sender: TObject);
begin

	if ((OldComment <> edtComment.Text) and CommentChanged) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_Comment].Value	:= edtComment.Text;
		PhoneBase.Update;
	end;

	CommentChanged := False;
end;

procedure TPhoneBook.edtEMailAddressExit(Sender: TObject);
begin

	if ((OldEMailAddress <> edtEMailAddress.Text) and EMailAddressChanged) then
	begin
		PhoneBase.Edit;
		PhoneBase.Fields[Field_EMailAddress].Value	:= edtEMailAddress.Text;
		PhoneBase.Update;
	end;

	EMailAddressChanged := False;
end;

procedure TPhoneBook.UndoChanges;

var
	i: Byte;

begin
	edtLastName.Text			:= OldLastName;
	edtFirstName.Text 		:= OldFirstName;
	edtCompany.Text				:= OldCompany;
	edtAddress1.Text			:= OldAddress1;
	edtAddress2.Text			:= OldAddress2;
	edtCity.Text					:= OldCity;
	edtState.Text					:= OldState;
	edtZipCode.Text				:= OldZipCode;
	edtComment.Text				:= OldComment;
	edtEMailAddress.Text	:= OldEMailAddress;

	PhoneBase.Edit;
	PhoneBase.Fields[Field_LastName].Value			:= edtLastName.Text;
	PhoneBase.Fields[Field_FirstName].Value			:= edtFirstName.Text;
	PhoneBase.Fields[Field_Company].Value				:= edtCompany.Text;
	PhoneBase.Fields[Field_Address1].Value			:= edtAddress1.Text;
	PhoneBase.Fields[Field_Address2].Value			:= edtAddress2.Text;
	PhoneBase.Fields[Field_City].Value					:= edtCity.Text;
	PhoneBase.Fields[Field_State].Value					:= edtState.Text;
	PhoneBase.Fields[Field_Zip].Value						:= edtZipCode.Text;
	PhoneBase.Fields[Field_Comment].Value				:= edtComment.Text;
	PhoneBase.Fields[Field_EMailAddress].Value	:= edtEMailAddress.Text;
	PhoneBase.Update;

	// Go through PhoneChanges and undo everything; must be down in reverse order of actual events.
	if (PhoneChanges.Count > 0) then
	begin

		for i := PhoneChanges.Count - 1 downto 0 do
		begin
			with TPhoneChange(PhoneChanges.Items[i]) do
			begin

				case ChangeType of
					AddRec:			DeletePhoneNumber( PhoneInfo );
					ModifyRec:	ModifyPhoneNumber( OldPhoneInfo, PhoneInfo );
					DeleteRec:	AddPhoneNumber( PhoneInfo );
				end;

			end;
		end;

	end;

	GetPhoneNumberList;
end;

procedure TPhoneBook.AddRecord;

begin
	PhoneBase.Index := PhoneBasePKIndex;

	if (PhoneBase.RecordCount > 0) then
	begin
		PhoneBase.MoveLast;
		EntryID := VarAsType( PhoneBase.Fields[Field_EntryID].Value, varInteger ) + 1;
	end
	else
		EntryID := 1;

	ClearPhoneInfo;
	ClearPhoneNumbers;
	PhoneBase.AddNew;
	PhoneBase.Fields[Field_EntryID].Value := EntryID;
	PhoneBase.Fields[Field_Company].Value := ''; // Ensure that no NULLs will be left in the key fields.
	PhoneBase.Fields[Field_LastName].Value := '';
	PhoneBase.Fields[Field_FirstName].Value := '';
	PhoneBase.Update; // Add blank record
	PhoneBase.Move( 0, VarAsType( PhoneBase.LastModified, varOleStr ) );
	PhoneBase.Index := CurrIndex;
	NewRecord := True;
	edtLastName.SetFocus;
end;

function TPhoneBook.DeleteRecord( RecNo: Integer ): Integer;

var
	SrcBaseTable, SrcNumberTable, SQLQuery: String;

begin
	try
		SrcBaseTable := MainTablePrefix + TableName;
		SrcNumberTable := NumbersTablePrefix + TableName;
		SQLQuery := 'DELETE FROM ' + SrcNumberTable + ' ' +
								'WHERE EntryID = ' + IntToStr( RecNo ) + ';';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		SQLQuery := 'DELETE FROM ' + SrcBaseTable + ' ' +
								'WHERE EntryID = ' + IntToStr( RecNo ) + ';';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		DeleteRecord := 0;
		NewRecord := False;
	except
		DeleteRecord := -1;
	end;
end;

procedure TPhoneBook.MoveFirst;

begin
	try
		edtLastName.SetFocus;
		edtFirstName.SetFocus;
		edtLastName.SetFocus; // Make sure that focus is lost from last edited control.
		PhoneBase.MoveFirst;
		GetPhoneInfo;
	except
		AddRecord;
	end;

end;

procedure TPhoneBook.MovePrevious;
begin
	edtLastName.SetFocus;
	edtFirstName.SetFocus;
	edtLastName.SetFocus; // Make sure that focus is lost from last edited control.

	if NewRecord then
	begin
		NewRecord := False;
		PhoneBase.Move( 0, VarAsType( PhoneBase.LastModified, varOleStr ) );
	end;

	PhoneBase.MovePrevious;

	if (not VarAsType( PhoneBase.BOF, varBoolean )) then
		GetPhoneInfo
	else
		MoveFirst;

end;

procedure TPhoneBook.MoveNext;
begin
	edtLastName.SetFocus;
	edtFirstName.SetFocus;
	edtLastName.SetFocus; // Make sure that focus is lost from last edited control.

	if NewRecord then
	begin
		NewRecord := False;
		PhoneBase.Move( 0, VarAsType( PhoneBase.LastModified, varOleStr ) );
	end;

	PhoneBase.MoveNext;

	if (not VarAsType( PhoneBase.EOF, varBoolean )) then
		GetPhoneInfo
	else
		MoveLast;

end;

procedure TPhoneBook.MoveLast;
begin
	try
		edtLastName.SetFocus; // Make sure that focus is lost from last edited control.
		edtFirstName.SetFocus;
		edtLastName.SetFocus;
		PhoneBase.MoveLast;
		GetPhoneInfo;
	except
		AddRecord;
	end;
end;

procedure TPhoneBook.FormCreate(Sender: TObject);
begin
	PhoneChanges := TList.Create;
	MarkedRecs := TStringList.Create;
end;

procedure TPhoneBook.edtLastNameChange(Sender: TObject);
begin
	LastNameChanged := True;
end;

procedure TPhoneBook.edtFirstNameChange(Sender: TObject);
begin
	FirstNameChanged := True;
end;

procedure TPhoneBook.edtEMailAddressChange(Sender: TObject);
begin
	EMailAddressChanged := True;
end;

procedure TPhoneBook.edtCompanyChange(Sender: TObject);
begin
	CompanyChanged := True;
end;

procedure TPhoneBook.edtCommentChange(Sender: TObject);
begin
	CommentChanged := True;
end;

procedure TPhoneBook.edtCityChange(Sender: TObject);
begin
	CityChanged := True;
end;

procedure TPhoneBook.edtAddress2Change(Sender: TObject);
begin
	Address2Changed := True;
end;

procedure TPhoneBook.edtAddress1Change(Sender: TObject);
begin
	Address1Changed := True;
end;

procedure TPhoneBook.edtStateChange(Sender: TObject);
begin
	StateChanged := True;
end;

procedure TPhoneBook.edtZipCodeChange(Sender: TObject);
begin
	ZipCodeChanged := True;
end;

procedure TPhoneBook.Tag1Click(Sender: TObject);
begin
	Main.btnChecked.Click;
end;

function TPhoneBook.CopyRecord( DestTableName: String; RecNo: Integer ): Integer;

var
	SrcBaseTable, SrcNumberTable, DestBaseTable, DestNumberTable, SQLQuery: String;

begin
	try
		SrcBaseTable := MainTablePrefix + TableName;
		SrcNumberTable := NumbersTablePrefix + TableName;
		DestBaseTable := MainTablePrefix + DestTableName;
		DestNumberTable := NumbersTablePrefix + DestTableName;
		SQLQuery := 'INSERT INTO ' + DestBaseTable + ' (EntryID, LastName, FirstName, Company, Address1, Address2, ' +
																									'City, State, Zip, EMailAddress, Comment) ' +
								'SELECT (SELECT max(EntryID) + 1 FROM ' + DestBaseTable + ') AS NewEntryID, ' +
													SrcBaseTable + '.LastName, ' + SrcBaseTable + '.FirstName, ' + SrcBaseTable + '.Company, ' +
													SrcBaseTable + '.Address1, ' + SrcBaseTable + '.Address2, ' + SrcBaseTable + '.City, ' +
													SrcBaseTable + '.State, ' +	SrcBaseTable + '.Zip, ' + SrcBaseTable + '.EMailAddress, ' +
													SrcBaseTable + '.Comment ' +
								'FROM ' + SrcBaseTable + ' ' +
								'WHERE EntryID = ' + IntToStr( RecNo ) + ';';
		PhoneBookDB.Execute( SQLQuery, dbFailOnError );
		SQLQuery := 'INSERT INTO ' + DestNumberTable + ' (EntryID, PhoneNumber, PhoneType, Extension, Notes) ' +
								'SELECT (SELECT max(EntryID) FROM ' + DestBaseTable + ') AS NewEntryID, ' +
													SrcNumberTable + '.PhoneNumber, ' + SrcNumberTable + '.PhoneType, ' + SrcNumberTable + '.Extension, ' +
													SrcNumberTable + '.Notes ' +
								'FROM ' + SrcNumberTable + ' ' +
								'WHERE EntryID = ' + IntToStr( RecNo ) + ';';
		PhoneBookDB.Execute( SQLQuery, dbFailonError );
		CopyRecord := 0;
	except
		CopyRecord := -1;
	end;

end;

procedure TPhoneBook.LastNameIndexClick(Sender: TObject);

var
	BookMark: Variant;

begin
	with CurrPhoneBook do
	begin
		LastNameIndex.Checked := True;
		FirstNameIndex.Checked := False;
		CompanyIndex.Checked := False;
		CurrIndex := PhoneBaseLNIndex;
		BookMark := PhoneBase.BookMark;
		PhoneBase.Index :=  CurrIndex;
		PhoneBase.BookMark := VarAsType( BookMark, varOleStr );
	end;
end;

procedure TPhoneBook.FirstNameIndexClick(Sender: TObject);

var
	BookMark: Variant;

begin
	with CurrPhoneBook do
	begin
		FirstNameIndex.Checked := True;
		LastNameIndex.Checked := False;
		CompanyIndex.Checked := False;
		CurrIndex := PhoneBaseFNIndex;
		BookMark := PhoneBase.BookMark;
		PhoneBase.Index :=  CurrIndex;
		PhoneBase.BookMark := VarAsType( BookMark, varOleStr );
	end;
end;

procedure TPhoneBook.CompanyIndexClick(Sender: TObject);

var
	BookMark: Variant;

begin
	with CurrPhoneBook do
	begin
		CompanyIndex.Checked := True;
		LastNameIndex.Checked := False;
		FirstNameIndex.Checked := False;
		CurrIndex := PhoneBaseCOIndex;
		BookMark := PhoneBase.BookMark;
		PhoneBase.Index :=  CurrIndex;
		PhoneBase.BookMark := VarAsType( BookMark, varOleStr );
	end;
end;

procedure TPhoneBook.edtLastNameKeyPress(Sender: TObject; var Key: Char);
begin
	if (Key = #13) then
	begin
		Key := #0;
		Perform( WM_NEXTDLGCTL, 0, 0 );
	end;
end;

end.
