unit PBQRRpt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Quickrep, ExtCtrls;

type
  TQRPhoneReport = class(TForm)
    PBRpt: TQuickReport;
    QRBand1: TQRBand;
    lblTitle: TQRLabel;
    QRBand2: TQRBand;
    lblName: TQRLabel;
    lblAddress: TQRLabel;
    lblCity: TQRLabel;
    lblState: TQRLabel;
    lblZip: TQRLabel;
    lblPhoneType: TQRLabel;
    lblPhoneNumber: TQRLabel;
    lblComment: TQRLabel;
    QRBand3: TQRBand;
    QRLabel2: TQRLabel;
    QRLabel1: TQRLabel;
		QRLabel3: TQRLabel;
		QRLabel4: TQRLabel;
		QRLabel5: TQRLabel;
		QRLabel7: TQRLabel;
		QRLabel8: TQRLabel;
    QRBand4: TQRBand;
    QRShape1: TQRShape;
		procedure PBRptNeedData(var MoreData: Boolean);
		procedure PBRptBeforePrint(var PrintReport: Boolean);
		procedure PBRptAfterPrint(Sender: TObject);
	private
		{ Private declarations }
		ReportPhoneBase, ReportPhoneNumbers: Variant;
		bContinue: Boolean;
	public
		{ Public declarations }
	end;

var
	QRPhoneReport: TQRPhoneReport;

implementation

uses
	PhnMain, GeneralLib;
	
{$R *.DFM}

procedure TQRPhoneReport.PBRptNeedData(var MoreData: Boolean);

var
	PhoneNumber: String[10];
	PhoneNumberFmt: String[14];
	Extension: String[5];
	ExtensionFmt: String[6];
	PhoneType: String[10];
	Notes: String;
	ReportEntryID: Integer;

begin

	if (not ReportPhoneBase.EOF) then
	begin
		if (Trim( ReportPhoneBase.Fields[Field_Company].Value) <> '') then
			lblName.Caption := GetVarString( ReportPhoneBase.Fields[Field_Company].Value )
		else
		begin
			if (Trim( ReportPhoneBase.Fields[Field_LastName].Value) = '') then
				lblName.Caption := GetVarString( ReportPhoneBase.Fields[Field_FirstName].Value )
			else
			begin
				if (Trim( ReportPhoneBase.Fields[Field_FirstName].Value) = '') then
					lblName.Caption := GetVarString( ReportPhoneBase.Fields[Field_LastName].Value )
				else
					lblName.Caption := GetVarString( ReportPhoneBase.Fields[Field_LastName].Value ) + ', ' +
												GetVarString( ReportPhoneBase.Fields[Field_FirstName].Value );
			end;
		end;

		lblAddress.Caption := GetVarString( ReportPhoneBase.Fields[Field_Address1].Value );
		lblCity.Caption := GetVarString( ReportPhoneBase.Fields[Field_City].Value );
		lblState.Caption := GetVarString( ReportPhoneBase.Fields[Field_State].Value );
		lblZip.Caption := GetVarString( ReportPhoneBase.Fields[Field_Zip].Value );
		ReportEntryID := GetVarInteger( ReportPhoneBase.Fields[Field_EntryID].Value );

		if (not bContinue) then // Check to see if we should check for a new "list" of Phone Numbers.
		begin
			ReportPhoneNumbers.Seek( '=', ReportEntryID );
			bContinue := not VarAsType(ReportPhoneNumbers.NoMatch, varBoolean);
		end;

		if bContinue then
		begin
			PhoneNumber := GetVarString( ReportPhoneNumbers.Fields[Field_PhoneNumber].Value );
			PhoneNumberFmt := ExpandPhone( PhoneNumber );
			Extension := GetVarString( ReportPhoneNumbers.Fields[Field_Extension].Value );
			ExtensionFmt := iif( Trim( Extension ) <> '', 'x' + Extension, '' );
			Notes := GetVarString( ReportPhoneNumbers.Fields[Field_Notes].Value );
			PhoneType := TPhoneTypeInfo(PhoneTypeCodes.Objects[PhoneTypeCodes.IndexOf(
										GetVarString( ReportPhoneNumbers.Fields[Field_PhoneType].Value ) )]).Description;
			ReportPhoneNumbers.MoveNext;

			bContinue := False;
			if (not VarAsType(ReportPhoneNumbers.EOF, varBoolean)) then
			begin
				if (VarAsType(ReportPhoneNumbers.Fields[Field_EntryID].Value, varInteger)= ReportEntryID) then
					bContinue := True;
			end;
		end
		else
		begin
			PhoneType := '';
			PhoneNumberFmt := '';
			ExtensionFmt := '';
			Notes := '';
		end;

		lblPhoneType.Caption := PhoneType[1] + ':';
		lblPhoneNumber.Caption := PhoneNumberFmt;
		lblComment.Caption := iif( Trim( Notes ) ='', GetVarString( ReportPhoneBase.Fields[Field_Comment].Value ), Notes );

		if (not bContinue) then // Otherwise we're just going to keep enumerating through the phone numbers.
			ReportPhoneBase.MoveNext;

		MoreData := True;
	end
	else
		MoreData := False;

end;

procedure TQRPhoneReport.PBRptBeforePrint(var PrintReport: Boolean);
begin
	ReportPhoneBase := PhoneBookDB.OpenRecordset( 'ReportBase' );
	ReportPhoneNumbers := PhoneBookDB.OpenRecordset( 'ReportNumbers' );
	ReportPhoneNumbers.Index := 'EntryID';
	ReportPhoneBase.MoveFirst;
	lblTitle.Caption := CurrPhoneBook.TableName + '''s Phone Book';
	bContinue := False;
end;

procedure TQRPhoneReport.PBRptAfterPrint(Sender: TObject);
begin
	ReportPhoneBase.Close;
	ReportPhoneNumbers.Close;
end;

end.
