unit Opentbl;

interface

uses
  PhnBook, DB, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons;

type
  TOpenTable = class(TForm)
    lbTables: TListBox;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
		procedure btnOKClick(Sender: TObject);
		procedure FormActivate(Sender: TObject);
    //procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
	OpenTable: TOpenTable;

implementation

uses
	Phnmain;

{$R *.DFM}

procedure TOpenTable.btnOKClick(Sender: TObject);
var
	NewPhoneBook: TPhoneBook;
	sTableChoice: String[32];

begin
	{Create new Phone Book form for chosen table}
	self.Hide;

	if (lbTables.ItemIndex >= 0) then
		begin
			sTableChoice := lbTables.Items[lbTables.ItemIndex];
			NewPhoneBook := TPhoneBook.Create( owner );
			with NewPhoneBook do
			begin
				Caption := sTableChoice + '''s Phonebook';
				TableName := sTableChoice;
				TablesInUse.Add( sTableChoice );
				{Remove table name as an option from which to choose.}
				TableNameList.Delete( TableNameList.IndexOf( sTableChoice ) );
				Main.ChangeButtonStatus( True );
				//PhoneChildren.Add( sTableChoice );
				CurrIndex := PhoneBaseLNIndex;
				try
					PhoneBase := PhoneBookDB.OpenRecordset( MainTablePrefix + sTableChoice );
					PhoneBase.Index := PhoneBaseLNIndex;
					PhoneNumbers := PhoneBookDB.OpenRecordset( NumbersTablePrefix + sTableChoice );
					PhoneNumbers.Index := PhoneNumberIDIndex;

					//if (PhoneBase.RecordCount > 0) then
						//begin
							//PhoneBase.MoveFirst;
							NewPhoneBook.MoveFirst;
							GetBaseData;
							GetPhoneNumberList;
						//end;

					NewPhoneBook.SetFocus;
				except
					ShowMessage( 'Error while trying to opening Phonebook tables.' );
					NewPhoneBook.Release;
				end;
			end;
		end;

		Close;
end;

procedure TOpenTable.FormActivate(Sender: TObject);

begin
	lbTables.Items := TableNameList;

	if (lbTables.Items.Count > 0) then
		lbTables.ItemIndex := 0;

end;

end.
