unit NewPBDlg;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, Buttons, PhnMain;

type
	TNewPhoneBookDlg = class(TForm)
		edtPBName: TEdit;
		Label1: TLabel;
		btnOK: TBitBtn;
		btnCancel: TBitBtn;
		procedure btnOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	NewPhoneBookDlg: TNewPhoneBookDlg;


const
	// DAO constants;
	dbDate				=  8; // Date/Time
	dbText				= 10; // Text
	dbMemo				= 12; // Memo
	dbBoolean			=  1; // Yes/No
	dbInteger			=  3; // Integer
	dbLong				=  4; // Long
	dbCurrency		=  5; // Currency
	dbSingle			=  6; // Single
	dbDouble			=  7; // Double
	dbByte				=  2; // Byte
	dbLongBinary	= 11; // Long Binary (OLE Object)

implementation

{$R *.DFM}

procedure TNewPhoneBookDlg.btnOKClick(Sender: TObject);

var
	PhoneBookDef, PhoneNumbersDef, FieldDef, IndexDef: Variant;

begin

	if Trim( edtPBName.Text ) <> '' then
	begin
		PhoneBookDef := PhoneBookDB.CreateTableDef( 'PhoneBook_' + edtPBName.Text );
		FieldDef := PhoneBookDef.CreateField( 'EntryID', dbInteger );
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'LastName',			dbText, 20 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'FirstName',		dbText, 15 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'Company',			dbText, 30 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'Address1',			dbText, 30 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'Address2',			dbText, 30 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'City',					dbText, 30 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'State',				dbText, 2 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'Zip',					dbText, 10 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'EMailAddress', dbText, 30 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'Comment',			dbText, 60 );
		FieldDef.AllowZeroLength := True;
		PhoneBookDef.Fields.Append( FieldDef );
		PhoneBookDB.TableDefs.Append( PhoneBookDef );

		IndexDef := PhoneBookDef.CreateIndex( 'PrimaryKey' );
		IndexDef.Primary := True;
		IndexDef.Unique := True;
		FieldDef := PhoneBookDef.CreateField( 'EntryID', 			dbInteger );
		IndexDef.Fields.Append( FieldDef );
		PhoneBookDef.Indexes.Append( IndexDef );

		IndexDef := PhoneBookDef.CreateIndex( 'Company' );
		FieldDef := PhoneBookDef.CreateField( 'Company', 			dbText, 30 );
		IndexDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'LastName', 		dbText, 20 );
		IndexDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'FirstName',		dbText, 15 );
		IndexDef.Fields.Append( FieldDef );
		PhoneBookDef.Indexes.Append( IndexDef );

		IndexDef := PhoneBookDef.CreateIndex( 'LastName' );
		FieldDef := PhoneBookDef.CreateField( 'LastName', 		dbText, 20 );
		IndexDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'FirstName',		dbText, 15 );
		IndexDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'Company', 			dbText, 30 );
		IndexDef.Fields.Append( FieldDef );
		PhoneBookDef.Indexes.Append( IndexDef );

		IndexDef := PhoneBookDef.CreateIndex( 'FirstName' );
		FieldDef := PhoneBookDef.CreateField( 'FirstName',		dbText, 15 );
		IndexDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'LastName', 		dbText, 20 );
		IndexDef.Fields.Append( FieldDef );
		FieldDef := PhoneBookDef.CreateField( 'Company', 			dbText, 30 );
		IndexDef.Fields.Append( FieldDef );
		PhoneBookDef.Indexes.Append( IndexDef );

		PhoneNumbersDef := PhoneBookDB.CreateTableDef( 'PhoneNumbers_' + edtPBName.Text );
		FieldDef := PhoneNumbersDef.CreateField( 'EntryID', dbInteger );
		PhoneNumbersDef.Fields.Append( FieldDef );
		FieldDef := PhoneNumbersDef.CreateField( 'PhoneNumber',	dbText, 14 );
		PhoneNumbersDef.Fields.Append( FieldDef );
		FieldDef := PhoneNumbersDef.CreateField( 'Extension',	dbText, 5 );
		FieldDef.AllowZeroLength := True;
		PhoneNumbersDef.Fields.Append( FieldDef );
		FieldDef := PhoneNumbersDef.CreateField( 'PhoneType',	dbByte );
		PhoneNumbersDef.Fields.Append( FieldDef );
		FieldDef := PhoneNumbersDef.CreateField( 'Notes',	dbText, 50 );
		FieldDef.AllowZeroLength := True;
		PhoneNumbersDef.Fields.Append( FieldDef );
		PhoneBookDB.TableDefs.Append( PhoneNumbersDef );

		IndexDef := PhoneNumbersDef.CreateIndex( 'PrimaryKey' );
		IndexDef.Primary := True;
		IndexDef.Unique := True;
		FieldDef := PhoneNumbersDef.CreateField( 'EntryID',		dbInteger );
		IndexDef.Fields.Append( FieldDef );
		FieldDef := PhoneNumbersDef.CreateField( 'PhoneNumber',	dbText, 14 );
		IndexDef.Fields.Append( FieldDef );
		FieldDef := PhoneNumbersDef.CreateField( 'Extension',	dbText, 5 );
		IndexDef.Fields.Append( FieldDef );
		PhoneNumbersDef.Indexes.Append( IndexDef );

		IndexDef := PhoneNumbersDef.CreateIndex( 'EntryID' );
		FieldDef := PhoneNumbersDef.CreateField( 'EntryID',		dbInteger );
		IndexDef.Fields.Append( FieldDef );
		PhoneNumbersDef.Indexes.Append( IndexDef );

		TableNameList.Add( edtPBName.Text );
		TableNameListStatic.Add( edtPBName.Text );
		ShowMessage( 'A new Phone Book (' + edtPBName.Text + ') has been added.' );
		Main.btnOpenBook.Enabled := True;
	end
	else
	begin
		ModalResult := mrNone;
		ShowMessage( 'You did not enter a name for the Phone Book.' );
		edtPBName.SetFocus;
	end;

end;

procedure TNewPhoneBookDlg.FormShow(Sender: TObject);
begin
	edtPBName.SetFocus;
end;

procedure TNewPhoneBookDlg.FormActivate(Sender: TObject);
begin
	edtPBName.Text := '';
end;

end.
