unit GeneralLib;

interface

uses
	Forms, Classes;

function ProperCase( OldString: String ): String;
function InStr( Search: ANSIString; Target: ANSIString; StartPos: Integer ): Integer;
function Protect( Value: String; EncryptValue: Boolean; Key: String ): String;
function iif( ValueTest: Boolean; TrueValue, FalseValue: Variant ): Variant;
procedure TabToNextCtrl( CurForm: TForm; var Key: Char );
function GetVarString( vString: Variant ): String;
function GetVarInteger( vInteger: Variant ): Integer;
function ExpandPhone( PhoneNumber: String ): String;
function GetPathFile( PathFile: String; GetPath: Boolean): String;
function URLParser( QueryString: ANSIString; var QueryVars: TStringList ): Integer;
function SafeCovert( PValue: PChar; EncryptValue: Integer; PKey: PChar;
											Buffer: PChar; BufferLen: Integer ): Integer;
function Covert( PValue: PChar; EncryptValue: Integer; PKey: PChar;
									Buffer: PChar; BufferLen: Integer ): Integer;

type
	QueryVariables = class( TObject )
		VarName: ANSIString;
		VarValue: ANSIString;
	end;

implementation

uses
	SysUtils, Messages;

function ProperCase( OldString: String ): String;

var
	StringLength, i: Byte;
	NewString: String;
	CurrChar: String[1];
	LastChar: String[1];
	NewChar: String[1];

begin
		StringLength := Length( OldString );
		NewString := '';
		LastChar := ' ';

		For i := 1 To StringLength do
		begin
			CurrChar := Copy( OldString, i, 1 );
			NewChar := iif( LastChar = chr(32), UpperCase( CurrChar ), LowerCase( CurrChar ) );
			NewString := NewString + NewChar;
			LastChar := CurrChar;
		end;

		ProperCase := NewString;
end;


function InStr( Search: ANSIString; Target: ANSIString; StartPos: Integer ): Integer;

var
	bNotFound: Boolean;
	CurPos: Integer;
	TargetLen: Integer;

begin
	bNotFound := true;
	CurPos := StartPos;
	TargetLen := Length( Target );

	while (bNotFound) and (CurPos <= TargetLen) do
		begin

			if (Target[CurPos] = Search) then
				bNotFound := false
			else
				Inc( CurPos );

		end;

	Instr := iif( CurPos > TargetLen, -1, CurPos );
end;

function Protect( Value: String; EncryptValue: Boolean; Key: String ): String;

var
	StrResult: String;
	Counter: Byte;
	PrevChar: Byte;
	CurrChar: Byte;
	KeyIndex: Byte;
	KeyLen: Byte;
	ValueLen: Byte;
	NewChar: Byte;
	KeyChar: array[0..254] of Byte;

const
	MAGIC1 = 53;
	MAGIC2 = 7;

begin
	PrevChar := MAGIC1;
	KeyIndex := 0;
	KeyLen := Length( Key );
	ValueLen := Length( Value );

	for Counter := 1 to KeyLen do
		KeyChar[Counter] := Byte(Ord( Key[Counter] ));

	for Counter := 1 To ValueLen do
	begin
		CurrChar := byte(Ord( Value[Counter] ));
		NewChar := CurrChar xor KeyChar[KeyIndex] xor PrevChar xor ((Counter div MAGIC2) mod 255);
		StrResult := StrResult + Chr( NewChar );
		PrevChar := iif( EncryptValue, CurrChar, NewChar );
		KeyIndex := KeyIndex + 1;

		if ((KeyIndex + 1) > KeyLen) then
			KeyIndex := 1;

	end;

	Protect := StrResult;
end;

function iif( ValueTest: boolean; TrueValue, FalseValue: variant ): variant;
begin
	if ValueTest then	iif := TrueValue	else iif := FalseValue;
end;

procedure TabToNextCtrl( CurForm: TForm; var Key: Char );
begin

	if (Key = #13) then
	begin
		Key := #0;
		CurForm.Perform( WM_NEXTDLGCTL, 0, 0 );
	end;

end;

function GetVarString( vString: Variant ): String;
begin

	if VarIsNull( vString ) then
  	GetVarString := ''
  else
		GetVarString := VarAsType( vString, varString );

end;

function GetVarInteger( vInteger: Variant ): Integer;
begin

	if VarIsNull( vInteger ) then
		GetVarInteger := 0
	else
		GetVarInteger := VarAsType( vInteger, varInteger );

end;

function ExpandPhone( PhoneNumber: String ): String;
begin
	ExpandPhone := '(' +	Copy( PhoneNumber, 1, 3 ) + ') ' +
												Copy( PhoneNumber, 4, 3 ) + '-' +
												Copy( PhoneNumber, 7, 4 );
end;

function GetPathFile( PathFile: String; GetPath: Boolean): String;

var
	PathFileLength: Byte;
	x: Integer;

begin
	PathFileLength := Length( PathFile );

	for x := PathFileLength downto 0 do

		if ((x = 0) or (Copy( PathFile, x, 1 ) = '\')) then
			break;

	if GetPath Then
		GetPathFile := iif( x <> 0, Copy( PathFile, 1, x ), '' )
	else
		GetPathFile := iif( x <> 0, Copy( PathFile, x + 1, PathFileLength - x ), PathFile );

end;

function URLParser( QueryString: ANSIString; var QueryVars: TStringList ): Integer;

var
	Continue: Boolean;
	EqualPos, VarStartingPos, QueryStringLen, EndOfValPos: Integer;
	VarName: ANSIString;
	VarValue: ANSIString;
	NewVar: QueryVariables;

begin
// '&' separates variables from other variables
// '=' separates values from their variables
// e.g. QryValue1=100&QryValue2=200
	EqualPos := Pos( '=', QueryString );

	if EqualPos = 0 then
	begin
		Continue := false;
		URLParser := -1; //No values found.
	end
	else
	begin
		URLParser := 0;
		Continue := true;
		VarStartingPos := 1;
		QueryStringLen := Length( QueryString );
	end;

	while Continue do
	begin
		EqualPos := Instr( '=', QueryString, VarStartingPos );
		VarName := Copy( QueryString, VarStartingPos, EqualPos - VarStartingPos );
		VarStartingPos := Instr( '&', QueryString, EqualPos + 1 ) + 1; //Start looking for next '&' after the Equal sign.

		if (VarStartingPos = 1) then
		begin
			EndOfValPos := QueryStringLen;
			Continue := false;
		end
		else
			EndOfValPos := VarStartingPos - 2;

		VarValue := Copy( QueryString, EqualPos + 1, EndOfValPos - EqualPos );

		if (QueryVars.IndexOf( VarName ) > -1) then
		begin
			Continue := false;
			URLParser := -2; //Duplicate variable names.
		end
		else
		begin
			NewVar := QueryVariables.Create;
			NewVar.VarName := VarName;
			NewVar.VarValue := VarValue;
			QueryVars.AddObject( VarName, NewVar );
		end;

	end;

end;

function SafeCovert( PValue: PChar; EncryptValue: Integer; PKey: PChar;
											Buffer: PChar; BufferLen: Integer ): Integer;

var
	PNewValue, PassedResult: PChar;
	OrigResult, NewValue, NewResult: String;
	i, ValueLen, ResultLen, ErrCode: Byte;
	Value, Key: String;


begin
	Value := String(PValue);

	if (EncryptValue <> 1) then
	begin
		NewValue := '';
		ValueLen := Length( Value );

		try
			for i := 1 to ValueLen div 2 do
			begin
				NewValue := NewValue + Char( StrToInt( '$' + Copy( Value, 1 + (2 * (i - 1)), 2 ) ) );
			end;
		except
			SafeCovert := -1;
		end;

	end
	else
		NewValue := Value;

	PassedResult := StrAlloc( Length( NewValue ) + 1 );
	PNewValue := PChar(NewValue);
	ErrCode := Covert( PNewValue, EncryptValue, PKey, PassedResult, Length( NewValue ) );
	OrigResult := String(PassedResult);
	StrDispose( PassedResult );

	if (EncryptValue = 1) then
	begin
		NewResult := '';
		ResultLen := Length( OrigResult );

		for i := 1 to ResultLen do
		begin
			NewResult := NewResult + IntToHex( Ord( OrigResult[i] ), 2 );
		end

	end
	else
		NewResult := OrigResult;

	StrLCopy( Buffer, PChar(NewResult), Length( NewResult ) );
	SafeCovert := 0;
end;

function Covert( PValue: PChar; EncryptValue: Integer; PKey: PChar;
									Buffer: PChar; BufferLen: Integer ): Integer;

var
	StrResult: String;
	Counter, PrevChar, CurrChar, KeyIndex, KeyLen, ValueLen, NewChar: Byte;
	KeyChar: array[0..254] of Byte;
	Value, Key: String;

const
	MAGIC1 = 53;
	MAGIC2 = 7;

begin
	Value := String(PValue);
	Key := String(PKey);
	PrevChar := MAGIC1;
	KeyIndex := 1;
	KeyLen := Length( Key );
	ValueLen := Length( Value );

	for Counter := 1 to KeyLen do
		KeyChar[Counter] := Byte(Ord( Key[Counter] ));

	for Counter := 1 To ValueLen do
	begin
		CurrChar := Byte(Ord( Value[Counter] ));
		NewChar := CurrChar xor KeyChar[KeyIndex] xor PrevChar xor ((Counter div MAGIC2) mod 255);
		StrResult := StrResult + Chr( NewChar );
		PrevChar := iif( EncryptValue = 1, CurrChar, NewChar );
		KeyIndex := KeyIndex + 1;

		if ((KeyIndex + 1) > KeyLen) then
			KeyIndex := 1;

	end;

	StrLCopy( Buffer, PChar(StrResult), Length( StrResult ) );
	Covert := 0;
end;

end.

