unit DestTbls;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TDestTable = class(TForm)
    lbTables: TListBox;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
	private
		{ Private declarations }
		FDestTable: String;
	public
		{ Public declarations }
		property TableName: String read FDestTable write FDestTable;
  end;

var
  DestTable: TDestTable;

implementation

{$R *.DFM}

uses
	PhnMain;

procedure TDestTable.FormActivate(Sender: TObject);

var
	x: Byte;

begin
	lbTables.Items.Clear;
	
	for x := 0 to TableNameListStatic.Count - 1 do
	begin
		if (TableNameListStatic[x] <> CurrPhoneBook.TableName) then
			lbTables.Items.Add( TableNameListStatic[x] );
	end;

	if (lbTables.Items.Count > 0) then //This has to be greater than 0, otherwise this dialog box should not have gotten called.
		lbTables.ItemIndex := 0;

end;

procedure TDestTable.btnOKClick(Sender: TObject);
begin
	FDestTable := lbTables.Items[lbTables.ItemIndex];
end;

end.
