unit DeleteTbl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OPENTBL, StdCtrls, Buttons;

type
  TDeleteTable = class(TOpenTable)
    procedure btnOKClick(Sender: TObject);
	private
    { Private declarations }
  public
    { Public declarations }
  end;

var
	DeleteTable: TDeleteTable;

implementation

uses
	PhnMain;
	
{$R *.DFM}

procedure TDeleteTable.btnOKClick(Sender: TObject);

var
	sTableChoice: String[32];
	//TableDef: Variant;

begin
	if (lbTables.ItemIndex >= 0) then
	begin
		self.Hide;
		sTableChoice := lbTables.Items[lbTables.ItemIndex];

		if MessageDlg( 'You are about to DELETE the ' + sTableChoice + ' Phone Book.  Press OK if you are certain you wish to do this.',
									mtWarning, mbOKCancel, 0 ) = mrOK then
		begin
			TableNameList.Delete( TableNameList.IndexOf( sTableChoice ) );
			TableNameListStatic.Delete( TableNameListStatic.IndexOf( sTableChoice ) );
			//TableDef := PhoneBookDB.OpenTable( NumbersTablePrefix + sTableChoice );
			PhoneBookDB.TableDefs.Delete( NumbersTablePrefix + sTableChoice );
			//TableDef := PhoneBookDB.OpenTable( MainTablePrefix + sTableChoice );
			PhoneBookDB.TableDefs.Delete( MainTablePrefix + sTableChoice );
			ShowMessage( sTableChoice + 'Phone Book has been deleted.' );
			ModalResult := mrOK;
		end;

	end;

end;


end.
