unit Addnmbr;

interface

uses
	PhnBook, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, StdCtrls, DBCtrls, DB, DBTables, Buttons, DBLookup, Mask;

type
	TAddPhoneDlg = class(TForm)
		Label1: TLabel;
		Label2: TLabel;
		btnOK: TBitBtn;
		btnCancel: TBitBtn;
		Label3: TLabel;
		cboPhoneTypes: TComboBox;
		edtPhoneNumber: TMaskEdit;
		edtExtension: TEdit;
    Label4: TLabel;
    edtNotes: TEdit;
		procedure btnOKClick(Sender: TObject);
		procedure FormActivate(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
	private
		{ Private declarations }
		FNewRecord: Boolean;
	public
		{ Public declarations }
		property NewRecord: Boolean read FNewRecord write FNewRecord;
	end;

var
	AddPhoneDlg: TAddPhoneDlg;
	//OldPhoneNumber: String[10];
	//OldExtension: String[5];
	OldPhoneInfo: TPhoneInfo;

implementation

uses
	PhnMain, GeneralLib;

{$R *.DFM}

procedure TAddPhoneDlg.FormActivate(Sender: TObject);

{var
	NotFound: Boolean;}

begin
	cboPhoneTypes.Items := PhoneTypeDesc;
	cboPhoneTypes.SetFocus;
	with CurrPhoneBook do
	begin

		if NewRecord then
		begin
			cboPhoneTypes.ItemIndex := 0;
			edtPhoneNumber.Text := '';
			edtExtension.Text := '';
			edtNotes.Text := '';
			OldPhoneInfo.PhoneType		:= 0;
			OldPhoneInfo.PhoneNumber	:= '';
			OldPhoneInfo.Extension		:= '';
			OldPhoneInfo.Notes				:= '';
		end
		else
		begin
			OldPhoneInfo.PhoneType := TPhoneInfo(lbPhoneNumbers.Items.Objects[lbPhoneNumbers.ItemIndex]).PhoneType;
			OldPhoneInfo.PhoneNumber := TPhoneInfo(lbPhoneNumbers.Items.Objects[lbPhoneNumbers.ItemIndex]).PhoneNumber;
			OldPhoneInfo.Extension := TPhoneInfo(lbPhoneNumbers.Items.Objects[lbPhoneNumbers.ItemIndex]).Extension;
			OldPhoneInfo.Notes := TPhoneInfo(lbPhoneNumbers.Items.Objects[lbPhoneNumbers.ItemIndex]).Notes;
			cboPhoneTypes.ItemIndex := PhoneTypeCodes.IndexOf( IntToStr( OldPhoneInfo.PhoneType ) );
			edtPhoneNumber.Text := OldPhoneInfo.PhoneNumber;
			edtExtension.Text := OldPhoneInfo.Extension;
			edtNotes.Text := OldPhoneInfo.Notes;
		end;
		
	end; //With

end;

procedure TAddPhoneDlg.btnOKClick(Sender: TObject);

var
	PhoneNumber: String[10];
	Extension: String[5];
	ExtensionFmt: String[6];
	PhoneNumberFmt: String[14];
	PhoneType: Byte;
	PhoneInfo: TPhoneInfo;
	RecChanged, bContinue: Boolean;
	ErrMsg: ANSIString;
	PhoneChange: TPhoneChange;

begin

	if (Trim( edtPhoneNumber.Text ) <> '') then
	begin
		PhoneType := TPhoneTypeInfo(PhoneTypeDesc.Objects[PhoneTypeDesc.IndexOf( cboPhoneTypes.Text )]).Code;
		PhoneNumber := edtPhoneNumber.Text;
		Extension := Format( '%5s', [edtExtension.Text] );
		ExtensionFmt := iif( Trim( Extension ) <> '', 'x' + Extension, '' );

		with CurrPhoneBook do
		begin

			//Make sure the record is unique and has changed.
			if ( (OldPhoneInfo.PhoneType <> PhoneType) or (OldPhoneInfo.PhoneNumber <> PhoneNumber) or
						(OldPhoneInfo.Extension <> edtExtension.Text)	or (OldPhoneInfo.Notes <> edtNotes.Text) ) then
			begin
				RecChanged := True;
				PhoneInfo := TPhoneInfo.Create;
				PhoneInfo.EntryID			:= EntryID;
				PhoneInfo.PhoneType		:= PhoneType;
				PhoneInfo.PhoneNumber := PhoneNumber;
				PhoneInfo.Extension		:= edtExtension.Text;
				PhoneInfo.Notes				:= edtNotes.Text;

				if NewRecord then
					bContinue := AddPhoneNumber( PhoneInfo )
				else
					bContinue := ModifyPhoneNumber( PhoneInfo, OldPhoneInfo );

			end
			else
			begin
				bContinue := False;
				RecChanged := False;
			end;

			if bContinue then
			begin
				PhoneChange := TPhoneChange.Create;
				PhoneNumberFmt := ExpandPhone( PhoneNumber );
				PhoneChange.PhoneInfo := TPhoneInfo.Create;
				PhoneChange.ChangeType := iif( NewRecord, AddRec, ModifyRec );
				PhoneChange.PhoneInfo.EntryID			:= PhoneInfo.EntryID;
				PhoneChange.PhoneInfo.PhoneType		:= PhoneInfo.PhoneType;
				PhoneChange.PhoneInfo.PhoneNumber := PhoneInfo.PhoneNumber;
				PhoneChange.PhoneInfo.Extension		:= PhoneInfo.Extension;
				PhoneChange.PhoneInfo.Notes				:= PhoneInfo.Notes;

				if (not NewRecord) then //For Updates only.
				begin
					//PhoneChange.PhoneInfo := PhoneInfo;
					//PhoneChange.OldPhoneInfo := TPhoneInfo(lbPhoneNumbers.Items.Objects[lbPhoneNumbers.ItemIndex]);
					PhoneChange.OldPhoneInfo := TPhoneInfo.Create;
					PhoneChange.OldPhoneInfo.EntryID			:= OldPhoneInfo.EntryID;
					PhoneChange.OldPhoneInfo.PhoneType		:= OldPhoneInfo.PhoneType;
					PhoneChange.OldPhoneInfo.PhoneNumber	:= OldPhoneInfo.PhoneNumber;
					PhoneChange.OldPhoneInfo.Extension		:= OldPhoneInfo.Extension;
					PhoneChange.OldPhoneInfo.Notes				:= OldPhoneInfo.Notes;
					TPhoneInfo(lbPhoneNumbers.Items.Objects[lbPhoneNumbers.ItemIndex]).Free;
					lbPhoneNumbers.Items.Delete( lbPhoneNumbers.ItemIndex );
				end;

				PhoneChanges.Add( PhoneChange );
				//PhoneChange.Free;
				lbPhoneNumbers.Items.AddObject( Format( '%-8.8s: %-14.14s %-6.6s %s',
										[cboPhoneTypes.Text, PhoneNumberFmt, ExtensionFmt, edtNotes.Text] ),	PhoneInfo);
				//PhoneInfo.Free;
			end
			else
			begin

				if RecChanged then // Only a problem if the info changed.
				begin

					if NewRecord then
						ErrMsg := 'This Phone Number already exists for this record.'
					else
						ErrMsg := 'Error - Cannot find old Phone Number record to Modify.';

					ShowMessage( ErrMsg );
					self.ModalResult := mrNone;
					edtPhoneNumber.SetFocus;
				end;

			end;

		end; //With

	end
	else
	begin
		MessageDlg( 'Cannot leave Phone Number blank.', mtError, [mbOK], 0 );
		self.edtPhoneNumber.SetFocus;
	end;

end;

procedure TAddPhoneDlg.FormCreate(Sender: TObject);
begin
	OldPhoneInfo := TPhoneInfo.Create;
end;

procedure TAddPhoneDlg.FormDestroy(Sender: TObject);
begin
	OldPhoneInfo.Free;
end;

end.
