unit Addemail;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Mask, DBCtrls, DB;

type
  TAddEMailAddress = class(TForm)
    Label1: TLabel;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    edtEMailAddress: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
	  NewRecord: Boolean;
	end;

var
	AddEMailAddress: TAddEMailAddress;

implementation

uses
	PhnMain;

var
	OldEMailAddress: String[30];

{$R *.DFM}

procedure TAddEMailAddress.FormActivate(Sender: TObject);

var
	NotFound: Boolean;

begin

	with CurrPhoneBook do
  begin
		if NewRecord then
		begin
			edtEMailAddress.Text := '';
		end
		else
		begin
			OldEMailAddress := lbEMailAddresses.Items[lbEMailAddresses.ItemIndex];
			EMailAddresses.Index := 'PrimaryKey';
      EMailAddresses.Seek( '=', CurrPhoneBook.EntryID, OldEMailAddress );
      EMailAddresses.Index := 'EntryID';
      NotFound := VarAsType( EMailAddresses.NoMatch, varBoolean );

      if NotFound then
      begin
        ShowMessage( 'Error - Unable to find old record; Update not performed.' );
        self.Hide;
      end
      else
	      edtEMailAddress.Text := OldEMailAddress;

    end;
  end;

	self.edtEMailAddress.SetFocus;
end;

procedure TAddEMailAddress.btnOKClick(Sender: TObject);

var
  NotFound: Boolean;

begin

  if (edtEMailAddress.Text <> '') then
	begin
		with CurrPhoneBook do
		begin
			EMailAddressesChanged := True;
			NotFound := True;

			//Make sure the record is unique.
    	if OldEMailAddress <> edtEMailAddress.Text then
      begin
        EMailAddresses.Index := 'PrimaryKey';
				EMailAddresses.Seek( '=', CurrPhoneBook.EntryID, edtEMailAddress.Text );
				EMailAddresses.Index := 'EntryID';
        NotFound := VarAsType( EMailAddresses.NoMatch, varBoolean );

        if (not NotFound) then
        begin
        	ShowMessage( 'This E-Mail Address already exists for this record.' );
          self.ModalResult := mrNone;
          edtEMailAddress.SetFocus;
        end;

      end;

			if NotFound then
      begin
        if NewRecord then
      	begin
          EMailAddresses.AddNew;
          EMailAddresses.Fields['EntryID'].Value := EntryID;
        end
        else
          EMailAddresses.Edit;

        EMailAddresses.Fields['EMailAddress'].Value := edtEMailAddress.Text;

        if (not NewRecord) then
	        lbEMailAddresses.Items.Delete( lbEMailAddresses.ItemIndex );
          
        lbEMailAddresses.Items.Add( edtEMailAddress.Text );
        EMailAddresses.Update;
      end;

    end;
  end
  else
  begin
    MessageDlg( 'Cannot leave EMail Address blank.', mtError, [mbOK], 0 );
    self.edtEMailAddress.SetFocus;
  end;

end;

procedure TAddEMailAddress.btnCancelClick(Sender: TObject);
begin
	//if NewRecord then CurrPhoneBook.EMailAddresses.Delete; //Remove newly added record if user is aborting operation.
  self.Hide;
end;

end.
