unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ShellApi, FileCtrl, Buttons, PathCombo,
  FileList;

type
  TForm1 = class(TForm)
    sbNewFolder: TSpeedButton;
    sbUpLevel: TSpeedButton;
    FileList1: TFileList;
    sbListView: TSpeedButton;
    sbReportView: TSpeedButton;
    bClose: TButton;
    PathComboBox1: TPathComboBox;
    procedure sbUpLevelClick(Sender: TObject);
    procedure FileList1DblClick(Sender: TObject);
    procedure PathComboBox1Change(Sender: TObject);
    procedure bCloseClick(Sender: TObject);
    procedure FileList1KeyPress(Sender: TObject; var Key: Char);
    procedure sbReportViewClick(Sender: TObject);
    procedure sbListViewClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  //Defaults to current directory, otherwise ...
  //PathComboBox1.path := 'c:\Program Files';

  // Hide File attributes in report view
  // but still needed to test if a directory has been Dblclicked.
  FileList1.SetColWidth(fiAttributes,0);
end;

procedure TForm1.FileList1DblClick(Sender: TObject);
begin
  // if a directory is clicked in FileList then change to that directory
  // ie: change PathComboBox1.path which sends a Change messagge back
  if (FileList1.selected <> nil) and
        (pos('D',FileList1.selected.subitems[3])<>0) then
  PathComboBox1.path := PathComboBox1.path+FileList1.selected.caption+'\';
end;

procedure TForm1.FileList1KeyPress(Sender: TObject; var Key: Char);
begin
  // if a directory is clicked in FileList then change to that directory
  // ie: change PathComboBox1.path which sends a Change messagge back
  if (Key = #13) and(FileList1.selected <> nil) and
        (pos('D',FileList1.selected.subitems[3])<>0) then
  PathComboBox1.path := PathComboBox1.path+FileList1.selected.caption+'\';
end;

procedure TForm1.PathComboBox1Change(Sender: TObject);
begin
  // Just in case the virtual "Drives" folder is selected!
  if PathComboBox1.path = '' then FileList1.items.clear
  else begin
    // if PathComboBox1.path changes then change FileList as well!
    // Not too hard eh?
    if FileList1.directory <> PathComboBox1.path then
      FileList1.directory := PathComboBox1.path;
  end;
end;

procedure TForm1.sbUpLevelClick(Sender: TObject);
begin
  // if not a root directory then change up one level
  with PathComboBox1 do begin
     if (itemindex > 1) and (length(items[itemindex]) > 3) then
        // itemindex := itemindex-1 {DOES NOT WORK !?}
        Path := items[itemindex-1]
     else messagebeep(0);
  end;
end;

procedure TForm1.sbReportViewClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsReport;
end;

procedure TForm1.sbListViewClick(Sender: TObject);
begin
  FileList1.ViewStyle := vsList;
end;

procedure TForm1.bCloseClick(Sender: TObject);
begin
  close;
end;

end.
