{--------------------------------------------------------------------}
{ TmwFastTime V 1.0                                                     }
{ Written by Martin Waldenburg 1996.                                 }
{ Copyright by Martin Waldenburg 1996. All rights reserved.          }
{ This is FreeWare.                                                  }
{ It's provided as is, without a warranty of any kind.               }
{ You use it at your own risc.                                       }
{ You may use and distribute it freely.                              }
{ But You may not say it's your work                                 }
{ If you distribute it you must provide all Files.                   }
{--------------------------------------------------------------------}
{ It queries a High Resolution Counter with a precision of about     }
{ 0,00083 ms. For extremely short times the result may be false      }
{--------------------------------------------------------------------}
unit mwFastTime;

interface

uses
 Windows, SysUtils, Classes;
 
type
  TmwFastTime = class(TComponent)
  private
    c, n1, n2: TLargeInteger;
    FElapsedTime : ShortString;
  protected
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
    Property ElapsedTime : ShortString read FElapsedTime;
    Procedure Start;
    Procedure Stop;
  published
    Property Name;
    Property Tag;
end;

procedure Register;


implementation

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

procedure Register;
begin
  RegisterComponents('mw',[TmwFastTime]);
end;
 
 
{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

constructor TmwFastTime.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);
     FElapsedTime := '';
end;
 
 
{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

destructor TmwFastTime.Destroy;
begin
  inherited Destroy;
end;
 
 
{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

Procedure TmwFastTime.Start;
begin
  QueryPerformanceFrequency(c);
  QueryPerformanceCounter(n1);
end;


{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

Procedure TmwFastTime.Stop;
begin
  QueryPerformanceCounter(n2);
  FElapsedTime:= format('Seconds: %g', [(n2.QuadPart - n1.QuadPart)/ c.QuadPart]);
end;
end.

{------------------------------------------------------------}
{ Martin Waldenburg                                          }
{ Landaeckerstrasse 27                                       }
{ 71642 Ludwigsburg                                          }
{ Germany                                                    }
{                                                            }
{ Sugestions, improvements and code of any kind are welcome  }
{ Thanks for trying my code.                                 }
{ Share your code!                                           }
{------------------------------------------------------------}
