{+--------------------------------------------------------------------------+
 | Created:     1.98
 | Author:      Martin Waldenburg
 | Copyright    1997, all rights reserved.
 | Description: Demo for TmEPTokenList, it retrives all classes in an unit.
 | Version:     1.0
 | Status:      FreeWare
 | DISCLAIMER:  This is provided as is, expressly without a warranty of any kind.
 |              You use it at your own risc.
 +--------------------------------------------------------------------------+}

unit BrowserUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  mwFastTime, StdCtrls, mwEPTokenList, ComCtrls, ExtCtrls;

type

  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    Button1: TButton;
    TreeView1: TTreeView;
    Time1: TmwFastTime;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TreeView1Expanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
  private
    Parser: TmEPTokenList;
    Stream: TMemoryStream;
    FFileName: String;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  LastPos: LongInt;
  Info: TmLPasInfo;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  Data: String;
  ClassKind: TmInfoKind;
  InterfaceKind: TmInfoKind;
  aNode, ClForwardNode, ClassesNode, ClReferenceNode, ExceptionsNode,
  IntForwardNode, InterfacesNode: TTreeNode;
  I: Integer;
begin
  TreeView1.Items.Clear;
  TreeView1.Items.BeginUpdate;
  if OpenDialog1.Execute then
  begin
    Time1.Start;
    aNode:= nil;
    FFileName:= OpenDialog1.FileName;
    Stream.Clear;
    Stream.LoadFromFile(FFileName);
    Parser.SetOrigin(Stream.Memory, Stream.Size);
    ExceptionsNode:= TreeView1.Items.AddChild(nil, 'EXCEPTIONS');
    ClForwardNode:= TreeView1.Items.AddChild(nil, 'CLASS FORWARD');
    ClReferenceNode:= TreeView1.Items.AddChild(nil, 'CLASS REFERENCES');
    ClassesNode:= TreeView1.Items.AddChild(nil, 'CLASSES');
    for I:= 0 to Parser.Searcher.ClassList.Count -1 do
    begin
      Parser.RunIndex:= Parser.Searcher.ClassList[I];
      ClassKind:= Parser.GetClassKind;
      Data:= Parser.Info.Data;
      Case ClassKind of
        ikClass:
          begin
            Case Data[1] <> 'E' of
              True: aNode:= TreeView1.Items.AddChild(ClassesNode, Data);
              False: aNode:= TreeView1.Items.AddChild(ExceptionsNode, Data);
            end;
            aNode.HasChildren:= True;
            Info:= TmLPasInfo.Create;
            Info.ID:= Parser.Info.ID;
            Info.Data:= Parser.Info.Data;
            Info.StartIndex:= Parser.Info.StartIndex;
            Info.AI:= TmAdditionalInfo.Create;
            Info.AI.Ready:= False;
            aNode.Data:= Info;
          end;

        ikClEmpty:
          begin
            Case Data[1] <> 'E' of
              True: TreeView1.Items.AddChild(ClassesNode, Data);
              False: TreeView1.Items.AddChild(ExceptionsNode, Data);
            end;
          end;

        ikClForward:
          TreeView1.Items.AddChild(ClForwardNode, Data);

        ikClReference:
          TreeView1.Items.AddChild(ClReferenceNode, Data);
      end;
    end;
    Parser.Searcher.FillInterfaceList;
    IntForwardNode:= TreeView1.Items.AddChild(nil, 'INTERFACE FORWARD');
    InterfacesNode:= TreeView1.Items.AddChild(nil, 'INTERFACES');
    for I:= 0 to Parser.Searcher.InterfaceList.Count -1 do
    begin
      Parser.RunIndex:= Parser.Searcher.InterfaceList[I];
      InterfaceKind:= Parser.GetInterfaceKind;
      Data:= Parser.Info.Data;
      Case InterfaceKind of
        ikInterface:
          begin
            aNode:= TreeView1.Items.AddChild(InterfacesNode, Data);
            aNode.HasChildren:= True;
            Info:= TmLPasInfo.Create;
            Info.ID:= Parser.Info.ID;
            Info.Data:= Parser.Info.Data;
            Info.StartIndex:= Parser.Info.StartIndex;
            Info.AI:= TmAdditionalInfo.Create;
            Info.AI.Ready:= False;
            aNode.Data:= Info;
          end;

        ikIntEmpty:
          begin
            TreeView1.Items.AddChild(InterfacesNode, Data);
          end;

        ikIntForward:
          TreeView1.Items.AddChild(IntForwardNode, Data);
      end;
    end;
    Time1.Stop;
    Edit1.Text:= Time1.ElapsedTime;
  end;
  TreeView1.Items.EndUpdate;
end;

procedure TForm1.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
begin
  if Node.Data <> nil then
  begin
    TmLPasInfo(Node.Data).Free;
    Node.Data:= nil;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Stream:= TMemoryStream.Create;
  Parser:= TmEPTokenList.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Parser.Free;
  Stream.Free;
end;

procedure TForm1.TreeView1Expanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
begin
  if (Node.Data <> nil) then
  if not TmLPasInfo(Node.Data).AI.Ready then
  begin
    Time1.Start;
    Parser.RunIndex:= TmLPasInfo(Node.Data).StartIndex;
    if TmLPasInfo(Node.Data).ID = ikClass then
    Parser.GetClassKind else
    if TmLPasInfo(Node.Data).ID = ikInterface then
    Parser.GetInterfaceKind;
    repeat
      Parser.NextMember;
      TreeView1.Items.AddChild(Node, Parser.Info.Data);
    until (Parser.Info.ID = ikObEnd) or (Parser.Info.ID =ikError);
    TmLPasInfo(Node.Data).AI.Ready:= True;
    Time1.Stop;
    Edit1.Text:= Time1.ElapsedTime;
  end;
end;

end.
