unit PanopticDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, ComCtrls, Grids, Panoptic;

type
  TFlagInfo = record
    GlyphHandle: PChar;
    Title: String;
    BkgrndColor: TColor;
  end;
const
  TTextColor: array[0..9] of TColor = (clBlack, clRed, clYellow, clLime, clGreen, clAqua,
    clNavy, clBlue, clSilver, clFuchsia);
  TRainbowColors: array[0..6] of TColor = (clRed, $000080FF, clYellow, clLime, clBlue,
    clPurple, clFuchsia);

  AussieFlagInfo: array [1..8] of TFlagInfo = (
     (GlyphHandle: 'ASACT'; Title: 'Australian Capital Territory'; BkgrndColor: clAqua),
     (GlyphHandle: 'ASNSW'; Title: 'New South Wales'; BkgrndColor: clAqua),
     (GlyphHandle: 'ASNT'; Title: 'Northern Territory'; BkgrndColor: clYellow),
     (GlyphHandle: 'ASQLD'; Title: 'Queensland'; BkgrndColor: clAqua),
     (GlyphHandle: 'ASSA'; Title: 'South Australia'; BkgrndColor: clYellow),
     (GlyphHandle: 'ASTAS'; Title: 'Tasmania'; BkgrndColor: clAqua),
     (GlyphHandle: 'ASVIC'; Title: 'Victoria'; BkgrndColor: clAqua),
     (GlyphHandle: 'ASWA'; Title: 'Western Australia'; BkgrndColor: clWhite) );
  USStateFlagInfo: array [1..51] of TFlagInfo = (
     (GlyphHandle: 'USALABAMA'; Title: 'Alabama'; BkgrndColor: clAqua),
     (GlyphHandle: 'USALASKA'; Title: 'Alaska'; BkgrndColor: clRed),
     (GlyphHandle: 'USARIZONA'; Title: 'Arizona'; BkgrndColor: clWhite),
     (GlyphHandle: 'USARKANSAS'; Title: 'Arkansas'; BkgrndColor: clYellow),
     (GlyphHandle: 'USCALIFORNIA'; Title: 'California'; BkgrndColor: clLime),
     (GlyphHandle: 'USCOLORADO'; Title: 'Colorado'; BkgrndColor: clWhite),
     (GlyphHandle: 'USCONNECTICUT'; Title: 'Connecticut'; BkgrndColor: clAqua),
     (GlyphHandle: 'USDELAWARE'; Title: 'Delaware'; BkgrndColor: clAqua),
     (GlyphHandle: 'USDISTRICTOFCOLUMBIA'; Title: 'District of Columbia'; BkgrndColor: clAqua),
     (GlyphHandle: 'USFLORIDA'; Title: 'Florida'; BkgrndColor: clAqua),
     (GlyphHandle: 'USGEORGIA'; Title: 'Georgia'; BkgrndColor: clAqua),
     (GlyphHandle: 'USHAWAII'; Title: 'Hawaii'; BkgrndColor: clRed),
     (GlyphHandle: 'USIDAHO'; Title: 'Idaho'; BkgrndColor: clWhite),
     (GlyphHandle: 'USILLINOIS'; Title: 'Illinois'; BkgrndColor: clYellow),
     (GlyphHandle: 'USINDIANNA'; Title: 'Indianna'; BkgrndColor: clAqua),
     (GlyphHandle: 'USIOWA'; Title: 'Iowa'; BkgrndColor: clYellow),
     (GlyphHandle: 'USKANSAS'; Title: 'Kansas'; BkgrndColor: clYellow),
     (GlyphHandle: 'USKENTUCKY'; Title: 'Kentucky'; BkgrndColor: clAqua),
     (GlyphHandle: 'USLOISIANA'; Title: 'Louisiana'; BkgrndColor: clAqua),
     (GlyphHandle: 'USMAINE'; Title: 'Maine'; BkgrndColor: clAqua),
     (GlyphHandle: 'USMARYLAND'; Title: 'Maryland'; BkgrndColor: clAqua),
     (GlyphHandle: 'USMASSACHUSETTS'; Title: 'Massachusetts'; BkgrndColor: clAqua),
     (GlyphHandle: 'USMICHIGAN'; Title: 'Michigan'; BkgrndColor: clAqua),
     (GlyphHandle: 'USMINNESOTA'; Title: 'Minnesota'; BkgrndColor: clAqua),
     (GlyphHandle: 'USMISSISSIPPI'; Title: 'Mississippi'; BkgrndColor: clAqua),
     (GlyphHandle: 'USMISSOURI'; Title: 'Missouri'; BkgrndColor: clYellow),
     (GlyphHandle: 'USMONTANA'; Title: 'Montana'; BkgrndColor: clWhite),
     (GlyphHandle: 'USNEBRASKA'; Title: 'Nebraska'; BkgrndColor: clAqua),
     (GlyphHandle: 'USNEVADA'; Title: 'Nevada'; BkgrndColor: clWhite),
     (GlyphHandle: 'USNEWHAMPSHIRE'; Title: 'New Hampshire'; BkgrndColor: clAqua),
     (GlyphHandle: 'USNEWJERSEY'; Title: 'New Jersey'; BkgrndColor: clAqua),
     (GlyphHandle: 'USNEWMEXICO'; Title: 'New Mexico'; BkgrndColor: clWhite),
     (GlyphHandle: 'USNEWYORK'; Title: 'New York'; BkgrndColor: clAqua),
     (GlyphHandle: 'USNORTHCAROLINA'; Title: 'North Carolina'; BkgrndColor: clAqua),
     (GlyphHandle: 'USNORTHDAKOTA'; Title: 'North Dakota'; BkgrndColor: clYellow),
     (GlyphHandle: 'USOHIO'; Title: 'Ohio'; BkgrndColor: clAqua),
     (GlyphHandle: 'USOKLAHOMA'; Title: 'Oklahoma'; BkgrndColor: clYellow),
     (GlyphHandle: 'USOREGON'; Title: 'Oregon'; BkgrndColor: clLime),
     (GlyphHandle: 'USPENNSYLVANIA'; Title: 'Pennsylvania'; BkgrndColor: clAqua),
     (GlyphHandle: 'USRHODEISLAND'; Title: 'Rhode Island'; BkgrndColor: clAqua),
     (GlyphHandle: 'USSOUTHCAROLINA'; Title: 'South Carolina'; BkgrndColor: clAqua),
     (GlyphHandle: 'USSOUTHDAKOTA'; Title: 'South Dakota'; BkgrndColor: clYellow),
     (GlyphHandle: 'USTENNESSEE'; Title: 'Tennessee'; BkgrndColor: clAqua),
     (GlyphHandle: 'USTEXAS'; Title: 'Texas'; BkgrndColor: clAqua),
     (GlyphHandle: 'USUTAH'; Title: 'Utah'; BkgrndColor: clWhite),
     (GlyphHandle: 'USVERMONT'; Title: 'Vermont'; BkgrndColor: clAqua),
     (GlyphHandle: 'USVIRGINIA'; Title: 'Virginia'; BkgrndColor: clAqua),
     (GlyphHandle: 'USWASHINGTON'; Title: 'Washington'; BkgrndColor: clLime),
     (GlyphHandle: 'USWESTVIRGINIA'; Title: 'West Virginia'; BkgrndColor: clAqua),
     (GlyphHandle: 'USWISCONSIN'; Title: 'Wisconsin'; BkgrndColor: clYellow),
     (GlyphHandle: 'USWYOMING'; Title: 'Wyoming'; BkgrndColor: clWhite) );
type
  TPanopticForm = class(TForm)
    FontDialog1: TFontDialog;
    PageControl2: TPageControl;
    TabSheet1: TTabSheet;
    PanopticGeneral: TPanoptic;
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    StopStartBtn: TSpeedButton;
    Label1: TLabel;
    Continuous: TCheckBox;
    ScrollDirection: TRadioGroup;
    Speed: TTrackBar;
    TabSheet3: TTabSheet;
    FontBtn: TSpeedButton;
    DepthString: TLabel;
    DepthLbl: TLabel;
    TextAlignment: TRadioGroup;
    ShowText: TCheckBox;
    Depth: TTrackBar;
    GroupBox5: TGroupBox;
    ColorBlue: TRadioButton;
    ColorNavy: TRadioButton;
    ColorRed: TRadioButton;
    MultiColor: TRadioButton;
    ColorSilver: TRadioButton;
    GroupBox6: TGroupBox;
    Panoptic1: TPanoptic;
    Panoptic2: TPanoptic;
    Panoptic3: TPanoptic;
    Panoptic4: TPanoptic;
    Normal: TRadioButton;
    Lowered: TRadioButton;
    Raised: TRadioButton;
    Shaddow: TRadioButton;
    TabSheet4: TTabSheet;
    GlyphLayout: TRadioGroup;
    ShowImage: TCheckBox;
    GlyphTransparent: TCheckBox;
    GroupBox4: TGroupBox;
    SpacingLbl: TLabel;
    VaryingSpacing: TSpeedButton;
    Label2: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Spacing: TTrackBar;
    TabSheet6: TTabSheet;
    DrawingEvent: TRadioGroup;
    StarWarsTS: TTabSheet;
    StarWarsPanel: TPanel;
    StarWarsPanoptic: TPanoptic;
    Panel4: TPanel;
    ChangeColors: TCheckBox;
    DarkBackground: TCheckBox;
    TabSheet7: TTabSheet;
    CountryPanoptic: TPanoptic;
    GroupBox3: TGroupBox;
    Label17: TLabel;
    NumberOfFlags: TLabel;
    FlagsBitBtn: TBitBtn;
    FlagLayout: TRadioGroup;
    Panel2: TPanel;
    FlagsPanoptic: TPanoptic;
    FlagsPageControl: TPageControl;
    AussieStates: TTabSheet;
    Shape1: TShape;
    Label7: TLabel;
    Shape3: TShape;
    Label9: TLabel;
    Shape5: TShape;
    Label11: TLabel;
    USStates: TTabSheet;
    Shape6: TShape;
    Label13: TLabel;
    Label14: TLabel;
    Shape7: TShape;
    Shape8: TShape;
    Label15: TLabel;
    Label12: TLabel;
    Shape9: TShape;
    Label16: TLabel;
    Shape10: TShape;
    FlagsTrackBar: TTrackBar;
    TabSheet5: TTabSheet;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Panel1: TPanel;
    Image1: TImage;
    Memo2: TMemo;
    Memo1: TMemo;
    ImaginationTS: TTabSheet;
    ImaginationPanoptic: TPanoptic;
    procedure StopStartBtnClick(Sender: TObject);
    procedure ContinuousClick(Sender: TObject);
    procedure SpeedChange(Sender: TObject);
    procedure ScrollDirectionClick(Sender: TObject);
    procedure TextAlignmentClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GlyphLayoutClick(Sender: TObject);
    procedure SpacingChange(Sender: TObject);
    procedure FontBtnClick(Sender: TObject);
    procedure ShowTextClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ShowImageClick(Sender: TObject);
    procedure PageControl2Change(Sender: TObject);
    procedure FlagsBitBtnClick(Sender: TObject);
    procedure FlagLayoutClick(Sender: TObject);
    procedure GlyphTransparentClick(Sender: TObject);
    procedure VaryingSpacingClick(Sender: TObject);
    procedure DepthChange(Sender: TObject);
    procedure DarkBackgroundClick(Sender: TObject);
    procedure ColorBlueClick(Sender: TObject);
    procedure ShaddowClick(Sender: TObject);
    procedure PanopticGeneralAfterLastStep(Sender: TObject);
    procedure PanopticGeneralDrawGlyph(Sender: TObject; Glyph: TBitmap;
      const PercentDone: Double);
    procedure PanopticGeneralDrawTextLine(Sender: TObject;
      var LineText: string; LineFont: TFont; TextStyle: TTextStyle;
      const LineIndex: Integer; const PercentDone: Double);
    procedure PanopticGeneralStep(Sender: TObject);
    procedure StarWarsPanopticDrawTextLine(Sender: TObject; var LineText: string;
      LineFont: TFont; TextStyle: TTextStyle; const LineIndex: Integer;
      const PercentDone: Double);
    procedure FlagsPanopticStep(Sender: TObject);
    procedure FlagsPageControlChange(Sender: TObject);
    procedure FlagsTrackBarChange(Sender: TObject);
    procedure Panoptic3Click(Sender: TObject);
    procedure ImaginationPanopticBeforeFirstStep(Sender: TObject);
    procedure ImaginationPanopticDrawTextLine(Sender: TObject;
      var LineText: string; LineFont: TFont; TextStyle: TTextStyle;
      const LineIndex: Integer; const PercentDone: Double);
    procedure ImaginationPanopticStep(Sender: TObject);
    procedure CountryPanopticStep(Sender: TObject);
  private
    HoldBitmap: TBitmap;
  public
  end;

var
  PanopticForm: TPanopticForm;

implementation
uses MMSystem;
var CurrentColorDemo1, CurrentColorDemo2, DangerCount, IncrementValue,
      ImaginationCounter: Integer;
    SpacingTimerEnabled: Boolean;
{$R *.DFM}
{$R Demo.res}

procedure TPanopticForm.FormCreate(Sender: TObject);
begin
  CurrentColorDemo1 := 0;
  PanopticGeneral.Interval := Speed.Max + Speed.Min - Speed.Position;
  PanopticGeneral.Enabled := True;
  PanopticGeneral.ScrollDirection := sdRightToLeft;
  SpacingLbl.Caption := IntToStr(Spacing.Position);
  SpacingTimerEnabled := False;
  HoldBitmap := TBitmap.Create;
  HoldBitmap.Assign(PanopticGeneral.Glyph);
  Spacing.Position := PanopticGeneral.Spacing;

  CurrentColorDemo2 := 0;
  StarWarsPanoptic.Enabled := False;
  StarWarsPanoptic.CurrentStep := 0;

  PageControl2.ActivePage := TabSheet1;
  PageControl1.ActivePage := TabSheet2;
  FlagsPageControl.ActivePage := AussieStates;
  with FlagsPanoptic do begin
    CurrentStep := 0;
    Glyph.Handle := LoadBitmap(hInstance, 'ASACT');
  end;
  IncrementValue := -5;

  with CountryPanoptic do begin
    CurrentStep := 0;
    Enabled := False;
  end;

  ImaginationPanoptic.Enabled := False;
end;

procedure TPanopticForm.PageControl2Change(Sender: TObject);
begin
  StarWarsPanoptic.Enabled := False;
  ImaginationPanoptic.Enabled := False;
  if PageControl2.ActivePage = StarWarsTS then StarWarsPanoptic.Enabled := True
  else if PageControl2.ActivePage = ImaginationTS then  begin
    ImaginationCounter := 4;
    with ImaginationPanoptic do begin
      Enabled := True;
      CurrentStep := 0;
    end;
  end;
  FlagsPageControlChange(Sender);
end;

// General (Demo 1)
procedure TPanopticForm.FormDestroy(Sender: TObject);
begin
  HoldBitmap.Free;
end;

procedure TPanopticForm.StopStartBtnClick(Sender: TObject);
begin
  with StopStartBtn do begin
    PanopticGeneral.Enabled := Caption = 'Start';
    if Caption = 'Start' then begin
      Caption := 'Stop';
      Font.Color := clRed;
    end else begin
      Caption := 'Start';
      Font.Color := clLime;
    end;
  end;
end;

procedure TPanopticForm.ContinuousClick(Sender: TObject);
begin
  PanopticGeneral.Continuous := Continuous.Checked;
end;

procedure TPanopticForm.SpeedChange(Sender: TObject);
begin
  PanopticGeneral.Interval := Speed.Max + Speed.Min - Speed.Position;
end;

procedure TPanopticForm.DepthChange(Sender: TObject);
begin
  PanopticGeneral.Depth := Depth.Position;
  DepthLbl.Caption := IntToStr(Depth.Position);
end;

procedure TPanopticForm.ScrollDirectionClick(Sender: TObject);
begin
  case ScrollDirection.ItemIndex of
    0: PanopticGeneral.ScrollDirection := sdBottomToTop;
    1: PanopticGeneral.ScrollDirection := sdBottomToTop;
    2: PanopticGeneral.ScrollDirection := sdLeftToRight;
    3: PanopticGeneral.ScrollDirection := sdRightToLeft;
    4: PanopticGeneral.ScrollDirection := sdStatic;
    5: PanopticGeneral.ScrollDirection := sdTopToBottom;
  end;
end;

procedure TPanopticForm.ShaddowClick(Sender: TObject);
begin
  with Sender as TRadioButton do
    case Tag of
      0: PanopticGeneral.TextStyle := tsLowered;
      1: PanopticGeneral.TextStyle := tsNormal;
      2: PanopticGeneral.TextStyle := tsRaised;
      3: PanopticGeneral.TextStyle := tsShaddow;
    end;
end;

procedure TPanopticForm.Panoptic3Click(Sender: TObject);
begin
  with Sender as TPanoptic do
    case Tag of
      0: Lowered.Checked := True;
      1: Normal.Checked := True;
      2: Raised.Checked := True;
      3: Shaddow.Checked := True;
    end;
end;

procedure TPanopticForm.GlyphTransparentClick(Sender: TObject);
begin
  PanopticGeneral.GlyphTransparent := GlyphTransparent.Checked;
end;

procedure TPanopticForm.TextAlignmentClick(Sender: TObject);
begin
  case TextAlignment.ItemIndex of
    0: PanopticGeneral.TextAlignment := taCenter;
    1: PanopticGeneral.TextAlignment := taLeftJustify;
    2: PanopticGeneral.TextAlignment := taRightJustify;
  end;
end;

procedure TPanopticForm.GlyphLayoutClick(Sender: TObject);
begin
  case GlyphLayout.ItemIndex of
    0: PanopticGeneral.GlyphLayout := glGlyphLeft;
    1: PanopticGeneral.GlyphLayout := glGlyphRight;
    2: PanopticGeneral.GlyphLayout := glGlyphTop;
    3: PanopticGeneral.GlyphLayout := glGlyphBottom;
  end;
end;

procedure TPanopticForm.SpacingChange(Sender: TObject);
begin
  PanopticGeneral.Spacing := Spacing.Position;
  SpacingLbl.Caption := IntToStr(Spacing.Position);
end;

procedure TPanopticForm.ShowTextClick(Sender: TObject);
begin
  PanopticGeneral.Items.Clear;
  if ShowText.Checked then
    with PanopticGeneral.Items do begin
      Add('TPanoptic component');
      Add('by');
      Add('Darryl West');
      Add('(dwest@dot.net.au)');
    end;
end;

procedure TPanopticForm.ShowImageClick(Sender: TObject);
begin
  if ShowImage.Checked then PanopticGeneral.Glyph := HoldBitmap
  else PanopticGeneral.Glyph := nil;
end;

procedure TPanopticForm.VaryingSpacingClick(Sender: TObject);
begin
  SpacingTimerEnabled := not SpacingTimerEnabled;
  VaryingSpacing.Down := SpacingTimerEnabled;
  with VaryingSpacing do
    if SpacingTimerEnabled then Font.Color := clLime
    else Font.Color := clRed;
end;

procedure TPanopticForm.FontBtnClick(Sender: TObject);
begin
  FontDialog1.Font := PanopticGeneral.Font;
  if FontDialog1.Execute then begin
    PanopticGeneral.Font := FontDialog1.Font;
  case PanopticGeneral.Font.Color of
    clBlue: ColorBlue.Checked := True;
    clNavy: ColorNavy.Checked := True;
    clRed: ColorRed.Checked := True;
    clSilver: ColorSilver.Checked := True;
    else begin
      ColorBlue.Checked := True;
      ColorBlue.Checked := False;
    end;
  end;
  end;
end;

procedure TPanopticForm.ColorBlueClick(Sender: TObject);
begin
  with Sender as TRadioButton do begin
    case Tag of
      0: PanopticGeneral.Font.Color := clBlue;
      1: PanopticGeneral.Font.Color := clNavy;
      2: PanopticGeneral.Font.Color := clRed;
      3: PanopticGeneral.Font.Color := clSilver;
    end;
  end;
end;

{ TPanoptic events for General (Demo 1)... }
procedure TPanopticForm.PanopticGeneralDrawTextLine(Sender: TObject;
  var LineText: string; LineFont: TFont; TextStyle: TTextStyle;
  const LineIndex: Integer; const PercentDone: Double);
begin
// Decrease the font size of the "by" line
  if LineIndex = 1 then LineFont.Size := LineFont.Size - 1
// Change the font of the E-mail line
  else if LineIndex = 3 then LineFont.Name := 'Courier New';
end;

procedure TPanopticForm.PanopticGeneralAfterLastStep(Sender: TObject);
begin
  if ScrollDirection.ItemIndex = 0 then
    with PanopticGeneral do
      case ScrollDirection of
        Panoptic.sdBottomToTop, Panoptic.sdRightToLeft: ReverseDirection;
        Panoptic.sdLeftToRight: ScrollDirection := sdBottomToTop;
        Panoptic.sdTopToBottom: ScrollDirection := sdRightToLeft;
        Panoptic.sdStatic: ScrollDirection := sdBottomToTop;
      end;
  with StopStartBtn do begin
    if PanopticGeneral.Continuous then Caption := 'Start'
    else Caption := 'Stop';
    StopStartBtnClick(Self);
  end;
end;

procedure TPanopticForm.PanopticGeneralStep(Sender: TObject);
var I: Integer;
begin
{ Change text color if "Multi Color" selected and on every 15th step. }
  if MultiColor.Checked and (PanopticGeneral.CurrentStep mod 15 = 0) then begin
    CurrentColorDemo1 := (CurrentColorDemo1 + 1) mod 10;
    PanopticGeneral.Font.Color := TTextColor[CurrentColorDemo1];
  end;

{ Change spacing if "Varying" selected and on every 3rd step. }
  if SpacingTimerEnabled and (PanopticGeneral.CurrentStep mod 3 = 0) then begin
    I := Spacing.Position + IncrementValue;
    if I > Spacing.Max then begin
      IncrementValue := -5;
      I := Spacing.Max + IncrementValue;
    end else if I < Spacing.Min then begin
      IncrementValue := 5;
      I := Spacing.Min + IncrementValue;
    end;
    Spacing.Position := I;
    SpacingChange(Self);
  end;
end;

procedure TPanopticForm.PanopticGeneralDrawGlyph(Sender: TObject;
  Glyph: TBitmap; const PercentDone: Double);

  procedure RemoveBorder;
  begin
    with Glyph.Canvas do begin
// Repaint the aqua/maroon/white/black colors with the transparent color
      Brush.Color := clBlack;
      BrushCopy(ClipRect, Glyph, ClipRect, Glyph.TransparentColor);
      Brush.Color := clMaroon;
      BrushCopy(ClipRect, Glyph, ClipRect, Glyph.TransparentColor);
      Brush.Color := clAqua;
      BrushCopy(ClipRect, Glyph, ClipRect, Glyph.TransparentColor);
      Brush.Color := clWhite;
      BrushCopy(ClipRect, Glyph, ClipRect, Glyph.TransparentColor);
    end;
  end;

  procedure Outline;
  begin
    with Glyph.Canvas do begin
// Repaint the navy/red/blue colors with the transparent color
      Brush.Color := clNavy;
      BrushCopy(ClipRect, Glyph, ClipRect, Glyph.TransparentColor);
      Brush.Color := clRed;
      BrushCopy(ClipRect, Glyph, ClipRect, Glyph.TransparentColor);
      Brush.Color := clBlue;
      BrushCopy(ClipRect, Glyph, ClipRect, Glyph.TransparentColor);
// Repaint the aqua/maroon colors with the shaddow/highlight color
      Brush.Color := clBtnHighlight;
      BrushCopy(ClipRect, Glyph, ClipRect, clAqua);
      Brush.Color := clBtnShadow;
      BrushCopy(ClipRect, Glyph, ClipRect, clMaroon);
      BrushCopy(ClipRect, Glyph, ClipRect, clBlack);
    end;
  end;

var Y1, Y2, Delta: Integer;
begin
  with Glyph.Canvas do
    case DrawingEvent.ItemIndex of
      1: begin // Blink eye
// Clear original eye...
        if (PercentDone > 35.0) and (PercentDone < 65.0) then begin
          Brush.Color := Glyph.TransparentColor;
          Pen.Color := Glyph.TransparentColor;
          Ellipse(32, 22, 73, 55);
        end;
// ...paint a new eye (ellipse) with the Y co-ordinates dependent on the percent done
        if ((PercentDone > 35.0) and (PercentDone < 65.0)) then begin
          if PercentDone < 50.0 then Delta := Round(PercentDone) - 35
          else Delta := 100 - Round(PercentDone) - 35;
          Y1 := 23 + Delta;
          Y2 := 55 - Delta;
          Brush.Color := clNavy;
          Ellipse(35, Y1, 70, Y2);
        end;
      end;
      2: Outline; // Outline (Raised)
      3: begin // Outline (Lowered)
        Outline;
// Repaint the light border colors to fuchsia...
        Brush.Color := clFuchsia;
        BrushCopy(ClipRect, Glyph, ClipRect, clBtnHighlight);
// ..Repaint the dark border colors to white...
        Brush.Color := clBtnHighlight;
        BrushCopy(ClipRect, Glyph, ClipRect, clBtnShadow);
// ..Repaint the light(fuchsia) border colors to black...
        Brush.Color := clBtnShadow;
        BrushCopy(ClipRect, Glyph, ClipRect, clFuchsia);
      end;
      4: RemoveBorder; // Flat
      5: begin // Black/white
        RemoveBorder;
        Brush.Color := clBlack;
        BrushCopy(ClipRect, Glyph, ClipRect, clNavy);
        BrushCopy(ClipRect, Glyph, ClipRect, clRed);
        BrushCopy(ClipRect, Glyph, ClipRect, clBlue);
      end;
    end;
end;

// Star Wars Effect (Demo 2)
procedure TPanopticForm.StarWarsPanopticDrawTextLine(Sender: TObject;
  var LineText: string; LineFont: TFont; TextStyle: TTextStyle;
  const LineIndex: Integer; const PercentDone: Double);
begin
  if PercentDone > 95 then LineFont.Size := 1
  else if PercentDone > 60 then begin
    LineFont.Size := LineFont.Size - Round(PercentDone / 6);
    if LineFont.Size < 1 then LineFont.Size := 1;
  end else if PercentDone > 45 then begin
    LineFont.Size := LineFont.Size - Round(PercentDone / 7);
    if LineFont.Size < 1 then LineFont.Size := 1;
  end else if PercentDone > 35 then begin
    LineFont.Size := LineFont.Size - Round(PercentDone / 8);
    if LineFont.Size < 1 then LineFont.Size := 1;
  end else if PercentDone > 20 then begin
    LineFont.Size := LineFont.Size - Round(PercentDone / 10);
    if LineFont.Size < 1 then LineFont.Size := 1;
  end;

  if LineIndex = 6 then LineFont.Name := 'Matura MT Script Capitals';

  if ChangeColors.Checked then
// Change the color 7 times (100/7 ~= 16)
    LineFont.Color := TRainbowColors[Round(PercentDone / 16) mod 7];
end;

procedure TPanopticForm.DarkBackgroundClick(Sender: TObject);
begin
  with StarWarsPanel do
    if Color = clBtnFace then Color := clBtnShadow
    else Color := clBtnFace;
  StarWarsPanoptic.Color := StarWarsPanel.Color;
end;

// Flags (Demo 3)

procedure TPanopticForm.FlagsBitBtnClick(Sender: TObject);
begin
  with FlagsPanoptic do begin
    if Enabled then begin
      FlagsBitBtn.Caption := 'Start';
      FlagsBitBtn.Font.Color := clLime;
    end else begin
      FlagsBitBtn.Caption := 'Stop';
      FlagsBitBtn.Font.Color := clRed;
    end;
    Enabled := not Enabled;
  end;
end;

procedure TPanopticForm.FlagsPageControlChange(Sender: TObject);
begin
  with FlagsPanoptic do begin
    if FlagsPageControl.ActivePage = AussieStates then begin
      Steps := 8;
      CountryPanoptic.Items[0] := 'Australia';
      CountryPanoptic.Glyph.Handle := LoadBitmap(hInstance, 'ASACT');
    end else begin
      Steps := 51;
      CountryPanoptic.Items[0] := 'United States of America';
      CountryPanoptic.Glyph.Handle := LoadBitmap(hInstance, 'USA');
    end;
    CurrentStep := 0;
    Enabled := not Enabled;
    Enabled := not Enabled;
    NumberOfFlags.Caption := IntToStr(Steps);
    FlagsTrackBar.Max := Steps;
    FlagsTrackBar.Position := CurrentStep;
  end;
  with CountryPanoptic do begin
    CurrentStep := 0;
    Enabled := True;
  end;
end;

procedure TPanopticForm.FlagsPanopticStep(Sender: TObject);
begin
  with FlagsPanoptic do
    if FlagsPageControl.ActivePage = AussieStates then begin
      Glyph.Handle := LoadBitmap(hInstance, AussieFlagInfo[CurrentStep].GlyphHandle);
      Items[0] := AussieFlagInfo[CurrentStep].Title;
      Color := AussieFlagInfo[CurrentStep].BkgrndColor;
    end else begin
      Glyph.Handle := LoadBitmap(hInstance, USStateFlagInfo[CurrentStep].GlyphHandle);
      Items[0] := USStateFlagInfo[CurrentStep].Title;
      Color := USStateFlagInfo[CurrentStep].BkgrndColor;
    end;
  FlagsTrackBar.Position := FlagsPanoptic.CurrentStep;
end;

procedure TPanopticForm.FlagLayoutClick(Sender: TObject);
begin
  with FlagsPanoptic do
    case FlagLayout.ItemIndex of
      0: GlyphLayout := glGlyphLeft;
      1: GlyphLayout := glGlyphRight;
      2: GlyphLayout := glGlyphTop;
      3: GlyphLayout := glGlyphBottom;
    end;
end;

procedure TPanopticForm.FlagsTrackBarChange(Sender: TObject);
begin
  FlagsPanoptic.CurrentStep := FlagsTrackBar.Position;
  FlagsPanopticStep(Sender);
end;

procedure TPanopticForm.CountryPanopticStep(Sender: TObject);
begin
  with CountryPanoptic do
    if CurrentStep = 1 then ScrollDirection := sdRightToLeft
    else if CurrentStep = Steps div 2 then ReverseDirection;
end;

// Imagination (Demo 4)
procedure TPanopticForm.ImaginationPanopticBeforeFirstStep(Sender: TObject);
begin
  ImaginationCounter := (ImaginationCounter + 1) mod 5;
  with ImaginationPanoptic do
    case ImaginationCounter of
      0: begin
        TextStyle := tsRaised;
        Visible := True;
        Steps := 50;
        Glyph.Handle := 0;
        Items[0] := 'With a bit of...';
        ScrollDirection := sdRightToLeft;
        PauseTime := 20;
        Glyph.Handle := 0;
        with Font do begin
          Color := clBlue;
          Size := 18;
        end;
      end;
      1: begin
        Steps := 100;
        Items[0] := '...imagination...';
        ScrollDirection := sdLeftToRight;
        PauseTime := 0;
      end;
      2: begin
        Steps := 130;
        Glyph.Handle := 0;
        Items[0] := '...who nos what...';
        Font.Size := 1;
      end;
      3: begin
        Steps := 100;
        Items[0] := '...can be achieved?';
        TextStyle := tsNormal;
        with Font do begin
          Color := clRed;
          Size := 21;
        end;
      end;
      4: begin
        Steps := 50;
        Visible := False;
      end;
    end;
end;

procedure TPanopticForm.ImaginationPanopticDrawTextLine(Sender: TObject;
  var LineText: string; LineFont: TFont; TextStyle: TTextStyle;
  const LineIndex: Integer; const PercentDone: Double);
begin
  with ImaginationPanoptic do
    case ImaginationCounter of
      1: begin
        if CurrentStep > 100 then LineFont.Size := (150 - CurrentStep) div 3 + 2;
        if CurrentStep > 95 then begin
          LineFont.Color := clSilver;
          TextStyle := tsRaised;
        end else LineFont.Color := clBlack;
      end;
    end;
end;

procedure TPanopticForm.ImaginationPanopticStep(Sender: TObject);
begin
  with ImaginationPanoptic do
    case ImaginationCounter of
      1: begin
        if CurrentStep = 50 then begin
          ScrollDirection := sdStatic;
          Steps := 150;
        end;
        if CurrentStep = 1 then Glyph.Handle := LoadBitmap(hInstance, 'BulbOff')
        else if CurrentStep = 100 then Glyph.Handle := 0
        else if (CurrentStep >= 60) and (CurrentStep < 100) then begin
          if CurrentStep mod 20 = 0 then
            Glyph.Handle := LoadBitmap(hInstance, 'BulbOff')
          else if CurrentStep mod 10 = 0 then
            Glyph.Handle := LoadBitmap(hInstance, 'BulbOn');
        end;
      end;
      2: begin
        Font.Color := clSilver;
        TextStyle := tsRaised;
        if CurrentStep = 65 then
          sndPlaySound(PChar('DOH'), snd_RESOURCE OR snd_SYNC); 
        if CurrentStep < 50 then Font.Size := CurrentStep div 3 + 2
        else if CurrentStep < 70 then Items[0] := '...who nos what...'
        else if CurrentStep < 80 then Items[0] := '...who noes what...'
        else if CurrentStep < 90 then Items[0] := '...who nos what...'
        else if CurrentStep < 100 then Items[0] := '...who nows what...'
        else Items[0] := '...who knows what...'
      end;
      3: if CurrentStep = Steps div 2 then ScrollDirection := sdLeftToRight;
  end;
end;

end.

