unit Pages;

(***********************************************************************
 *                                                                     *
 *  Copyright (C) 1996-2000  Erol S. Uzuner                            *
 *                                                                     *
 *  Modul       :       Pages                                          *
 *  Version     :       1.2 (20.04.00)                                 *
 *                                                                     *
 *  Beschreibung:       TPageControles                                 *
 *                                                                     *
 *                                                                     *
 *  Autor       :       Erol S. Uzuner                                 *
 *                                                                     *
 *  Datum       :       Mon Okt 9  20:00:00 1996                       *
 *                                                                     *
 *                                                                     *
 *  Aenderungen :                                                      *
 *  Datum        Autor          Beschreibung                           *
 * 18.04.00     Erol S. Uzuner  Fixed Bug with non TrueTyeFonts and    *
 *                              Left or Right Buttons                  *
 *                              Gradient Filling changed               *
 * 20.04.00	Erol S. Uzuner  Added ChanginTotab Event,              *
 *                              Now painting Images on Tab             *
 *                                                                     *
 ***********************************************************************)

interface
uses SysUtils, Forms, comctrls, Windows, Messages, Controls, Classes, Graphics, ExtCtrls,
     Grafxes, BitmapHolder, CommCtrl, DsgnIntf;

type

  TCustomPageControles = class;

  TCustomTabSheetes = class(TTabSheet)
   private
    FCanvas: TCanvas;
    FTabColor: TColor;
    FTabFontColor: TColor;
    procedure SetTabColor(Value: TColor);
    procedure SetTabFontColor(Value: TColor);
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
  protected
    procedure Paint; virtual;
    procedure PaintWindow(DC: HDC); override;

    property Canvas: TCanvas read FCanvas;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property TabColor: TColor read FTabColor write SetTabColor;
    property TabFontColor: TColor read FTabFontColor write SetTabFontColor;
  end;


  TTabSheetes = class(TCustomTabSheetes)
  private
    { Private-Deklarationen }
    FBitmap          : TBitmap;
    FBitmapHolder    : TBitmapHolder;
    FImageChangeLink : TLinkChange;

    procedure WMEraseBkgnd(var MSG: TWMEraseBkgnd); message wm_EraseBkgnd;  {Hintergund zeichnen}
    procedure DrawBackground(TheHandle : THandle);
  protected
    { Protected-Deklarationen }
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure DrawBorder;
    procedure Paint; override;
    function GetBitmap : TBitmap;
    procedure SetBitmap(Value : TBitmap);
    function GetBitmapHolder : TBitmapHolder;
    procedure SetBitmapHolder(Value : TBitmapHolder);
    procedure BitmapHolderChange(Sender: TObject);
    procedure SetBevelInner(Value: TBevelCut);
    procedure SetBevelOuter(Value: TBevelCut);
    procedure SetBevelWidth(Value: TBevelWidth);
    function getBevelInner : TBevelCut;
    function getBevelOuter : TBevelCut;
    function getBevelWidth : TBevelWidth;

  public
    { Public-Deklarationen }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published-Deklarationen }
    property BevelInner: TBevelCut read getBevelInner write SetBevelInner default bvRaised;
    property BevelOuter: TBevelCut read getBevelOuter write SetBevelOuter default bvLowered;
    property BevelWidth : TBevelWidth read getBevelWidth write SetBevelWidth default 1;
    property Bitmap : TBitmap read GetBitmap write SetBitmap;
    property BitmapHolder : TBitmapHolder read GetBitmapHolder write SetBitmapHolder;
    property BorderWidth;
    property Color;
    property ParentColor;

  end;

  TToTabChangingEvent =  procedure(Sender: TObject; tab : Integer;
    var AllowChange: Boolean) of object;

  TCustomPageControles = class(TPageControl)
  private
    FNextTab : Integer;
    FOffBmp  : TBitmap;
    FGradientFill : Boolean;
    FOnChangingToTab : TToTabChangingEvent;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure CNNotify(var Message: TWMNotify); message CN_NOTIFY;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
  protected
    function CanChangeToTab(tab : integer): Boolean; dynamic;
    procedure Paint; virtual;
   // procedure PaintWindow(DC: HDC); override;
    procedure DrawTab(TabIndex: Integer; const Rect: TRect; Active: Boolean); override;
    procedure setGradientFill(value : Boolean);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property TabFillGradient : Boolean read FGradientFill write setGradientFill default false;
    property OnChangingToTab : TToTabChangingEvent read FOnChangingToTab write FOnChangingToTab;
  end;

  TPageControlBles=class(TPageControl)
  protected
    procedure WndProc(var Message:TMessage); override;
  end;

 TPageControles = class(TCustomPageControles)
  private
    { Private-Deklarationen }
    FBitmap : TBitmap;
    FBitmapHolder : TBitmapHolder;
    FImageChangeLink: TLinkChange;
    FNoBorder : Boolean;
    procedure WMEraseBkgnd(var MSG: TWMEraseBkgnd); message wm_EraseBkgnd;  {Hintergund zeichnen}
    procedure DrawBackground(TheHandle : THandle);

  protected
    { Protected-Deklarationen }
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Paint; override;
    procedure DrawBorder;
    function GetBitmap : TBitmap;
    procedure SetBitmap(Value : TBitmap);
    function GetBitmapHolder : TBitmapHolder;
    procedure SetBitmapHolder(Value : TBitmapHolder);
    procedure BitmapHolderChange(Sender: TObject);
    procedure SetBevelInner(Value: TBevelCut);
    procedure SetBevelOuter(Value: TBevelCut);
    procedure SetBevelWidth(Value: TBevelWidth);
    function getBevelInner : TBevelCut;
    function getBevelOuter : TBevelCut;
    function getBevelWidth : TBevelWidth;
    procedure setNoBorder(value : Boolean);
    procedure WndProc(var Message:TMessage); override;
    procedure DrawTab(TabIndex: Integer; const Rect: TRect; Active: Boolean); override;

  public
    { Public-Deklarationen }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published-Deklarationen }
    property Bitmap : TBitmap read GetBitmap write SetBitmap;
    property BitmapHolder : TBitmapHolder read GetBitmapHolder write SetBitmapHolder;
    property BevelInner: TBevelCut read getBevelInner write SetBevelInner default bvNone;
    property BevelOuter: TBevelCut read getBevelOuter write SetBevelOuter default bvNone;
    property BevelWidth : TBevelWidth read getBevelWidth write SetBevelWidth default 1;
    property BorderInvisible : Boolean read FNoBorder write setNoBorder default false;
  end;


  TPageControlesEditor = class(TDefaultEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;


procedure Register;

implementation
uses ComStrs;

 {Change Strings to your preferred language}
resourcestring
 sTABSHEET_DEFAULT_NAME = 'tbSheetes';
 sNEW_PAGE              = 'Neue Seite';
 sDEL_PAGE              = 'Seite lschen';
 sNEXT_PAGE             = 'Nchste Seite';
 sPREV_PAGE             = 'Vorige Seite';

procedure Register;
begin
//  RegisterComponents('sarcon', [TTabSheetes]);
  RegisterComponents('sarcon', [TPageControles]);
  RegisterComponents('sarcon', [TPageControlBles]);
  RegisterComponentEditor(TPageControles, TPageControlesEditor);
  RegisterComponentEditor(TTabSheetes, TPageControlesEditor);
  RegisterNoIcon([TTabSheetes]);
  RegisterClasses([TTabSheetes]);
end;


{ TCustomTabSheetes }

constructor TCustomTabSheetes.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCanvas := TControlCanvas.Create;
  TControlCanvas(FCanvas).Control := Self;
  TabColor := clBtnFace;
  TabFontColor := clBlack;
  Align := alClient;
  ControlStyle := ControlStyle + [csAcceptsControls, csNoDesignVisible];
  Visible := False;
end;

destructor TCustomTabSheetes.Destroy;
begin
  FCanvas.Free;
  inherited Destroy;
end;

procedure TCustomTabSheetes.WMPaint(var Message: TWMPaint);
begin
  ControlState := ControlState + [csCustomPaint];
  inherited;
  ControlState := ControlState - [csCustomPaint];
end;

procedure TCustomTabSheetes.PaintWindow(DC: HDC);
begin
  FCanvas.Lock;
  try
    FCanvas.Handle := DC;
    try
      TControlCanvas(FCanvas).UpdateTextFlags;
      Paint;
    finally
      FCanvas.Handle := 0;
    end;
  finally
    FCanvas.Unlock;
  end;
end;

procedure TCustomTabSheetes.Paint;
begin
end;

procedure TCustomTabSheetes.SetTabColor(Value: TColor);
begin
 if FTabColor <> value then begin
   FTabColor := Value;
   if Assigned(PageControl) then
     PageControl.Invalidate;
 end;
end;

procedure TCustomTabSheetes.SetTabFontColor(Value: TColor);
begin
  if FTabFontColor <> Value then begin
    FTabFontColor := Value;
    if Assigned(PageControl) then
      PageControl.Invalidate;
  end;
end;

{TTabSheetes}
constructor TTabSheetes.Create(AOwner : TComponent);
begin
   inherited Create(AOwner);
   FBitmap := TBitmap.Create;
   FBitmapHolder := NiL;
   FImageChangeLink := TLinkChange.Create;
   FImageChangeLink.OnChange := BitmapHolderChange;
end;

destructor TTabSheetes.Destroy;
begin
   FBitmap.Free;
   if FBitmapHolder <> NIL then
     FBitmapHolder.UnRegisterChanges(FImageChangeLink);
   FImageChangeLink.Free;
   inherited Destroy;
end;

procedure TTabSheetes.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Assigned(FBitmapHolder) AND (Operation = opRemove) AND (AComponent = FBitmapHolder) then
     FBitmapHolder := NIL;
end;

procedure TTabSheetes.WMEraseBkgnd(var MSG: TWMEraseBkgnd);
begin
  inherited;
  if (FBitmap.Empty) AND (NoT(Assigned(FBitmapHolder)) OR
       (Assigned(FBitmapHolder) AND (FBitmapHolder.isEmpty))) then begin
       Canvas.Brush.Color := Color;
       Windows.FillRect(MSG.DC, GetClientRect, Canvas.Brush.Handle);
       DrawBorder;
  end else
    DrawBackground(MSG.DC);
end;

procedure TTabSheetes.DrawBackground(TheHandle : THandle);
var Rect : TRect;
//    bmp : TBitmap;
begin
  Rect := GetClientRect;
  Rect.TopLeft := ClientRect.TopLeft;
  Rect.BottomRight := ClientRect.BottomRight;

  if NoT(FBitmap.Empty) then
      DrawTiled(TheHandle, rect, FBitmap)
  else if Assigned(FBitmapHolder) AND (NoT FBitmapHolder.isEmpty) then
    FBitmapHolder.TiledOnH(rect, TheHandle);

 // if (Assigned(bmp)) then begin
  (*  if BevelInner <> bvNone then
      InflateRect(rect, -BevelWidth, -BevelWidth);
    if BevelOuter <> bvNone then
      InflateRect(rect, -BevelWidth, -BevelWidth);
  *)
//    DrawTiled(TheHandle, rect, bmp);
//  end;
  DrawBorder;
end;

procedure TTabSheetes.DrawBorder;
var
  Rect: TRect;
  TopColor, BottomColor: TColor;

  procedure AdjustColors(Bevel: TPanelBevel);
  begin
    TopColor := clBtnHighlight;
    if Bevel = bvLowered then TopColor := clBtnShadow;
    BottomColor := clBtnShadow;
    if Bevel = bvLowered then BottomColor := clBtnHighlight;
  end;
begin
  Rect := GetClientRect;
  if NoT (BevelOuter In [bvNone, bvSpace]) then begin
    AdjustColors(BevelOuter);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;

  Frame3D(Canvas, Rect, Color, Color, BorderWidth);
  if BevelInner <> bvNone then begin
    AdjustColors(BevelInner);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
end;

procedure TTabSheetes.Paint;
var
  Rect: TRect;
//  FontHeight: Integer;

begin
  Rect := GetClientRect;
  with Canvas do begin
    Brush.Color := Color;
    if (FBitmap.Empty) AND (NoT(Assigned(FBitmapHolder)) OR
       (Assigned(FBitmapHolder) AND (FBitmapHolder.isEmpty))) then begin
       FillRect(Rect);
       DrawBorder;
    end else
      DrawBackground(Canvas.handle);
  end;
end;

function TTabSheetes.GetBitmap : TBitmap;
begin Result := FBitmap;
end;

procedure TTabSheetes.SetBitmap(Value : TBitmap);
begin
   FBitmap.Assign(Value);
   if FBitmapHolder <> nil then begin
    if Value <> NIL then
      FBitmapHolder.UnRegisterChanges(FImageChangeLink)
    else
      FBitmapHolder.RegisterChanges(FImageChangeLink);
   end;
   inherited Invalidate;
end;

function TTabSheetes.GetBitmapHolder : TBitmapHolder;
begin Result := FBitmapHolder;
end;

procedure TTabSheetes.SetBitmapHolder(Value : TBitmapHolder);
begin
  if FBitmapHolder <> nil then FBitmapHolder.UnRegisterChanges(FImageChangeLink);
  FBitmapHolder := Value;
  if FBitmapHolder <> nil then
  begin
     FBitmapHolder.RegisterChanges(FImageChangeLink);
     Value.FreeNotification(Self);
  end;
  invalidate;
end;

procedure TTabSheetes.BitmapHolderChange(Sender: TObject);
begin inherited invalidate;
end;

procedure TTabSheetes.SetBevelInner(Value: TBevelCut);
begin
  inherited BevelInner := Value;
  Realign;
  Invalidate;
end;

procedure TTabSheetes.SetBevelOuter(Value: TBevelCut);
begin
  inherited BevelOuter := Value;
  Realign;
  Invalidate;
end;

procedure TTabSheetes.SetBevelWidth(Value: TBevelWidth);
begin
  inherited BevelWidth := Value;
  Realign;
  Invalidate;
end;

function TTabSheetes.getBevelInner : TBevelCut;
begin Result := inherited BevelInner;
end;

function TTabSheetes.getBevelOuter : TbevelCut;
begin Result := inherited BevelOuter;
end;

function TTabSheetes.getBevelWidth : TBevelWidth;
begin Result := inherited BevelWidth;
end;


{ TCustomPageControles }

constructor TCustomPageControles.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  OwnerDraw := True;
  ControlStyle := [csDoubleClicks, csOpaque];
  FGradientFill := false;
  FOffBmp := NiL;
end;

destructor TCustomPageControles.Destroy;
begin
  inherited Destroy;
  if Assigned(FOffBmp) then
    FOffBmp.Free;
end;

procedure TCustomPageControles.WMPaint(var Message: TWMPaint);
begin
  ControlState := ControlState + [csCustomPaint];
  inherited;
  ControlState := ControlState - [csCustomPaint];
end;

procedure TCustomPageControles.WMLButtonDown(var Message: TWMLButtonDown);
var hittest : TTCHitTestInfo;
    i       : Integer;
begin
  hittest.pt := SmallPointToPoint(Message.Pos);
  i := TabCtrl_HitTest(self.handle, @hittest);
  if (i<>-1) AND (hittest.flags <> TCHT_NOWHERE) then
    FNextTab := i;
  inherited;
end;


procedure TCustomPageControles.CNNotify(var Message: TWMNotify);
begin
  with Message do
    case NMHdr^.code of
      TCN_SELCHANGE   : Change;
      TCN_SELCHANGING : begin
          Result := 1;
          if CanChangeToTab(FNextTab) AND CanChange then Result := 0;
        end;
    end;
end;

function TCustomPageControles.CanChangeToTab(tab : Integer) : Boolean;
begin
  Result := True;
  if Assigned(FOnChangingToTab) then FOnChangingToTab(Self, tab, Result);
end;

{
procedure TCustomPageControles.PaintWindow(DC: HDC);
begin
 inherited PaintWindow(DC);
end;
}

procedure TCustomPageControles.Paint;
begin
end;

procedure TCustomPageControles.DrawTab(TabIndex: Integer; const Rect: TRect;
  Active: Boolean);

  procedure TextRotate(const S: string; x,y, deg : integer);
  var
    LogFont : tLogFont;
    oldFont : TFont;
  begin
    oldFont := self.Canvas.Font;
    GetObject(oldFont.handle, sizeof(tLogFont),@Logfont);
    Logfont.lfEscapement := deg * 10;
    Logfont.lfOrientation := Logfont.lfEscapement;
    Logfont.lfOutPrecision := OUT_TT_ONLY_PRECIS;   // We need TrueType Fonts
    self.Canvas.Font.handle := CreateFontIndirect(logfont);
    Self.Canvas.textout(x,y,S);
    DeleteObject(self.Canvas.Font.handle);
    self.Canvas.Font := oldFont;
  end;

const imggap = 5;
var R          : TRect;
    x, y, hr,
    wr, angle  : Integer;
    fs         : TSize;
    cap        : String;
    gs         : TGradientStyle;
    imgindx,
    imgx, imgy : Integer;
begin
  //inherited DrawTab(TabIndex, Rect, Active);
  x := 0; y:=0; angle:=0;
  with Canvas do begin
    Brush.Color := TCustomTabSheetes(Pages[TabIndex]).TabColor;
    Canvas.Font := TCustomTabSheetes(Pages[TabIndex]).Font;
    SetBkMode(Canvas.Handle, Opaque);
    if FGradientFill AND (Not HotTrack) then begin
      R := Rect;
      if Active then begin
        gs := gsVertical;
        case TabPosition of
          tpLeft, tpRight   : gs := gsVertical;
          tpTop, tpBottom   : gs := gsHorizontal;
        end;
        InflateRect(R, -1, 0);
        GradientFillRect(Canvas, R, TColor($00FFFFFF), ColorToRGB(Brush.Color), gs);
      end else begin
        case TabPosition of
          tpLeft  : begin
             InflateRect(R, 1, 0);
             OffsetRect(R, 1, 0);
             gs := gsVertical;
            end;
          tpTop   : begin
             InflateRect(R, -1, 1);
             OffsetRect(R, 0, 1);
             gs := gsHorizontal;
            end;
          tpRight  : begin
             InflateRect(R, 1, 0);
             OffsetRect(R, -1, 0);
             gs := gsVertical;
            end;
          tpBottom : begin
             InflateRect(R, -1, 1);
             OffsetRect(R, 0, -1);
             gs := gsHorizontal;
            end;
        end;

        GradientFillRect(Canvas, R, ColorToRGB(Brush.Color), TColor($00888888), gs);
      end;

    end else
      FillRect(Rect);

    Font.Color := TCustomTabSheetes(Pages[TabIndex]).TabFontColor;
    Brush.Style := bsClear;

    SetBkMode(Canvas.Handle, Transparent);
    R := Rect;
    if Assigned(Images) then begin
      case TabPosition of
        tpTop,
        tpBottom : Inc(R.Left, Images.Width  + imggap);
        tpLeft   : Dec(R.Bottom, Images.Height + imggap);
        tpRight  : Inc(R.Top, Images.Height + imggap);
      end;
    end;

    cap := Pages[TabIndex].Caption;
    fs  := TextExtent(cap);
    hr  := R.Bottom - R.Top;
    wr  := R.Right  - R.Left;
    case TabPosition of
      tpTop, tpBottom : begin
          Inc(R.Left, (wr - fs.cx) shr 1);
          Inc(R.Top, (hr - fs.cy) shr 1);
          if Not Active then begin
            case TabPosition of
              tpTop    : Inc(R.Top, 2);
              tpBottom : Dec(R.Top, 2);
            end;
          end;
          TextRect(R,R.Left, R.Top, cap);
        end;
      tpLeft, tpRight : begin
          Inc(R.Left, (wr - fs.cy) shr 1);
          Inc(R.Top, (hr - fs.cx) shr 1);
          case TabPosition of
             tpLeft : begin
                 y := R.Top + fs.cx;
                 x := R.Left;
                 angle := 90;
               end;
             tpRight : begin
                 y := R.Top;
                 x := R.Left + fs.cy;
                 angle := 270;
               end;
          end;
          TextRotate(cap, x, y, angle);
        end;
    end;

    if Assigned(Images) then begin
      imgindx := Pages[TabIndex].ImageIndex;
      imgx :=0; imgy :=0;
      case TabPosition of
        tpTop,
        tpBottom : begin
              imgx := R.Left-(Images.Width+imggap);
              imgy := R.Top-2;
           end;
        tpLeft   : begin
              imgx := R.Left;
              imgy := R.Top+fs.cx+imggap;
              if Not Active then
                  Inc(imgx, 2);
           end;
        tpRight  : begin
              imgx := R.Left;
              imgy := R.Top-(Images.Height+imggap);
              if Not Active then
                  Dec(imgx, 2);
           end;
      end;
      Images.Draw(Canvas, imgx, imgy, imgindx);
    end;

    //DrawFocusRect(Rect);
  end;
end;

procedure TCustomPageControles.setGradientFill(value : Boolean);
begin
 if FGradientFill <> Value then begin
   FGradientFill := Value;
   invalidate;
 end;
end;

procedure AdjustRect(var r : PRect; TabPosition : TTabPosition; tabsvisible : Boolean);
var d : Integer;
begin
    if tabsvisible then d := 2
    else d:= 2;

    if TabPosition = tpLeft then
         r^.Left:=r^.Left-d
    else r^.Left:=r^.Left-4;

    if TabPosition = tpRight then
          r^.Right:=r^.Right+d
    else  r^.Right:=r^.Right+4;

    if TabPosition = tpTop then
         r^.Top:=r^.Top-(d+2)
    else r^.Top:=r^.Top-6;

    if TabPosition = tpBottom then
         r^.Bottom:=r^.Bottom+d
    else r^.Bottom:=r^.Bottom+4;
end;

{TPageControlBles}

procedure TPageControlBles.WndProc(var Message:TMessage);
var i : integer;
    tabsvisible : Boolean;
begin
  if(Message.Msg=TCM_ADJUSTRECT) then begin
    Inherited WndProc(Message);
    tabsvisible := false;
    for i := 0 to PageCount-1 do begin
       if Pages[i].TabVisible then begin
           tabsvisible := true;
           break;
       end;
    end;
    AdjustRect(PRect(Message.LParam), TabPosition, tabsvisible);
  end else Inherited WndProc(Message);
end;


{ TPageControles }
constructor TPageControles.Create(AOwner : TComponent);
begin
     inherited Create(AOwner);
     FBitmap := TBitmap.Create;
     FBitmapHolder := NiL;
     FImageChangeLink := TLinkChange.Create;
     FImageChangeLink.OnChange := BitmapHolderChange;
     BevelInner := bvNone;
     BevelOuter := bvNone;
     FNoBorder := false;
end;

destructor TPageControles.Destroy;
begin
     FBitmap.Free;
     if FBitmapHolder <> NIL then
       FBitmapHolder.UnRegisterChanges(FImageChangeLink);
     FImageChangeLink.Free;

     inherited Destroy;
end;


procedure TPageControles.WndProc(var Message:TMessage);
var i : integer;
    tabsvisible : Boolean;
begin
  if(Message.Msg=TCM_ADJUSTRECT) then begin
    Inherited WndProc(Message);
    if FNoBorder then begin
      tabsvisible := false;
      for i := 0 to PageCount-1 do begin
         if Pages[i].TabVisible then begin
             tabsvisible := true;
             break;
         end;
      end;
      AdjustRect(PRect(Message.LParam), TabPosition, tabsvisible);
    end else begin
       if TabPosition <> tpTop then
        PRect(Message.LParam)^.Top:=PRect(Message.LParam)^.Top-2;
    end;
  end else Inherited WndProc(Message);
end;

procedure TPageControles.WMEraseBkgnd(var MSG: TWMEraseBkgnd);
begin
  inherited;
  if (FBitmap.Empty) AND (NoT(Assigned(FBitmapHolder)) OR
       (Assigned(FBitmapHolder) AND (FBitmapHolder.Bitmap.Empty))) then begin
       Canvas.Brush.Color := Color;
       Windows.FillRect(MSG.DC, GetClientRect, Canvas.Brush.Handle);
       DrawBorder;
  end else
    DrawBackground(MSG.DC);
end;

procedure TPageControles.DrawBackground(TheHandle : THandle);
var Rect : TRect;
    bmp : TBitmap;
begin
  Rect := GetClientRect;

  if NoT(FBitmap.Empty) then
    bmp := FBitmap
  else if Assigned(FBitmapHolder) AND NoT(FBitmapHolder.Bitmap.Empty) then
    bmp := FBitmapHolder.Bitmap
  else bmp := NIL;

  if (Assigned(bmp)) then begin
    Rect.TopLeft := ClientRect.TopLeft;
    Rect.BottomRight := ClientRect.BottomRight;

    DrawTiled(TheHandle, rect, bmp);
  end;
  DrawBorder;
end;


procedure TPageControles.DrawBorder;
var
  Rect: TRect;
  TopColor, BottomColor: TColor;

  procedure AdjustColors(Bevel: TBevelCut);
  begin
    TopColor := clBtnHighlight;
    if Bevel = bvLowered then TopColor := clBtnShadow;
    BottomColor := clBtnShadow;
    if Bevel = bvLowered then BottomColor := clBtnHighlight;
  end;
begin
  Rect := GetClientRect;
  if NoT (BevelOuter in [bvNone, bvSpace]) then begin
    AdjustColors(BevelOuter);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;

  Frame3D(Canvas, Rect, Color, Color, BorderWidth);
  if BevelInner <> bvNone then begin
    AdjustColors(BevelInner);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
end;

procedure TPageControles.Paint;
var
  Rect: TRect;
//  FontHeight: Integer;

begin
  Rect := GetClientRect;
  with Canvas do begin
    Brush.Color := Color;
    if (FBitmap.Empty) AND (NoT(Assigned(FBitmapHolder)) OR
       (Assigned(FBitmapHolder) AND (FBitmapHolder.Bitmap.Empty))) then begin
       FillRect(Rect);
       DrawBorder;
    end else
      DrawBackground(Canvas.handle);
  end;
end;

procedure TPageControles.DrawTab(TabIndex: Integer; const Rect: TRect; Active: Boolean);
//var r : TRect;
begin
   { if NoT ((FBitmap.Empty) AND (NoT(Assigned(FBitmapHolder)) OR
       (Assigned(FBitmapHolder) AND (FBitmapHolder.Bitmap.Empty)))) then begin

       r.Left := Rect.left+2; r.Top := rect.Top+2;
       r.Right := rect.Right-2; r.bottom := rect.bottom-2;
       DrawTiled(Canvas.Handle, r, BitmapHolder.Bitmap);
    end;}
   inherited DrawTab(TabIndex, Rect, Active);
end;

function TPageControles.GetBitmap : TBitmap;
begin Result := FBitmap;
end;

procedure TPageControles.SetBitmap(Value : TBitmap);
begin
   FBitmap.Assign(Value);
   if FBitmapHolder <> nil then begin
    if Value <> NIL then
      FBitmapHolder.UnRegisterChanges(FImageChangeLink)
    else
      FBitmapHolder.RegisterChanges(FImageChangeLink);
   end;
   inherited Invalidate;
end;

function TPageControles.GetBitmapHolder : TBitmapHolder;
begin Result := FBitmapHolder;
end;

procedure TPageControles.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Assigned(FBitmapHolder) AND (Operation = opRemove) AND (AComponent = FBitmapHolder) then
     FBitmapHolder := NIL;
end;

procedure TPageControles.SetBitmapHolder(Value : TBitmapHolder);
begin
  if FBitmapHolder <> nil then FBitmapHolder.UnRegisterChanges(FImageChangeLink);
  FBitmapHolder := Value;
  if FBitmapHolder <> nil then
  begin
     FBitmapHolder.RegisterChanges(FImageChangeLink);
     Value.FreeNotification(Self);
  end;
  invalidate;
end;

procedure TPageControles.BitmapHolderChange(Sender: TObject);
begin inherited invalidate;
end;

procedure TPageControles.SetBevelInner(Value: TBevelCut);
begin
  inherited BevelInner := Value;
  Realign;
  Invalidate;
end;

procedure TPageControles.SetBevelOuter(Value: TBevelCut);
begin
  inherited BevelOuter := Value;
  Realign;
  Invalidate;
end;

procedure TPageControles.SetBevelWidth(Value: TBevelWidth);
begin
  inherited BevelWidth := Value;
  Realign;
  Invalidate;
end;

function TPageControles.getBevelInner : TBevelCut;
begin Result := inherited BevelInner;
end;

function TPageControles.getBevelOuter : TbevelCut;
begin Result := inherited BevelOuter;
end;

function TPageControles.getBevelWidth : TBevelWidth;
begin Result := inherited BevelWidth;
end;

procedure TPageControles.setNoBorder(value : Boolean);
begin
 if FNoBorder <> Value then begin
   FNoBorder := Value;
   Realign;
   Invalidate;
 end;
end;


{ TPageControlesEditor }

procedure TPageControlesEditor.ExecuteVerb(Index: Integer);
var
  NewPage: TCustomTabSheetes;
  PControl : TPageControles;
begin
  if Component is TPageControles then
    PControl := TPageControles(Component)
  else PControl := TPageControles(TTabSheetes(Component).PageControl);

  case Index of
    0:  begin  //  New Page
          NewPage := TTabSheetes.Create(Designer.GetRoot);
          with NewPage do
          begin
            Parent      := PControl;
            PageControl := PControl;
            Caption     := sTABSHEET_DEFAULT_NAME + IntToStr(PControl.PageCount);
            Name        := Caption;
          end;
        end;
    1:  begin  //  Delete Page
          with PControl do
          begin
            NewPage := TCustomTabSheetes(ActivePage);
            NewPage.PageControl := nil;
            NewPage.Free;
          end;
        end;
    2:  begin  //  Next Page
          PControl.FindNextPage(PControl.ActivePage,True,False);
        end;
    3:  begin  //  Previous Page
          PControl.FindNextPage(PControl.ActivePage,False,False);
        end;
  end;
  if Designer <> nil then Designer.Modified;
end;

function TPageControlesEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0:  result := sNEW_PAGE;
    1:  result := sDEL_PAGE;
    2:  result := sNEXT_PAGE;
    3:  result := sPREV_PAGE;
  end;
end;

function TPageControlesEditor.GetVerbCount: Integer;
begin
  result := 4;
end;

end.

