unit BitmapHolder;
(***********************************************************************
 *                                                                     *
 *  Copyright (C) 1996-1998                                            *
 *  Erol S. Uzuner                                                     *
 *                                                                     *
 *  Modul       :       BitmapHolder                                   *
 *  Version     :       1.0 (27.05.98)                                 *
 *                                                                     *
 *  Beschreibung:      TBitmapHolder Komponente                        *
 *                                                                     *
 *  Autor       :       Erol S. Uzuner                                 *
 *                                                                     *
 *  Datum       :       27.05.98  02:15:00 1998                        *
 *                                                                     *
 *                                                                     *
 *  Aenderungen :                                                      *
 *  Datum        Autor          Beschreibung                           *
 *
 ***********************************************************************)


interface

uses
  Windows, Classes, Graphics;

type
  TBitmapHolder = class;
{ TLinkChange }

  TLinkChange = class(TObject)
  private
    FSender: TBitmapHolder;
    FOnChange: TNotifyEvent;
  public
    destructor Destroy; override;
    procedure Change; dynamic;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property Sender: TBitmapHolder read FSender write FSender;
  end;

{ TBitmapHolder }
  TBitmapHolder = class(TComponent)
  private
    { Private-Deklarationen }
    FBitmap : TBitmap;
    FClients : TList;
    procedure OnBitmapChange(Sender : TObject);
  protected
    { Protected-Deklarationen }
    procedure SetBitmap(Value : TBitmap);
    function GetBitmap : TBitmap;
    procedure Change;
  public
    { Public-Deklarationen }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure RegisterChanges(Value: TLinkChange);
    procedure UnRegisterChanges(Value: TLinkChange);

    procedure DrawOnH   (Dest: TRect ; handle: THandle ; Xsrc, Ysrc : Integer);
    procedure TiledOnH  (Dest: TRect ; handle: THandle);
    procedure StretchOnH(Dest: TRect ; handle: THandle);

    procedure DrawOn   (Dest: TRect ; Canevas: TCanvas ; Xsrc, Ysrc : Integer);
    procedure TiledOn  (Dest: TRect ; Canevas: TCanvas);
    procedure StretchOn(Dest: TRect ; Canevas: TCanvas);

    function isEmpty : Boolean;

  published
    { Published-Deklarationen }
    property Bitmap : TBitmap read GetBitmap write SetBitmap;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('sarcon', [TBitmapHolder]);
end;

constructor TBitmapHolder.Create(AOwner : TComponent);
begin
    inherited Create(AOwner);
    FBitmap := TBitmap.Create;
    FBitmap.OnChange := OnBitmapChange;
    FClients := TList.Create;
end;

destructor TBitmapHolder.Destroy;
begin
  while FClients.Count > 0 do
    UnRegisterChanges(TLinkChange(FClients.Last));

  FBitmap.Free;
  FClients.Free;
  inherited Destroy;
end;

procedure TBitmapHolder.OnBitmapChange(Sender : TObject);
begin  Change;
end;

procedure TBitmapHolder.SetBitmap(Value : TBitmap);
begin
    FBitmap.Assign(Value);
    Change;
end;

function TBitmapHolder.GetBitmap : TBitmap;
begin
   Result := FBitmap;
end;

function TBitmapHolder.isEmpty : Boolean;
begin Result := (FBitmap = NiL) OR (FBitmap.Empty);
end;

procedure TBitmapHolder.Change;
var
  I: Integer;
begin
  for I := 0 to FClients.Count - 1 do
    TLinkChange(FClients[I]).Change;
  //if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TBitmapHolder.UnRegisterChanges(Value: TLinkChange);
var
  I: Integer;
begin
  for I := 0 to FClients.Count - 1 do
    if FClients[I] = Value then
    begin
      Value.Sender := nil;
      FClients.Delete(I);
      Break;
    end;
end;

procedure TBitmapHolder.RegisterChanges(Value: TLinkChange);
begin
  Value.Sender := Self;
  FClients.Add(Value);
end;

procedure TBitmapHolder.DrawOnH(Dest: TRect ; handle: THandle ; Xsrc, Ysrc : Integer);
begin
 BitBlt(Handle, Dest.Left, Dest.Top, Dest.Right, Dest.Bottom,
         FBitmap.Canvas.Handle, Xsrc, Ysrc, SRCCOPY);
end;

procedure TBitmapHolder.TiledOnH(Dest: TRect ; handle: THandle);
var
  Row, Col : Integer;
  NumRows, NumCols: Integer;
  DrawX, DrawY, DrawWidth, DrawHeight: Integer;
//  OldRect : TRect;
begin

  NumRows := Dest.Bottom DIV FBitmap.Height;
  NumCols := Dest.Right DIV FBitmap.Width;
  for Row := 0 to NumRows+1 do
    for Col := 0 to NumCols+1  do
    begin
      DrawX :=  (Col * FBitmap.Width) + Dest.Left;
      DrawY :=  (Row * FBitmap.Height) + Dest.Top;
      if (DrawX + FBitmap.Width) > Dest.Right then
         DrawWidth :=  Dest.Right - DrawX
      else
         DrawWidth :=  FBitmap.Width;

      if (DrawY + FBitmap.Height) > Dest.Bottom then
         DrawHeight :=  Dest.Bottom - DrawY
      else
         DrawHeight := FBitmap.Height;
//      GetClipBox(DC, OldRect);
//      IntersectCliprect(DC, CR.Left, CR.Top, CR.Right, CR.Bottom);
      BitBlt( Handle,
              DrawX, DrawY, DrawWidth, DrawHeight,
              FBitmap.Canvas.Handle,
              0, 0, SRCCOPY);
//      IntersectCliprect(DC, OldRect.Left, OldRect.Top, OldRect.Right, OldRect.Bottom);
    end;
end;

procedure TBitmapHolder.StretchOnH(Dest: TRect ; handle: THandle);
begin
  StretchBlt(Handle, Dest.Top, Dest.Left, Dest.Right, Dest.Bottom,
             FBitmap.Canvas.Handle, 0, 0, FBitmap.Width-1, FBitmap.Height-1, SRCCOPY);
end;

procedure TBitmapHolder.DrawOn(Dest: TRect ; Canevas: TCanvas ; Xsrc, Ysrc : Integer);
begin
 BitBlt(Canevas.Handle, Dest.Left, Dest.Top, Dest.Right, Dest.Bottom,
         FBitmap.Canvas.Handle, Xsrc, Ysrc, SRCCOPY);
end;

procedure TBitmapHolder.TiledOn(Dest: TRect ; Canevas: TCanvas);
begin TiledOnH(Dest, Canevas.Handle);
end;

procedure TBitmapHolder.StretchOn(Dest: TRect ; Canevas: TCanvas);
begin
  StretchBlt(Canevas.Handle, Dest.Top, Dest.Left, Dest.Right, Dest.Bottom,
             FBitmap.Canvas.Handle, 0, 0, FBitmap.Width-1, FBitmap.Height-1, SRCCOPY);
end;

{ TLinkChange }

destructor TLinkChange.Destroy;
begin
  if Sender <> nil then Sender.UnRegisterChanges(Self);
  inherited Destroy;
end;

procedure TLinkChange.Change;
begin
  if Assigned(OnChange) then OnChange(Sender);
end;


end.
