unit PgPrnReg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DsgnIntf, TypInfo, PagePrnt;

type
  TFriendlyFmtDlg = class(TForm)
    Edit: TEdit;
    List: TListBox;
    btnOK: TButton;
    btnCancel: TButton;
    procedure ListDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TFriendlyFormatProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TPagePrinterComponentEditor = class(TDefaultEditor)
  public
    //Makes a double-click go to the OnNewPage event.
    procedure EditProperty(PropertyEditor: TPropertyEditor;
              var Continue, FreeEditor: Boolean); override;
    //Sets up the design-time verbs.
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

procedure Register;

implementation

{$R *.DFM}

uses
    PgPrnAbt;

{============ TFriendlyFmtDlg ============}

procedure TFriendlyFmtDlg.ListDblClick(Sender: TObject);
var
   S: String;
begin
     S:=Copy(List.Items[List.ItemIndex], 1, 2);
     if S <> '--' then Edit.SelText:=S;
     if Edit.CanFocus then Edit.SetFocus;
end;

{============ TFriendlyFormatProperty ============}

procedure TFriendlyFormatProperty.Edit;
var
  FriendlyFmtDlg: TFriendlyFmtDlg;
begin
     FriendlyFmtDlg := TFriendlyFmtDlg.Create(Application); { construct the editor }
     try
        FriendlyFmtDlg.Edit.Text := GetStrValue;      { use the existing value }
        if FriendlyFmtDlg.ShowModal = mrOk then       { if the user OKs the dialog... }
           SetStrValue(FriendlyFmtDlg.Edit.Text);     { ...use the result to set value }
     finally
            FriendlyFmtDlg.Free; { destroy the editor }
     end;
end;

function TFriendlyFormatProperty.GetAttributes: TPropertyAttributes;
begin
     Result:=(inherited GetAttributes)+[paDialog];
end;

{============ TPagePrinterComponentEditor ============}

procedure TPagePrinterComponentEditor.EditProperty(PropertyEditor: TPropertyEditor;
          var Continue, FreeEditor: Boolean);
begin
     if (PropertyEditor is TMethodProperty) and
        (CompareText(PropertyEditor.GetName, 'OnNewPage') = 0) then
     begin
          inherited EditProperty(PropertyEditor, Continue, FreeEditor);
     end;
end;

procedure TPagePrinterComponentEditor.ExecuteVerb(Index: Integer);
var
   AboutBox: TPgPrnAboutBox;
begin
     case Index of
          0: begin //Preview
                  with Component as TPagePrinter do
                  begin
                       BeginDoc;
                       WriteLines(False);
                       EndDoc;
                  end;
                  Designer.Modified;
             end;
          1: begin //About...
                  AboutBox:=TPgPrnAboutBox.Create(Application);
                  try
                     AboutBox.ShowModal;
                  finally
                         AboutBox.Free;
                  end;
             end;
          2: begin //Next Page
                  with Component as TPagePrinter do
                  begin
                       if (PageCount > 0) and (PageNumber < PageCount) then
                          PageNumber:=PageNumber+1;
                  end;
                  Designer.Modified;
             end;
          3: begin //Prev Page
                  with Component as TPagePrinter do
                  begin
                       if (PageCount > 0) and (PageNumber > 1) then
                          PageNumber:=PageNumber-1;
                  end;
                  Designer.Modified;
             end;
          4: begin //Clear
                  with Component as TPagePrinter do
                       Clear;
                  Designer.Modified;
             end;
     end;
end;

function TPagePrinterComponentEditor.GetVerb(Index: Integer): string;
begin
     case Index of
          0: Result:='Preview';
          1: Result:='About TPagePrinter...';
          2: Result:='Next Page';
          3: Result:='Previous Page';
          4: Result:='Clear';
     end;
end;

function TPagePrinterComponentEditor.GetVerbCount: Integer;
begin
     Result:=2;
     with Component as TPagePrinter do
          if PageCount > 0 then Result:=5
end;

{=============================================================================}
{ Register Function for TPagePrinter.                                         }
{=============================================================================}

procedure Register;
begin
     RegisterComponents('Menees', [TPagePrinter]);
     RegisterPropertyEditor(TypeInfo(String), TPagePrinter,
         'FriendlyHeader', TFriendlyFormatProperty);
     RegisterPropertyEditor(TypeInfo(String), TPagePrinter,
         'FriendlyFooter', TFriendlyFormatProperty);
     RegisterComponentEditor(TPagePrinter, TPagePrinterComponentEditor);
end;

end.
