/*===========================================================================*/
/*Metadata Extract performed 10-Oct-1999 01:42                               */
/*===========================================================================*/

/*===========================================================================*/
/*Create Database                                                            */
/*===========================================================================*/
create database "ourbillsdb.dat" user "SYSDBA" password "masterkey" page_size = 1024;



/*===========================================================================*/
/*Domain Definitions                                                         */
/*===========================================================================*/


/*===========================================================================*/
/*Table Definitions                                                          */
/*                                                                           */
/* NOTE:                                                                     */
/* Foreign Key Definintions are included commented out with each table       */
/* for documentation purposes the actual definitions appear after all tables */
/* have been described.                                                      */
/*===========================================================================*/

/*Table: CREDITORS*/
create table CREDITORS(
     CREDITORID integer not null,
     NAME varchar(80) not null,
     ADDRESS1 varchar(80),
     ADDRESS2 varchar(80),
     CITY varchar(40) not null,
     STATE varchar(2) not null,
     ZIP varchar(10) not null,
     PHONE varchar(20),
     STARTINGBALANCE float);

alter table CREDITORS add constraint PK_CREDITORS primary key (CREDITORID);


/*Table: BILLS*/
create table BILLS(
     BILLID integer not null,
     RECEIVEDATE date not null,
     DUEDATE date not null,
     DUEAMOUNT float not null,
     SENTDATE date,
     SENTAMOUNT float,
     CHECKNUMBER integer,
     BALANCEDUE float,
     CREDITORID integer not null,
     PAID smallint);

alter table BILLS add constraint PK_BILLS primary key (BILLID);

/*alter table BILLS add constraint FK_BILLS foreign key (CREDITORID) references CREDITORS(CREDITORID);*/




/*===========================================================================*/
/*Foreign Key Definitions                                                    */
/*===========================================================================*/

alter table BILLS add constraint FK_BILLS foreign key (CREDITORID) references CREDITORS(CREDITORID);


/*===========================================================================*/
/*View Definitions                                                           */
/*===========================================================================*/


/*===========================================================================*/
/*Generator Definitions                                                      */
/*===========================================================================*/

create generator BILLSGEN;
create generator CREDITORSGEN;


/*===========================================================================*/
/*Exception Definitions                                                      */
/*===========================================================================*/


/*===========================================================================*/
/*UDF Definitions                                                            */
/*===========================================================================*/


/*===========================================================================*/
/*Stored Procedure Definitions                                               */
/*===========================================================================*/
commit work;
set autoddl off;
set term ^;

commit work^
set autoddl on^
set term ;^



/*===========================================================================*/
/*Trigger Definitions                                                        */
/*===========================================================================*/
commit work;
set autoddl off;
set term ^;

create trigger pk_billgen for BILLS active before insert position 0as
begin
NEW.Billid = GEN_ID(BillsGen, 1);

end^

create trigger pk_creditorgen for CREDITORS active before insert position 0as
begin
NEW.creditorid = GEN_ID(creditorsGen, 1);

end^

commit work^
set autoddl on^
set term ;^

