unit creditors;

interface
uses Sets,classes,sysutils;
type
TCreditorRecord = record
	Creditorid:longint;
	Name:String[80];
	Phone:String[15];
	Ext:String[10];
	Addr1:String[80];
	Addr2:String[80];
	City:String[80];
	State:String[2];
	Zip:String[10];
      StartingBalance:Double;
end ;


CreditorFile= File of TCreditorRecord;


TCreditorTable = class (TObject)
 Private
 protected
  function FindFirstDeleted:longint;
  function FindRecOffset (index:longint):longint;

 public
   constructor create; virtual;
  destructor destroy;override;
  procedure close;
  procedure reopen;
  function RelationisTrue (Rec:TCreditorRecord;wherefield,relationship,value:String):Boolean;
 published       
	function NewCreditor:TCreditorRecord;
	function AddCreditor(newCreditor:TCreditorRecord):longint;
	function DeleteCreditor (Creditor:TCreditorRecord):Tdberror;
	function UpdateCreditor (oldCreditor,newCreditor:TCreditorRecord):Tdberror;
	function FetchCreditor(index:longint):TCreditorrecord;
	function GetCreditors (Wherefield,relationship,Value:String;FilterList:TList):TList;
	function CreditorExists(index:longint):boolean;

end;

var
 CF: CreditorFile;

implementation



function TCreditorTable.NewCreditor:TCreditorRecord;
var b:TCreditorRecord;
begin
 result:=b;
end;

function TCreditorTable.FindRecOffset (index:longint):longint;
var i,fpos,foundat,start:longint;found:boolean;fs:longint;CR:TCreditorRecord;
begin
{result := 0 means, not found}
result:=0;
fpos:=0;
//start:=FilePos(CF) ;
Reset(CF);

foundat:=-1;
if Filesize(CF)>0 then
While (not(found) AND not(EOF(CF))) do
 begin
  read(CF,CR);
  if CR.Creditorid=index then
    begin
	found:=true;
 	foundat:=fpos;
    end;
    inc(fpos);
 end;
 
result:=foundat ;
end;

function TCreditorTable.FindFirstDeleted:longint;
begin
 result:=FindRecOffset(0);
end;

function TCreditorTable.AddCreditor (newCreditor:TCreditorRecord):longint;
var d,idnum,fpos,foundat:longint;  ID:TIDRecord; IDF:TIDFile; nc:TCreditorrecord;
begin
{Lock here}
reopen;
d:=0;
 d:= findfirstdeleted();
 nc:=newCreditor;
 if d = -1 then
    begin
      Seek(CF,Filesize(CF));
    end;
 if d> -1 then
       	Seek(CF,d);
		//Seek(CF,filepos(CF)-d,1);
 {Write rec to transaction table here}

 if not(fileexists('Ids.dat')) then
  begin
   assignfile(IDF,'Ids.dat');
   rewrite(IDF);

  ID.TableName :='CREDITORS';
  ID.counter :=2;
   write (IDF,ID);
   closefile(IDF);
   idnum:=1
  end  else
     begin
      assignfile(IDF,'Ids.dat');
      reset(IDF);
      fpos:=0;    foundat:=-1;
      while not(EOF(IDF)) do
       begin

        read (IDF,ID);
        if trim(ID.TableName)='CREDITORS' then
           begin
            foundat:=fpos;
            idnum:=ID.counter ;
           end;
        inc(fpos);
       end;
       if foundat=-1 then
       begin
       closefile(IDF);
   assignfile(IDF,'Ids.dat');
   append(IDF);

  ID.TableName :='CREDITORS';
  ID.counter :=2;
   write (IDF,ID);
   closefile(IDF);
   idnum:=1;
       end else
       begin
       seek(IDF,foundat );
       ID.counter:=id.counter+1;
       write(IDF,ID);
       closefile(IDF);

     end;  end;
 nc.Creditorid :=idnum;
 write (CF,nc);
 Reset(CF);
 result:=idnum;
{Unlock here}
close;
end;

function TCreditorTable.DeleteCreditor (Creditor:TCreditorRecord):Tdberror;
var CR:TCreditorRecord;
begin
 {Lock}
  CR:=Creditor;
//  Rewrite(CF);
  Seek(CF,FindRecOffset(Creditor.Creditorid));
//Seek(CF,filepos(CF)-FindRecOffset(Creditor.Creditorid),1);
  CR.Creditorid:=0;
  Write (CF,CR); 
  {Write Transaction here}
  Reset(CF);
 {Unlock}
end;

function TCreditorTable.UpdateCreditor (oldCreditor,newCreditor:TCreditorRecord):Tdberror;
var oldindex:longint; CR:TCreditorRecord;
begin
  oldindex:=FindRecOffset(oldCreditor.Creditorid);
{Lock}
//  Rewrite(CF);
  Seek(CF,Oldindex);
//Seek(CF,filepos(CF)-Oldindex,1);
{add transaction for old rec}
  CR:=newCreditor;
  CR.Creditorid:=oldCreditor.Creditorid;
  Write(CF,CR);
{add transaction for new rec}
  Reset(CF);
{Unlock}
end;

function TCreditorTable.FetchCreditor(index:longint):TCreditorRecord;
var offs:longint;     nc:TCreditorrecord;
begin
reopen;
offs:=FindRecOffset(index);
if offs>-1 then
begin
 Reset(CF);
 Seek(CF,offs);
 //Seek(CF,filepos(CF)-offs,1);
 read (CF,nc);
 reset(CF);
 end;
 result:=nc;
 close;
end;



function TCreditorTable.RelationisTrue (Rec:TCreditorRecord;wherefield,relationship,value:String):Boolean;
var c:TRelationshipType; wf:String;
begin
 c:=strtorelationshiptype(relationship);
 wf:=UPPERCASE(wherefield);

 if wf='CREDITORID' then result:= VariantCompare (Rec.Creditorid,Value ,c);
 if wf='NAME' then result:= VariantCompare (Rec.Name,Value ,c);
 if wf='PHONE' then result:= VariantCompare (Rec.Phone,Value ,c);
 if wf='EXT' then result:= VariantCompare (Rec.Ext,Value ,c);
 if wf='ADDR1' then result:= VariantCompare (Rec.Addr1,Value ,c);
 if wf='ADDR2' then result:= VariantCompare (Rec.Addr2,Value ,c);
 if wf='CITY' then result:= VariantCompare (Rec.City,Value ,c);
 if wf='STATE' then result:= VariantCompare (Rec.State,Value ,c);
 if wf='ZIP' then result:= VariantCompare (Rec.ZIP,Value ,c);
 if wf='STARTINGBALANCE' then result:= VariantCompare (Rec.StartingBalance,Value ,c);
  
end;

function TCreditorTable.GetCreditors (Wherefield,relationship,Value:String;FilterList:TList):TList;
var CR:TCreditorRecord;curs:longint;
begin
reopen;
 result:=tlist.create;
 reset(CF);
 if ((assigned(FilterList))) then
   for curs:= 0 to FilterList.count-1  do
   begin
    CR:= FetchCreditor(Longint(FilterList[curs]));
    if RelationisTrue (CR,wherefield,relationship,value) then result.add (POINTER(CR.Creditorid));
   end
 else
 if filesize(CF)>0 then
  While not(EOF(CF)) do
    begin
      read(CF,CR);
	if RelationisTrue (CR,wherefield,relationship,value) then result.add (POINTER(CR.Creditorid));
    end    ;
close;
end;

function TCreditorTable.CreditorExists(index:longint):boolean;
begin
  if FindRecOffset(index)<>0 then result:=true else result:=false;
end;







{So.. 
SELECT * FROM CreditorS WHERE Creditors.DUEDATE>Now() AND Creditors.DUEDATE<StartMonth(October,1999)
1) Need to have a built-in function evaluation method for the date functions above
2) This CReaks down into a select for <october 1 and >Now filtered off that list.
3) The field request (*), will be ignored for now, since it is an object being returned,
but could be easily implimented in a fields type declaration.
}

constructor TCreditorTable.create;
var blank:TCreditorRecord;
begin


end;

destructor TCreditorTable.destroy;
begin
 try
 {}
 finally
     inherited destroy;
 end;
end;
procedure TCreditorTable.close;
begin
   closefile(CF);
end;

procedure TCreditorTable.reopen;
begin
   assignfile( CF,'Creditors.dat');
   if  fileexists('Creditors.dat') then
      reset(CF)
    else
     begin
      rewrite(CF);
//rewrite(CF);
  //    blank.creditorid:=0;
 //    write (CF,blank);
   closefile(CF);
 //  assignfile( CF,'Creditors.dat');
    reset(CF);
    end;
end;

end.







