unit Mainu1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Grids, StdCtrls, Mask, ADODB_TLB;

type
  TMainform = class(TForm)
    BillGrid: TStringGrid;
    Panel1: TPanel;
    btnAddBill: TButton;
    btnCreditors: TButton;
    btnQuit: TButton;
    Splitter1: TSplitter;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Bevel1: TBevel;
    txtsentpayment: TMaskEdit;
    btnPay: TButton;
    Label7: TLabel;
    txtCheck: TEdit;
    Label8: TLabel;
    txtAmount: TEdit;
    lblCreditor: TLabel;
    lblReceived: TLabel;
    lblDue: TLabel;
    lblamount: TLabel;
    lblbalance: TLabel;
    procedure Splitter1Moved(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnAddBillClick(Sender: TObject);
    procedure btnCreditorsClick(Sender: TObject);
    procedure btnQuitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BillGridClick(Sender: TObject);
    procedure BillGridMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btnPayClick(Sender: TObject);
  private
    { Private declarations }
      fclosing,fclicking:boolean;
         mx,my,fselectedid:integer;
  public
    property Closing:boolean read fclosing write fclosing;
    procedure PopulateList; 
    { Public declarations }
  end;

var
  Mainform: TMainform;

implementation

uses billsadd, crededit;

{$R *.DFM}

procedure TMainform.Splitter1Moved(Sender: TObject);
begin
Billgrid.ColWidths[1]:=Billgrid.width-Billgrid.colwidths[0]-5
end;

procedure TMainform.FormShow(Sender: TObject);
begin
Billgrid.DefaultRowHeight := 20;
Billgrid.ColWidths[1]:=Billgrid.width-Billgrid.colwidths[0]-5;
Billgrid.rows[0].Strings[0]:='ID:';
Billgrid.ColWidths[0]:=30;
Billgrid.rows[0].Strings[1]:='Date:';
Billgrid.ColWidths[1]:=80;
Billgrid.rows[0].Strings[2]:='Bill:';
Billgrid.ColWidths[2]:=100;
Billgrid.rows[0].Strings[3]:='Amount:';
Billgrid.ColWidths[3]:=100;
PopulateList;
end;



procedure TMainform.btnAddBillClick(Sender: TObject);
begin
try
Billsform.Show  ;
finally
populatelist;
end;
end;

procedure TMainform.btnCreditorsClick(Sender: TObject);
begin
CreditorsForm.visible:=true;
end;

procedure TMainform.btnQuitClick(Sender: TObject);
begin
self.Close;
end;

procedure TMainform.FormCreate(Sender: TObject);
begin
fclosing:=false;
fclicking:=false;
end;
function Ensurecurrency (v:variant):String;
var num:double;s:String;i:integer;
begin
    if ((vartype(v)=varNull) or (vartype(v)=varEmpty)) then
     s:='0'
    else
     s:=vartostr(v);
     num:=strtofloat(s);
     result:= '$' + formatfloat('######.00',num);
end;

procedure TMainform.PopulateList();
var Conn:Connection;RS:Recordset; ignore:OLEVARIANT; sql:String;
begin 
conn:=CoConnection.Create;
conn.Open ('DSN=OURBILLS;UID=SYSDBA;PWD=masterkey;','SYSDBA','masterkey',-1);

sql := 'SELECT BILLS.BILLID,BILLS.DUEDATE,BILLS.DUEAMOUNT,CREDITORS.NAME';
sql := sql + ' FROM BILLS LEFT JOIN CREDITORS ON BILLS.CREDITORID';
sql := sql + '= CREDITORS.CREDITORID WHERE PAID=0';
rs:=conn.execute (sql,ignore,-1 );
BillGrid.Rowcount:=1;
billgrid.refresh;
while not (rs.eof) do
begin
  Billgrid.rowcount:=billgrid.rowcount+1;
  billgrid.cells[0,billgrid.rowcount-1]:=rs.fields['BILLID'].value;
  billgrid.cells[1,billgrid.rowcount-1]:=rs.fields['DUEDATE'].value;
    billgrid.cells[2,billgrid.rowcount-1]:=rs.fields['NAME'].value;
     billgrid.cells[3,billgrid.rowcount-1]:=ensurecurrency(rs.fields['dueAmount'].value);
  rs.movenext;
end;

  fclicking:=false;

end;
  function Ensure (v:variant):String;
begin
    if ((vartype(v)=varNull) or (vartype(v)=varEmpty)) then
     result:=''
    else
     result:=vartostr(v);
end;
procedure TMainform.BillGridClick(Sender: TObject);
var  c,r,selectedid : integer;
 Conn:Connection;RS:Recordset; ignore:OLEVARIANT; sql:String;
begin 

fclicking:=true;

billgrid.MouseToCell(mx,my,c,r) ;
if r>0 then
begin
  fselectedid:=strtoint(billgrid.cells[0,r]);
 conn:=CoConnection.Create;
conn.Open ('DSN=OURBILLS;UID=SYSDBA;PWD=masterkey;','SYSDBA','masterkey',-1);

sql := 'SELECT * FROM BILLS WHERE BILLID='+billgrid.cells[0,r] ;
rs:=conn.execute (sql,ignore,-1 );
self.lblCreditor.caption := billgrid.cells[2,r];
self.lblReceived.caption  := ensure(rs.fields['RECEIVEDATE'].value);
self.lblDue.caption  := ensure(rs.fields['DUEDATE'].value);
self.lblamount.caption  := ensure(rs.fields['DUEAMOUNT'].value);
self.lblbalance.caption  := ensure(rs.fields['BALANCEDUE'].value);
btnpay.Visible :=true;
end;
fclicking:=false;
end;

 


procedure TMainform.BillGridMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);

begin
mx:=x;my:=y;
end;

procedure TMainform.btnPayClick(Sender: TObject);
var Conn:Connection;RS:Recordset; ignore:OLEVARIANT; sql:String;
begin
conn:=CoConnection.Create;
conn.Open ('DSN=OURBILLS;UID=SYSDBA;PWD=masterkey;','SYSDBA','masterkey',-1);

sql := 'UPDATE BILLS SET SENTDATE='''+txtsentpayment.text+''',';
sql := sql + 'SENTAMOUNT='''+txtAmount.text+''',CHECKNUMBER='''+txtcheck.text+''',PAID=1';
sql := sql+ ' WHERE BILLID='+inttostr(fselectedid);
 
conn.begintrans;
rs:=conn.Execute(sql,ignore,-1);
conn.committrans;
txtsentpayment.text:='';
txtcheck.text:='';
txtamount.text:='';
self.lblCreditor.caption := '';
self.lblReceived.caption  :='';
self.lblDue.caption  := '';
self.lblamount.caption  := '';
self.lblbalance.caption  := '';
rs:=nil;
conn.close;
conn:=nil;
btnPay.visible:=false;
populatelist;

end;

end.
