unit ouexp1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,registry,filectrl, ExtCtrls, ComCtrls, Menus, myff,toolintf,editintf,exptintf,
  Buttons;

type
  TMStExpt01 = class(TForm)
    Panel2: TPanel;
    ListView1: TListView;
    ImageList1: TImageList;
    PopupMenu1: TPopupMenu;
    Add1: TMenuItem;
    Recurseall1: TMenuItem;
    Unrecurseall1: TMenuItem;
    N1: TMenuItem;
    SelectAll1: TMenuItem;
    Panel1: TPanel;
    Label1: TLabel;
    Edit1: TComboBox;
    loadbtn: TButton;
    MyFF1: TMyFF;
    CheckBox1: TCheckBox;
    Deleteselected1: TMenuItem;
    Button1: TButton;
    SpeedButton1: TSpeedButton;
    Bevel1: TBevel;
    Panel3: TPanel;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Recurseall1Click(Sender: TObject);
    procedure Unrecurseall1Click(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure ListView1Edited(Sender: TObject; Item: TListItem;
      var S: string);
    procedure Add1Click(Sender: TObject);
    procedure ListView1ColumnClick(Sender: TObject; Column: TListColumn);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure MyFF1AddFile(path: string; data: TWin32FindDataA;
      var cancel: Boolean);
    procedure loadbtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Deleteselected1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure MyFF1ChDir(name: string; var cancel: Boolean);
    procedure ListView1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ListView1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ListView1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListView1DblClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure getpathes;
    procedure load(a:string);

  end;

    TOpenFileExpert = class(TIExpert)
  private
  public
    function GetName: string; override;
    function GetStyle: TExpertStyle; override;
    function GetIDString: string; override;
    function getstate:texpertstate;override;
    function getmenutext:string;override;
    procedure execute ; override;
  end;


procedure register;

var
  MStExpt01: TMStExpt01;
  myreg : tregistry;
  flist : tstringlist;

const delpat  = '\Software\Borland\Delphi\2.0\Library';
      myrkey  = delpat+'\openunit';
      myskey  = myrkey+'\settings';
      myhkey  = myskey+'\history';
      my0key  = 'openunit';



implementation

uses ouexp2, ouexp3;

{$R *.DFM}

procedure register;
begin
     registerlibraryexpert(topenfileexpert.create);
end;

function topenfileexpert.GetName: string;
begin
     result := 'MStOpenFileExpert';
end;

function topenfileexpert.GetStyle: TExpertStyle;
begin
     result := esStandard;
end;

function topenfileexpert.getidstring;
begin
     result := 'Markus Stephany.OpenFileExpert';
end;

function topenfileexpert.getstate;
begin
     result := [esenabled];
end;

function topenfileexpert.getmenutext:string;
begin
     result := 'Merkes says : Open a file !';
end;

procedure topenfileexpert.execute ;
begin
     if not assigned(mstexpt01) then mstexpt01:=tmstexpt01.create(application);
     mstexpt01.show;
     mstexpt01.setfocus;
end;




procedure tMStExpt01.load(a:string);
// loads the specified file in the delphi-ide
var ct : integer;
begin
     // examine whether a teditwindow is opened
     if findwindow('teditwindow',nil) = 0 then begin
        // create a new module
        toolservices.createmodule(a,nil,nil,[cmexisting,cmshowsource]);
        //ct := findwindow('teditwindow',nil);
        //if ct = 0 then showmessage('g');
        //exit;
     end;
     with toolservices do
     if toolservices <> nil then if not isfileopen(a) then openfile(a)
end;

procedure tMStExpt01.getpathes;
var sr : string;
    ct : integer;
begin
     with myreg do begin
       openkey(delpat,false);
       if not keyexists(my0key) then begin
        // load delphi's-searchpath into listview
        checkbox1.checked := false;
        sr := readstring('searchpath');
        if sr <> '' then begin
           repeat
                 ct := pos(';',sr);
                 if ct > 0 then with listview1.items.add do begin
                    caption := copy(sr,1,ct-1);
                    stateindex := -1;
                    imageindex := 0;
                    sr := copy(sr,ct+1,maxint);
                 end;
           until pos(';',sr) = 0;
           if sr <> '' then with listview1.items.add do begin
              caption := sr;
              stateindex := -1;
              imageindex := 0;
          end;
        end;
       end else begin
         openkey(myrkey,false);
         getvaluenames(flist);
         if flist.count > 0 then for ct := 0 to pred(flist.count) do
            with listview1.items.add do begin
                 caption := copy(readstring(flist[ct]),3,maxint);
                 imageindex := 0;
                 stateindex := strtointdef(copy(readstring(flist[ct]),1,2),-1);
            end;
         flist.clear;
         openkey(myskey,false);
         if valueexists('ch') then checkbox1.checked := readbool('ch');
         // load the history
         openkey(myhkey,false);
         getvaluenames(flist);
         if flist.count > 0 then for ct := 0 to pred(flist.count) do
            edit1.items.add(readstring(flist[ct]));
         flist.clear;
       end;
     end;
end;
procedure TMStExpt01.FormCreate(Sender: TObject);
// get the root-path of delphi or load a path from the registry
begin
     if toolservices = nil then begin
        showmessage('This tool must be installed as an expert in the Delphi-IDE (via component-install)');
        application.terminate;
        exit;
     end;
     myreg := tregistry.create;
     myreg.rootkey := hkey_current_user;
     flist := tstringlist.create;
     getpathes;
     flist.sorted := true;
     flist.duplicates := dupignore;
end;

procedure TMStExpt01.FormDestroy(Sender: TObject);
begin
     myreg.free;
     flist.free;
end;

procedure TMStExpt01.PopupMenu1Popup(Sender: TObject);
begin
     with listview1 do begin
          selectall1.enabled := items.count > 0;
          recurseall1.enabled := selcount > 0;
          unrecurseall1.enabled := selcount > 0;
          deleteselected1.enabled := selcount > 0;
     end;
end;

procedure TMStExpt01.Recurseall1Click(Sender: TObject);
var ct : integer;
begin
     with listview1, listview1.items do if count <> 0 then for ct := 0 to pred(count) do
          if items[ct].selected then items[ct].stateindex := 1;
end;

procedure TMStExpt01.Unrecurseall1Click(Sender: TObject);
var ct : integer;
begin
     with listview1, listview1.items do if count <> 0 then for ct := 0 to pred(count) do
          if items[ct].selected then items[ct].stateindex := -1;
end;

procedure TMStExpt01.SelectAll1Click(Sender: TObject);
var ct : integer;
begin
     with listview1, listview1.items do if count <> 0 then for ct := 0 to pred(count) do
          items[ct].selected := true;

end;

procedure TMStExpt01.ListView1Edited(Sender: TObject; Item: TListItem;
  var S: string);
var it : tlistitem;
begin
     with listview1 do begin
          it := findcaption(0,s,false,true,true);
          if (it <> nil) and (it <> item) then begin
             showmessage('This path is already in the table.');
             s:=item.caption;
          end;
      end;
end;

procedure TMStExpt01.Add1Click(Sender: TObject);
var s : string;
    it : tlistitem;
begin
     s := '';
     if selectdirectory(s,[],0) then
     with listview1 do begin
          it := findcaption(0,s,false,true,true);
          if (it <> nil) then showmessage('This path is already in the table.')
          else with items.add do begin
              caption := s;
              stateindex := -1;
              imageindex := 0;
          end;
      end;

end;

procedure TMStExpt01.ListView1ColumnClick(Sender: TObject;
  Column: TListColumn);
begin
     listview1.alphasort;
end;

procedure TMStExpt01.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
     if key = #13 then loadbtn.click;
end;

procedure TMStExpt01.MyFF1AddFile(path: string; data: TWin32FindDataA;
  var cancel: Boolean);
begin
     cancel := not checkbox1.checked;
     flist.add(path+data.cfilename);
     form2.additem(path,data);
end;

procedure TMStExpt01.loadbtnClick(Sender: TObject);
var ct : integer;
    sr : string;
    fg : boolean;
begin
  with edit1 do begin
       if text = '' then exit;
       fg := true;
       if items.count > 0 then
       for ct := 0 to pred(items.count) do begin
           if lstrcmpi(pchar(items[ct]),pchar(text)) = 0 then fg := false;
       end;
       if fg then items.insert(0,text);
  end;
  with edit1.items do if count = 0 then
     add(edit1.text);
  with listview1,myff1 do begin
     if selcount = 0 then selectall1.click;
     if selcount = 0 then begin
        showmessage('No directories selected.');
        exit;
     end;
     if not assigned(form2) then form2 := tform2.create(application);
     // set myff
     if extractfileext(edit1.text) = '' then filemask := edit1.text+'*.pas;'+edit1.text+'*.dpr'
        else filemask := edit1.text;
     attributes := faanyfile-fadirectory-favolumeid;
     findstring := '';
     flist.clear;
     form2.listbox1.items.clear;
     form2.listbox1.items.beginupdate;
     form2.listbox1.allocby := 400;
     screen.cursor := crhourglass;
     for ct := 0 to pred(items.count) do begin
         with items[ct] do
              if selected then begin
                 recursedirs := stateindex <> -1;
                 find(caption);
              end;
         if (not checkbox1.checked) and (flist.count > 0) then break;
     end;
     caption := 'Unit-Loader V1.0 by M. Stephany';
     form2.listbox1.items.endupdate;
     form2.listbox1.allocby := 0;
     screen.cursor := crdefault;
     if flist.count = 0 then showmessage('No matches found.')
     else begin
          sr := flist[0];
          if flist.count > 1 then begin
             if checkbox1.checked then with form2,form2.listbox1 do begin
                if showmodal = idcancel then exit;
                for ct := 0 to pred(items.count) do
                    if items[ct].selected then load(items[ct].subitems[0]+items[ct].caption);
             end;
          end else load(sr);
          close;
     end;
  end;
end;

function getcurtext(y,x:integer;src:tieditorinterface):string;

const    bufsiz = 32767;
var reader : tieditreader;
    buf : packed array [0..bufsiz-1] of char;
    sl : tstrings;
    ct,gc : longint;
    sr : string;


const allchar = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789';

      function isinchar(a:char):boolean;
      begin
           result := pos(a,allchar) > 0;
      end;

begin
     dec(y,1);
     screen.cursor := crhourglass;
     result := '';
     try
        reader := src.createreader;
        sl := tstringlist.create;
        ct := 0;
        repeat
              gc:=reader.gettext(ct,@buf[0],bufsiz);
              sr:=sr+copy(buf,0,gc);
              inc(ct,bufsiz);
              sl.text := sr;
        until (gc <> bufsiz) or (sl.count > y);
        if y < sl.count then begin
           sr:=sl[y];
           if x <= length(sr) then begin
              sr:=' '+sr+' ';
              ct := x;
              gc := x;
              if isinchar(sr[gc]) then begin
                 while isinchar(sr[gc]) do dec(gc);
                 while isinchar(sr[ct]) do inc(ct);
                 delete(sr,ct,maxint);
                 delete(sr,1,gc);
                 result:=sr;
              end;
           end;
        end;
     finally
            sl.free;
            reader.free;
            screen.cursor := crdefault;
     end;
end;

procedure TMStExpt01.FormActivate(Sender: TObject);
var myint : timoduleinterface;
    myedit : tieditorinterface;
    myview : tieditview;
    mypos : teditpos;
    sr : string;
begin
   // erhalten des editorfensters
   edit1.text := '';
   if toolservices <> nil then begin
     sr := extractfileext(ansilowercase(toolservices.getcurrentfile));
     with toolservices do if (sr = '.pas') or (sr = '.dpr') then try
       // get the current file
       myint := getmoduleinterface(getcurrentfile);
       if myint <> nil then begin
         myedit := myint.geteditorinterface;
           if (myedit <> nil) and (myedit.getviewcount > 0) then begin
              myview := myedit.getview(0);
              if myview <> nil then begin
                 mypos := myview.cursorpos;
                 // now we have the cursorpos
                 // let us now get the token under the cursor
                 edit1.text := getcurtext(mypos.line,mypos.col,myedit);
              end;
           end;
         end;
     finally
            myint.release;
            myview.release;
     end;
   end;
   edit1.setfocus;
end;


procedure TMStExpt01.FormClose(Sender: TObject; var Action: TCloseAction);
var sr : string;
    ct : integer;
begin
     with myreg,listview1 do begin
         deletekey(myrkey);
         openkey(myrkey,true);
         if items.count > 0 then for ct := 0 to pred(items.count) do
            with items[ct] do begin
                 sr := inttostr(stateindex);
                 while length(sr) < 2 do sr := '0'+sr;
                 sr := copy(sr,1,2)+caption;
                 writestring(inttostr(ct),sr);
            end;
         openkey(myskey,true);
         writebool('ch',checkbox1.checked);
         deletekey(myhkey);
         openkey(myhkey,true);
         with edit1,edit1.items do if count > 0 then begin
              ct := pred(count);
              if ct > 10 then ct := 10;
              for ct := 0 to ct do
                  writestring(inttostr(ct),items[ct]);
         end;
     end;
     action := cafree;
     mstexpt01 := nil;
end;

procedure TMStExpt01.Deleteselected1Click(Sender: TObject);
var ct : integer;
begin
     with listview1.items,listview1 do begin
       beginupdate;
       for ct := items.count-1 downto 0 do
          if items[ct].selected then items.delete(ct);
       endupdate;
     end;
end;

procedure TMStExpt01.Button1Click(Sender: TObject);
begin
     close;
end;

procedure TMStExpt01.SpeedButton1Click(Sender: TObject);
begin
     if not assigned(form3) then form3 := tform3.create(application);
     form3.showmodal;

end;

procedure TMStExpt01.MyFF1ChDir(name: string; var cancel: Boolean);
begin
     caption := '<ESC> to cancel. Scan : '+name;
     cancel := (getasynckeystate(vk_escape) and not 1) <> 0;
end;

procedure TMStExpt01.ListView1DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
     accept := sender = source;
end;

procedure TMStExpt01.ListView1DragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
     with listview1 do begin
          if itemfocused = nil then exit;
          if droptarget = nil then exit;
          items.insert(droptarget.index).assign(itemfocused);
          items.delete(itemfocused.index);
          itemfocused := items[droptarget.index-1];
     end;
end;

procedure TMStExpt01.ListView1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     with listview1 do if itemfocused <> nil then case key of
          vk_delete : items.delete(itemfocused.index);
          vk_f2     : itemfocused.editcaption;
     end;
end;

procedure TMStExpt01.ListView1DblClick(Sender: TObject);
var s : string;
    it : tlistitem;
begin
     with listview1 do if itemfocused <> nil then with itemfocused do begin
          s := caption;
          if selectdirectory(s,[],0) then begin
             it := findcaption(0,s,false,true,true);
             if (it <> nil) and (it.index <> itemfocused.index) then showmessage('This path is already in the table.')
             else caption := s;
          end;
     end;
end;

end.
