{
   WARNING! THIS CODE IS PROVIDED AS IS WITH NO GUARANTEES OF ANY KIND!
   USE THIS AT YOUR OWN RISK - YOU ARE THE ONLY PERSON RESPONSIBLE FOR
   ANY DAMAGE THIS CODE MAY CAUSE - YOU HAVE BEEN WARNED!

   OLE Drop example for Delphi 2.0
   Special thanks to Klaus Mueller and Andreas Klapperich

   (c) 06/1996 by Guido Schoepp
   email: gus@abo.rhein-zeitung.de
          gschoepp@compuserve.com

   This Unit implements the TIDropTarget interface.
}
unit dragdrop;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    procedure OnFileDropped(const value:String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
uses ole2, ShellAPI;

type
  { Don't use IDropTarget from SHELLAPI.PAS - the pt:TPoint parameter may not
    be declared const }
  TIDropTarget = class(IUnknown)
  public
    function DragEnter(dataObj: IDataObject; grfKeyState: Longint;
      pt: TPoint; var dwEffect: Longint): HResult; virtual; stdcall; abstract;
    function DragOver(grfKeyState: Longint; pt: TPoint;
      var dwEffect: Longint): HResult; virtual; stdcall; abstract;
    function DragLeave: HResult; virtual; stdcall; abstract;
    function Drop(dataObj: IDataObject; grfKeyState: Longint; pt: TPoint;
      var dwEffect: Longint): HResult; virtual; stdcall; abstract;
  end;

	TMyDragDropEvent = procedure (const value:String) of object;
	TMyDragDrop = class(TIDropTarget)
   private
   	refCount : Longint;
      fFileDropped : TMyDragDropEvent;
	public
   	constructor Create;
      destructor Destroy; override;

   	function QueryInterface(const iid: TIID; var obj): HResult; override;
   	function AddRef: Longint; override;
   	function Release: Longint; override;

    	function DragEnter(dataObj: IDataObject; grfKeyState: Longint;
      	pt: TPoint; var dwEffect: Longint): HResult; override;
    	function DragOver(grfKeyState: Longint; pt: TPoint;
      	var dwEffect: Longint): HResult; override;
    	function DragLeave: HResult; override;
    	function Drop(dataObj: IDataObject; grfKeyState: Longint; pt: TPoint;
      	var dwEffect: Longint): HResult; override;

      property OnFileDropped:TMyDragDropEvent read fFileDropped write fFileDropped;
   end;

constructor TMyDragDrop.Create;
begin
	{inherited Create;}
	refcount := 1;
   fFileDropped := NIL;
end;

destructor TMyDragDrop.Destroy;
begin
	inherited Destroy;
end;

function TMyDragDrop.QueryInterface(const iid: TIID; var obj): HResult;
begin
	if IsEqualIID(iid, IID_IDROPTARGET) or
   	IsEqualIID(iid, IID_IUNKNOWN) then
   begin
   	Pointer(obj) := self;
      AddRef;
      result := S_OK;
   end else
   begin
   	Pointer(obj) := NIL;
   	result := E_NOINTERFACE;
   end;
end;

function TMyDragDrop.AddRef: Longint;
begin
	inc(refCount);
   result := refCount;
end;

function TMyDragDrop.Release: Longint;
begin
	dec(refCount);
   result := refCount;
   if refCount=0 then
   	Free;
end;

function TMyDragDrop.DragEnter(dataObj: IDataObject; grfKeyState: Longint;
		pt: TPoint; var dwEffect: Longint): HResult;
begin
	MessageBeep(0);
   dataObj.AddRef;
	dwEffect := DROPEFFECT_COPY;
   result := S_OK;
end;

function TMyDragDrop.DragOver(grfKeyState: Longint; pt: TPoint;
   var dwEffect: Longint): HResult;
begin
	MessageBeep(0);
	dwEffect := DROPEFFECT_COPY;
   result := S_OK;
end;

function TMyDragDrop.DragLeave: HResult;
begin
   result := S_OK;
end;

function TMyDragDrop.Drop(dataObj: IDataObject; grfKeyState: Longint; pt: TPoint;
   var dwEffect: Longint): HResult;
var
	etc : TFormatETC;
   med : TSTGMedium;
   res : Integer;
   fileDropped : array [0..MAX_PATH] of char;
   count,i : Word;
begin
	etc.cfFormat := CF_HDROP;
   etc.ptd := NIL;
   etc.dwAspect := DVASPECT_CONTENT;
   etc.lindex := -1;
   etc.tymed := TYMED_HGLOBAL;

	res := dataObj.GetData(etc, med);
   if (res=S_OK) then
   begin
   	count := DragQueryFile(HDROP(med.hGlobal), $FFFFFFFF, NIL, 0);
      for i:=0 to count-1 do
      begin
	   	DragQueryFile(HDROP(med.hGlobal), i, fileDropped, sizeof(fileDropped));
	      if Assigned(fFileDropped) then
   	   	fFileDropped(fileDropped);
      end;
		if (med.UnkForRelease<>NIL) then
      	med.UnkForRelease.Release
      else
      	GlobalFree(med.hGlobal);
   end;

	dwEffect := DROPEFFECT_COPY;
   result := S_OK;
end;

{----------------------------------------------------------------------------}

procedure TForm1.FormCreate(Sender: TObject);
var
	dd : TMyDragDrop;
   res : HRESULT;
   res1 : Integer;
begin
   dd := TMyDragDrop.Create;
   dd.OnFileDropped := self.OnFileDropped;
   res1 := CoLockObjectExternal(dd, true, false);
   res := RegisterDragDrop(Handle, IDropTarget(dd));
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
	RevokeDragDrop(Handle);
end;

procedure TForm1.OnFileDropped(const value:String);
begin
	ListBox1.Items.Add(value);
end;

end.
