// Component for WinWord8 (Office 97)
// with Data (Name, Adress,...) from your Delphi-Application
// (c)1998 R. Vysata,CreativeSoftwareTechnik

unit WinWord;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Comobj, Filectrl;

type
  TAlign = (Aleft, ACenter, ARight);
  
type
  TWinWord = class(TComponent)
  private
    myword: variant;
    wkopf, wfuss, wref: string;
    wtext: string;
    wneu: boolean;
    wbegin: integer;
    wanrede, wname: string;
    wart: string;
    wstrasse, wort: string;
    wland: string;
    lalign: TAlign;
    varonly: boolean;
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
  public
    constructor Create(AOwner:TComponent); override;
    procedure startdocument;
    procedure startword;
    procedure addaddress;
    procedure addreferenz;
    procedure addlines(line: integer);
    procedure addtext;
    { Public-Deklarationen }
  published
    property headline :string read wkopf write wkopf;
    property footline :string read wfuss write wfuss;
    property refline :string read wref write wref;
    property wordtext :string read wtext write wtext;
    property first :integer read wbegin write wbegin;
    property ltitle :string read wanrede write wanrede;
    property lname :string read wname write wname;
    property lsign :string read wart write wart;
    property wordnew :boolean read wneu write wneu;
    property lstreet :string read wstrasse write wstrasse;
    property lcity :string read wort write wort;
    property lstate :string read wland write wland;
    property align: TAlign read lalign write lalign;
    property onlyvar: boolean read varonly write varonly;
    { Published-Deklarationen }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Office', [TWinWord]);
end;

constructor TWinword.Create(AOwner:TComponent);
begin
     inherited create(aowner);
     wbegin := 5;
     myword := 0;
     wneu := false;
     varonly := false;
end;
procedure TWinWord.startdocument;
var c: integer;
begin
     try
     myword.documents.add;
     myword.ActiveWindow.ActivePane.View.Type := 3;
     if wkopf <> '' then begin
        myword.ActiveWindow.ActivePane.View.SeekView := 9;
        if fileexists(wkopf) then
        myword.Selection.Insertfile(wkopf) else
        myword.selection.TypeText(wkopf);
        end;
     if wfuss <> '' then begin
        myword.ActiveWindow.ActivePane.View.SeekView := 10;
        if fileexists(wfuss) then
        myword.Selection.Insertfile(wfuss) else
        myword.selection.TypeText(wfuss);
        end;
     myword.ActiveWindow.ActivePane.View.SeekView := 0;
     if wbegin > 0 then
        for c := 1 to wbegin do
        myword.selection.TypeParagraph;
     myword.ActiveDocument.variables.add('Name', wname);
     myword.ActiveDocument.variables.add('Anrede', wanrede);
     myword.ActiveDocument.variables.add('Strasse', wstrasse);
     myword.ActiveDocument.variables.add('Ort', wort);
     myword.ActiveDocument.variables.add('Land', wland);
     myword.ActiveDocument.variables.add('Art', wart);
     myword.ActiveDocument.fields.update;
     except
     end;
end;

procedure TWinWord.startword;
begin
     showmessage('TWinword 1.1, (c)1998 R. Vysata, CreativeSoftwareTechnik');
     if wneu = false then
     try
        myword := GetActiveOleObject('Word.Application');
        except
        try
           myword := CreateOleObject('Word.Application');
           except
           exit;
           end;
        // word mit jedem Brief neu starten
        end else
        try
           myword := CreateOleObject('Word.Application');
           except
           exit;
           end;
        myword.visible := true;
end;

procedure TWinWord.addaddress;
begin
     case lalign of
     ALeft: myword.selection.ParagraphFormat.Alignment := 0;
     ACenter: myword.selection.ParagraphFormat.Alignment := 1;
     ARight: myword.selection.ParagraphFormat.Alignment := 2;
     end;
     if varonly = false then begin
     if wanrede <> '' then begin
     myword.Selection.Typetext(wanrede);
     myword.selection.TypeParagraph;
     end;
     if wname <> '' then begin
     myword.Selection.Typetext(wname);
     myword.selection.TypeParagraph;
     myword.selection.TypeParagraph;
     end;
     if wstrasse <> '' then begin
     myword.Selection.Typetext(wstrasse);
     myword.selection.TypeParagraph;
     end;
     if wort <> '' then begin
     myword.Selection.Typetext(wort);
     myword.selection.TypeParagraph;
     end;
     if wland <> '' then begin
     myword.Selection.Typetext(wland);
     myword.selection.TypeParagraph;
     end;
     end; //varonly
end;

procedure TWinWord.addreferenz;
var c: integer;
begin
     if wref <> '' then begin
        for c := 1 to 3 do
         myword.selection.TypeParagraph;
         if fileexists(wref) then
         myword.Selection.Insertfile(wref) else
         myword.selection.TypeText(wref);
         end;
end;

procedure TWinWord.addlines(line:integer);
var c: integer;
begin
     if line > 0 then
     for c := 1 to line do
        myword.selection.TypeParagraph;
end;

procedure TWinWord.addtext;
begin
     case lalign of
     ALeft: myword.selection.ParagraphFormat.Alignment := 0;
     ACenter: myword.selection.ParagraphFormat.Alignment := 1;
     ARight: myword.selection.ParagraphFormat.Alignment := 2;
     end;
     if wtext <> '' then begin
        myword.selection.TypeParagraph;
        myword.selection.TypeParagraph;
        if fileexists(wtext) then
        myword.selection.insertfile(wtext) else
        myword.selection.Typetext(wtext);
        end;
end;
end.
