unit Excel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComObj;

type
  TExcel = class(TComponent)
  private
         myexcel: variant;
         newexcel: Boolean;
         hor: Boolean;
         zeile: integer;
    { Private-Deklarationen }
  protected
    { Protected-Deklarationen }
  public
        data: TStringlist;
        constructor Create(AOwner: TComponent); override;
        destructor destroy; override;
        procedure startexcel;
        procedure startworkbook;
        procedure startdata;
        procedure Autofit;
        
    { Public-Deklarationen }
  published
           property ExcelNew : Boolean read newexcel write newexcel;
           property Horizontal : Boolean read hor write hor;
           property line: integer read zeile write zeile;
    { Published-Deklarationen }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CSTOffice', [TExcel]);
end;

constructor TExcel.Create(AOwner: TComponent);
begin
     inherited Create(aowner);
     myexcel := unassigned;
     newexcel := false;
     horizontal := true;
     zeile := 1;
     data := TStringlist.Create;
     data.clear;
end;

destructor TExcel.destroy;
begin
     data.free;
     inherited Destroy;
end;

procedure TExcel.startexcel;
begin
     showmessage('TExcel (c)1998 R. Vysata, CreativeSoftwareTechnik');
     if newexcel = false then
     try
        myexcel := GetActiveOleObject('Excel.Application');
        except
        try
        myexcel := CreateOleObject('Excel.Application');
        except
              exit;
              end;
     end else
     try
        myexcel := CreateOleObject('Excel.Application');
        except
              exit;
              end;
     myExcel.visible := true;

end;

procedure TExcel.startWorkbook;
begin
     myexcel.Workbooks.add;
end;

procedure TExcel.startdata;
var x, Cell: integer;
begin
     Cell := data.Count;
     for x := 1 to Cell do
     if horizontal = true then
     myExcel.Cells(zeile, x) := data.Strings[x - 1] else
     myExcel.Cells(x, zeile) := data.Strings[x -1];
     inc(zeile);
end;

procedure TExcel.Autofit;
begin
     myexcel.cells.select;
     myexcel.Selection.Columns.Autofit;
end;

end.
