unit DBExcel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComObj, DBTables, DB;

type
  TDBExcel = class(TComponent)
  private
         Exceltable: TTable;
         myexcel: variant;
         newexcel: Boolean;
         hor: Boolean;
         zeile: integer;
    { Private-Deklarationen }
  protected
        procedure Notification(AComponent: TComponent; Operation: Toperation); override;
    { Protected-Deklarationen }
  public
        data: TStringlist;
        constructor Create(AOwner: TComponent); override;
        destructor destroy; override;
        procedure startexcel;
        procedure startworkbook;
        procedure startdata;
        procedure Autofit;
        procedure AddString;
        
    { Public-Deklarationen }
  published
           property ExcelNew : Boolean read newexcel write newexcel;
           property Horizontal : Boolean read hor write hor;
           property line: integer read zeile write zeile;
           property tabletoexcel: TTable read exceltable write exceltable;
    { Published-Deklarationen }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CSTOffice', [TDBExcel]);
end;

constructor TDBExcel.Create(AOwner: TComponent);
begin
     inherited Create(aowner);
     myexcel := unassigned;
     newexcel := false;
     horizontal := true;
     zeile := 1;
     data := TStringlist.Create;
     data.clear;
end;

destructor TDBExcel.destroy;
begin
     if exceltable <> nil then
        exceltable := nil;
     inherited Destroy;
end;

procedure TDBExcel.Notification(AComponent: TComponent; Operation: Toperation);
begin
     inherited notification(acomponent, operation);
     //if (Operation  = opRemove) and
     //(exceltable <> nil) then
     //if exceltable <> nil then
     //   exceltable := nil;
end;

procedure TDBExcel.startexcel;
begin
     showmessage('TDBExcel (c)1998 R. Vysata, CreativeSoftwareTechnik');
     if newexcel = false then
     try
        myexcel := GetActiveOleObject('Excel.Application');
        except
        try
        myexcel := CreateOleObject('Excel.Application');
        except
              exit;
              end;
     end else
     try
        myexcel := CreateOleObject('Excel.Application');
        except
              exit;
              end;
     myExcel.visible := true;

end;

procedure TDBExcel.startWorkbook;
begin
     myexcel.Workbooks.add;
end;

procedure TDBExcel.startdata;
var  x, Cell: integer;
begin
     with exceltable do begin
          if not active then active := true;
          first;
          end;
     Cell := exceltable.FieldCount -1;
     while not exceltable.eof do begin
     for x := 0 to Cell do begin
     if horizontal = true then
     myExcel.Cells(zeile, x +1) := exceltable.Fields[x].Asstring else
     myExcel.Cells(x, zeile + 1) := exceltable.Fields[x].Asstring;
     end;
     inc(zeile);
     exceltable.next;
     end;
end;

procedure TDBExcel.Autofit;
begin
     myexcel.cells.select;
     myexcel.Selection.Columns.Autofit;
end;

procedure TDBExcel.AddString;
var x, Cell: integer;
begin
     Cell := data.Count;
     for x := 1 to Cell do
     if horizontal = true then
     myExcel.Cells(zeile, x) := data.Strings[x - 1] else
     myExcel.Cells(x, zeile) := data.Strings[x -1];
     inc(zeile);
     data.clear;
end;
end.
