#
# File
# 	modlist.tcl
# Description
# 	Object Domain script for listing all project modules in a single diagram
# Created
#	03/24/1997	Johan Nilsson, Autoliv Sverige AB
# Revisions

proc module_order { mod1 mod2 } {
	return [string compare [$mod1 get name] [$mod2 get name]]
}

# main

	# loop through all diagrams
	set modlist [list]
	foreach diag [OD_getDiagrams] {

		# ignore all but module diagrams
		if {[$diag get type] != "module"} {
			continue
		}

		# loop through all diagram objects
        foreach obj [$diag get objects] {
			# ignore other than module objects
            if {[$obj get objectType] != "module"} {
				continue
			}

			# ignore other than body modules
			if {[$obj get moduleType] != "body"} {
				continue
			}

			# ignore empty modules
			if {[llength [$obj get classes]] == 0} {
				continue
			}

			# add module to list
			set modlist [linsert $modlist end $obj]
		}
	}

	# return if no modules were found
	if {[llength $modlist] == 0} {
		return
    }

	# sort modules by name
	set modlist [lsort -command module_order $modlist]

	# create new module diagram
	set newdiag [OD_createDiagram "module" "All modules"]

	# set coordinates
	set width 120
	set height 120
	set maxwidth [expr 5 * $width]
	set x [expr $width / 2]
    set y [expr $height / 2]

	# loop through all modules
	foreach mod $modlist {

		# create specification module in new diagram
		set newmod [$newdiag add object "module"]
		$newmod set moduleType "specification"
		$newmod set origin $x $y
		set x [expr $x + $width]
		if {$x > $maxwidth} {
			set x [expr $width / 2]
			set y [expr $y + $height]
		}
		$newmod set name [$mod get name]

		# add classes to specification module
		foreach cl [$mod get classes] {
			$newmod add class $cl
        }
    }




