#
# File
# 	InhBase.tcl
# Description
# 	Object Domain script for inheriting pure base classes
# Created
#	01/20/1997	Johan Nilsson, Autoliv Sverige AB
# Revisions

# global variables
set VERSION 	"InheritBase 1.00"

#######################################################################################
# Utility procedures
#######################################################################################

#
# cl_superclass
# 	returns the parent of a class

#
# cl_sccnt

proc cl_sccnt { cl } {
	set sclist [$cl get superclasses]
	return [llength $sclist]
}

#
# cl_superclass
# 	returns the parent of a class

proc cl_superclass { cl } {
	set sclist [$cl get superclasses]
	set scl [lindex $sclist 0]
	set sci [expr [llength $scl] - 1]
#	switch $sci {
#		1 { puts -nonewline $fp "[lindex $scl 0]" }
#		2 { puts -nonewline $fp "[lrange $scl 0 1]" }
#	}
        return [lindex $scl $sci]
}

proc cl_is_component { cl } {
	if {[$cl get property component] != "OD_no_value"} {
		return -1
	}
	if {[cl_sccnt $cl] == 0} {
		return 0
	}
	return [cl_is_component [cl_superclass $cl]]
}


proc user_question { msg } {
        set answer [OD_giveMessage "Inherit base class" $msg question]
        return $answer
}

proc user_message { msg } {
     OD_giveMessage "Inherit base class" $msg exclamation
}


#######################################################################################
# Inherit base class
#######################################################################################

proc inherit_base { cl } {

	# check if there is a base class
	set sclist [$cl get superclasses]
	set sccnt [llength $sclist]
	if {$sccnt != 1} {
           user_message "No base class for [$cl get name]!"
           return
	}

        set inherit_pure -1
        set inherit_virtual -1
        set inherit_properties -1
if 0 {
        if {[user_question "Inherit pure operations?"] == "Yes"} {
           set inherit_pure -1
        }
        if {[user_question "Inherit virtual operations?"] == "Yes"} {
           set inherit_virtual -1
        }
        if {[user_question "Inherit properties?"] == "Yes"} {
           set inherit_properties -1
        }
}

	# inherit operations
	set sc [cl_superclass $cl]
	set scoplist [$sc get operations]
	set oplist [$cl get operations]
	foreach scop $scoplist {

		# check if pure
		if {[expr [$scop get isPure] == 1] && [expr !$inherit_pure]} {
                      continue
		}

                # check if virtual
		if {[expr [$scop get isVirtual] == 1] && [expr !$inherit_virtual]} {
                      continue
		}

		# check if operation already exists
	        set exists 0
		foreach op $oplist {
			if {[$op get name] == [$scop get name]} {
				set exists 1
				break
			}
		}
        	if {$exists} {
        		continue
        	}

	        # copy operation
        	set op [$cl add operation]
	        $op set name [$scop get name]
		$op set returnType [$scop get returnType]
		$op set description [$scop get description]
        	if [$scop get isReturnTypePointer] {
        		$op set isReturnTypePointer 1
	        }
        	if [$scop get isReturnTypeReference] {
        		$op set isReturnTypeReference 1
	        }
		$op set isVirtual 1
        	foreach scp [$scop get parameters] {
        		set clp [$op add parameter]
            		$clp set name [$scp get name]
        	}
	}

	# inherit properties
    	if {!$inherit_properties} {
    		return
    	}
	set scattlist [$sc get attributes]
    	set attlist [$cl get attributes]
    	foreach scatt $scattlist {

	    	# determine if attribute is a property
        	if {[$scatt get property "property"] == "OD_no_value"} {
        		continue
	        }

	        # check if property exists
        	set exists 0
	        foreach att $attlist {
        		if {[$att get name] == [$scatt get name]} {
            			set exists 1
	                	break
        		}
        	}
        	if $exists {
        		continue
        	}

        	# copy property
        	set att [$cl add attribute]
        	$att set name [$scatt get name]
        	$att set exportControl [$scatt get exportControl]
        	$att set property "property" ""
		if {[$scatt get property "published"] != "Od_no_value"} {
			$att set property "published" ""
		}
    	}
}

###############################################################################
# main
###############################################################################

	# check diagram type
	set diagram [OD_getActiveDiagram]
	set dt [$diagram get type]
	if {$dt != "class"} {
		error "Select a class diagram"
	}

	# loop over all selected items in the diagram
	set itemlist [$diagram get objects]
	foreach item $itemlist {
		if {[$item get objectType] != "class"} {
			continue
                }
               	# process only selected objects
		if {[$item get isSelected] == 1} {
			inherit_base [$item get class]
                }
        }
