#
# File
# 	has2att.tcl
# Description
# 	Object Domain script for converting has relations to attributes
# Created
#	03/21/1997	Johan Nilsson, Autoliv Sverige AB
# Revisions

#
# cl_tname
# parameters
# 	cl = class

proc cl_tname { cl } {

	# add a T in front of class name if not present
	if {[string index [$cl get name] 0] == "T"} {
		return [$cl get name]
	}
    return "T[$cl get name]"
}

#
# cl_pname
# parameters
#	cl = class

proc cl_pname { cl } {
	if {[string index [$cl get name] 0] == "P"} {
		return [$cl get name]
	}
	if {[string index [$cl get name] 0] == "T"} {
		return "P[string range [$cl get name] 1 end]"
	}
	return "P[$cl get name]"
}

#
# proc has_to_att
# 	Converts has relations to attributes

proc has_to_att { cl rel } {

  	# check the cardinality
	set card [$rel get toCardinality]
	set by_value [$rel get containment]
	set tocl [$rel get to]
	set toname [$tocl get name]
	set name [$rel get name]
    if (![expr [string length $name]]) {
        	set name [$tocl get name]
 	}

	# add attribute to class
	set att [$cl add attribute]
	$att set name $name
	$att set exportControl [$rel get exportControl]

	# set attribute type
    switch $card {
    	"0..n" -
        "1..n" {
			# many
			set type "TList"
		}
		"n" {
        	# fixed number of related instances
			$cl set property "type" "$toname\Array = array[ 1..n ] of $toname"
		}
        "1" -
		"0..1" -
		"unspecified" {
			# one or at most one
           	set type $toname
        }
        default {
			# user defined
			$cl set property "type" "$toname\Array = array[ $card ] of $toname"

        }
	}
	$att set className $type
}

# main

	set diag [OD_getActiveDiagram]

	if {[$diag get type] != "class"} {
		error "Select a class diagram"
	}

	# find selected classes
	foreach obj [$diag get objects] {
		if {[expr {[$obj get objectType] != "class"}] ||
		    ![$obj get isSelected]} {
			continue
		}
		set cl [$obj get class]

		# check all the relations connected to the class
		set cvlist [$cl get views]
		foreach cv $cvlist {
			set rellist [$cv get connections]
 			foreach rel $rellist {
				if {[$rel get objectType] != "relation"} {
					continue
				}
				if {[$rel get relationType] != "has"} {
					continue
				}

				# is the relation from the class?
				set frcl [$rel get from]
				if {[$frcl get class] != $cl} {
					# no
	                continue
				}

				# convert has relation to attribute
				has_to_att $cl $rel
        	}
		}
	}



