# 
# File
# 	gendmak.tcl
# Description
#	Object Domain script for generating makefile
# Created
#	1997-02-06	JN
# Revisions

proc dump_entry { fp diag item } {

	# write entry
	puts -nonewline $fp "\$(DCU)\\[$item get name].dcu :"

	# write imported modules
	set connlist [$item get connections]
    foreach conn $connlist {

		# check that connection is from module
       	if {[$conn get from] != $item} {
           	continue
		}

		# write imported module name
		set impmod [$conn get to]
		puts -nonewline $fp " \$(DCU)\\[$impmod get name].dcu"
    }
	puts $fp ""

	# write build command
	puts $fp "\t\$(DCC) \$(SRC)\\[$item get name].pas"
	puts $fp ""
}

proc dump_entry_list { fp diag } {
	# loop over all items in the diagram
	set itemlist [$diag get objects]
	foreach item $itemlist {

		# check that item is module
		if {[$item get objectType] != "module"} {
			continue
        }

		# check that item is body
		if {[$item get moduleType] != "body"} {
			continue
		}

		# check that module contains classes
		if {[llength [$item get classes]] == 0} {
			continue
		}

		# write entry
        dump_entry $fp $diag $item
	}
}


#######################################################################################
# main
#######################################################################################

	# ask for output directory
	set workdir [OD_getInput "Output directory" "" [pwd]]

	# create file name
	set filename [format "%s\\makefile" $workdir]

	# create file
	set fp [open $filename w]

	# write header
	puts $fp "#"
	puts $fp "# makefile"
	puts $fp "#"
   	puts $fp ""

	# loop through all diagrams
	set diaglist [OD_getDiagrams]
	foreach diag $diaglist {

		# check that diagram type is module
    	if {[$diag get type] != "module"} {
			continue
		}

		# write entry list
		dump_entry_list $fp $diag
	}

	# close output file
  	close $fp


