#
# File
# 	cllist.tcl
# Description
# 	Object Domain script for listing project classes in a single diagram
# Created
#	03/24/1997	Johan Nilsson, Autoliv Sverige AB
# Revisions

proc cl_order { cl1 cl2 } {
	return [string compare [$cl1 get name] [$cl2 get name]]
}

# main

	# loop through all classes
	set cllist [lsort -command cl_order [OD_getClasses]]

	# return if no classes were found
	if {[llength $modlist] == 0} {
		return
    }

	# create new class diagram
	set newdiag [OD_createDiagram "class" "All classes"]

	# set coordinates
	set width 120
	set height 120
	set maxwidth [expr 5 * $width]
	set x [expr $width / 2]
    set y [expr $height / 2]

	# loop through all classes
	foreach mod $modlist {

		# create class object in new diagram
		set newmod [$newdiag add object "class"]
		$newmod set origin $x $y
		set x [expr $x + $width]
		if {$x > $maxwidth} {
			set x [expr $width / 2]
			set y [expr $y + $height]
		}
		$newmod set name [$mod get name]

		# add classes to specification module
		foreach cl [$mod get classes] {
			$newmod add class $cl
        }
    }




