#
# File
# 	cl2comp.tcl
# Description
#	Converts a class to a component
# Created
#	04/30/1997	Johan Nilsson, Autoliv Sverige AB
# Revisions

#
# prop_is_defined
#	Returns -1 if a property is defined for an object

proc prop_is_defined { obj name } {
	return [expr [string compare [$obj get property $name] "OD_no_value"] != 0]
}

#
# cl_is_component
#	Determines if a class is a component.

proc cl_is_component { cl } {
	if {[prop_is_defined $cl component]} {
		return -1
	}
	if {[cl_sccnt $cl] == 0} {
		return 0
	}
	return [cl_is_component [cl_superclass $cl]]
}

#
# cl_sccnt
#	Returns the number of super classes for a class

proc cl_sccnt { cl } {
	set sclist [$cl get superclasses]
	return [llength $sclist]
}

#
# op_exists
#	Searches a class for an operation. Returns true if found.

proc op_exists { cl name } {
	set oplist [$cl get operations]
	foreach op $oplist {
		if {[$op get name] == $name} {
			return -1
		}
	}
	return 0
}

#
# cl_to_comp
#	Converts a class to a component

proc cl_to_comp { cl } {

	# add property component
	if {![cl_is_component $cl]} {
		$cl set property "component" ""
	}

	# add constructor
	if {![op_exists $cl "Create"]} {

		set op [$cl add operation]
        $op set name "Create"
		$op set property "constructor" ""
		$op set exportControl public
		$op set description "Constructs and initializes an instance."
		$op set semantics "inherited Create( owner );"
		set param [$op add parameter]
		$param set name "owner : TComponent"
	}

	# add destructor
	if {![op_exists $cl "Destroy"]} {

		set op [$cl add operation]
        	$op set name "Destroy"
		$op set property "destructor" ""
		$op set exportControl public
		$op set description "Destroys and disposes an instance."
		$op set semantics "inherited Destroy;"
	}

	# add loaded handler
	if {![op_exists $cl "Loaded"]} {

		set op [$cl add operation]
        $op set name "Loaded"
		$op set exportControl protected
		$op set description "Initializes the component after all its parts have loaded."
		$op set semantics "inherited Loaded;"
	}
}

# main

	set diag [OD_getActiveDiagram]

	if {[$diag get type] != "class"} {
		error "Select a class diagram"
	}

	foreach obj [$diag get objects] {
		if {[expr {[$obj get objectType] != "class"}] ||
		    ![$obj get isSelected]} {
			continue
		}

		# convert class to component
		cl_to_comp [$obj get class]
	}
