#
# File
# 	att2prop.tcl
# Description
#	Converts public attributes to properties
# Created
#	03/20/1997	Johan Nilsson, Autoliv Sverige AB
# Revisions

proc att_to_prop { cl } {

	foreach att [$cl get attributes] {
		# convert only public attributes
		if {[expr {[$att get exportControl] != "public"}] ||
		    [expr {[$att get property property] != "OD_no_value"}]} {
			continue
		}

		# check that name begins with capital
		set attname [$att get name]
		if {[string index [string toupper $attname] 0] !=
		    [string index $attname 0]} {
        	continue
		}

		# ask user if attribute should be converted
		set msg "Convert [$cl get name].$attname to property?"
		set answer [OD_giveMessage "att2prop" $msg "question"]
		if {$answer == "NO"} {
			continue
		}
		if {$answer == "CANCEL"} {
			# return false
			return 0
		}

		# convert attribute
		$att set property "property"
		$att set property read "F$attname"
		$att set property write "F$attname"
		$att set property published ""

		# create private alias
		set fatt [$cl add attribute]
		$fatt set name "F$attname"
		$fatt set className [$att get className]
		$fatt set exportControl "private"
	}

	# declare class as property
	if {[$cl get property component] == "OD_no_value"} {
		$cl set property component
	}

	# return ok
	return 1
}

# main

	set diag [OD_getActiveDiagram]

	if {[$diag get type] != "class"} {
		error "Select a class diagram"
	}

	foreach obj [$diag get objects] {
		if {[expr {[$obj get objectType] != "class"}] ||
		    ![$obj get isSelected]} {
			continue
		}

		# convert attributes to properties
		if {![att_to_prop [$obj get class]]} {
			# user abort
			return
		}
	}