unit NpsPort;
{
*************** Freeware Freeware Freeware ********************************
*	Name:					NpsPort.PAS																								*
*	Description:	Port Component and functuons (Byte and Word)							*
*	Platform:			Delphi 2.0/3.0																						*
*	Files:				NpsPort.dcu	# component (compiled)												*
*								NpsPort.dcr	# component resource file											*
*								NpsPort.pas	- component source 														*
*	Author:				Anatoly Podgoretsky																				*
*								Vahe 4-31, Johvi, Estonia, EE2045													*
*								kvk@estpak.ee																							*
*	Installation:	Copy all files into source directory (NpsPort)						*
*								Then copy files marked with <#> in your components				*
*								directory if you have it. Then install on palette					*
*								<Component|Install>. Component installed on ADD tab.			*
*								If this tab not good for you may change it.								*
*								look comment in Register procedure												*
*	Editor:				Tabs step = 2, Courier New																*
*	Started:			23.08.97 - Initial release																*
*	Changed:			dd.mm.97 - 																								*
***************************************************************************
*	Copyright:		() NPS, 1997																							*
***************************************************************************
*	This programm fully free and may use and distribute as you want, except	*
* Copyright notice, this must stay unchanged. Of couse if you modify			*
* programm you may add yours Portion Copyright statement below us. Also		*
* state our names in a credits section of your program and use it as you	*
* like.																																		*
***************************************************************************
* Remarks and Exampes																											*
* Read port (address set during design time)															*
*   B := Port1.Value			read byte from port															*
*   W := Port2.Value			read word from port															*
*   Port1.Address	:= $60  set new address of Port1												*
*   Port1.Value := 1			write byte to port															*
*   Port2.Value	:= 123		write word to port															*
*   Port1.Address	:= $60  set new address of Port1												*
* functions 	PortReadByte, PortReadWord, PortReadWordLS									*
*	procedures	PortWriteByte, PortWriteWord, PortWriteWordLS								*
*   used when need maximal speed																					*
* PortXxxLS applicable for old computers if problem with word operations	*
***************************************************************************
}
interface

uses
  Windows,
  Classes;
type

		{Abstract class}

	TNpsPort = class(TComponent)
		private
			FAddress : Word;
    public
    	constructor Create(AOwner:TComponent);	override;
		published
    	property	Address	: Word read	FAddress write FAddress;
	end;	// TNpsPort

		{Byte Port class}

	TNpsPortB = class(TNpsPort)
		private
      function	GetValue : Byte;
      procedure	SetValue(AValue:Byte);
    public
    	constructor Create(AOwner:TComponent);	override;
    	property	Value	: Byte read	GetValue write SetValue;
	end;	// TNpsPortB

		{Word Port class}

	TNpsPortW = class(TNpsPort)
		private
      function	GetValue : Word;
      procedure	SetValue(AValue:Word);
    public
    	constructor Create(AOwner:TComponent);	override;
    	property	Value	: Word read	GetValue write SetValue;
	end;	// TNpsPortW

	procedure Register;

	function PortReadByte(Addr:Word)	 : Byte;
	function PortReadWord(Addr:Word)	 : Word;
	function PortReadWordLS(Addr:Word) : Word;
	procedure PortWriteByte(Addr:Word; Value:Byte);
	procedure PortWriteWord(Addr:Word; Value:Word);
	procedure PortWriteWordLS(Addr:Word; Value:Word);

implementation

{********************
 * Create component	*
 ********************}
constructor TNpsPort.Create(AOwner:TComponent);
begin
	inherited Create(AOwner);
end;	// Create

constructor TNpsPortB.Create(AOwner:TComponent);
begin
	inherited Create(AOwner);
end;	// Create

constructor TNpsPortW.Create(AOwner:TComponent);
begin
	inherited Create(AOwner);
end;	// Create
{**************
 * Get Value	*
 **************}
function	TNpsPortB.GetValue : Byte;
begin
	Result := PortReadByte(Faddress);
end;

function	TNpsPortW.GetValue : Word;
begin
	Result := PortReadWord(Faddress);
end;
{**************
 * Get Value	*
 **************}
procedure	TNpsPortB.SetValue(AValue:Byte);
begin
  PortWriteByte(Faddress,AValue);
end;	// Click

procedure	TNpsPortW.SetValue(AValue:Word);
begin
  PortWriteWord(Faddress,AValue);
end;	// Click
{************************************************************************
 * Component registration, change section name for you favorite Add In	*
 ************************************************************************}
procedure Register;
begin
  RegisterComponents('Add',[TNpsPortB]);
  RegisterComponents('Add',[TNpsPortW]);
end;	// Register

////////////////////////////////////////////////////////
// procedures and functions for maximall speed access //
////////////////////////////////////////////////////////

const
	Delay = 150;				// dalay between two bytes operation
  										// depending of CPU speed and cards speed
{****************************************************************
 * Port Read byte function																			*
 * Parameter: port address		 																	*
 * Return: 		byte value from given port 												*
 ****************************************************************}
function PortReadByte(Addr:Word) : Byte; assembler; register;
asm
	MOV	DX,AX
  IN	AL,DX
end;
{****************************************************************
 * HIGH SPEED Port Read Word function														*
 * Parameter: port address		 																	*
 * Return:	 	word value from given port 												*
 * Comment: 	may problem with some cards and computers					*
 *						that can't to access whole word, usualy it work.	*
 ****************************************************************}
function PortReadWord(Addr:Word) : Word; assembler; register;
asm
	MOV	DX,AX
  IN	AX,DX
end;
{****************************************************************
 * LOW SPEED Port Read Word function														*
 * Parameter: port address		 																	*
 * Return:	 	word value from given port 												*
 * Comment: 	work in all cases, only to adjust DELAY if need		*
 ****************************************************************}
function PortReadWordLS(Addr:Word) : Word; assembler; register;
asm
	MOV		DX,AX
  IN		AL,DX			// read LSB port
	MOV		ECX,Delay
@1:
	LOOP	@1				// delay between two reads
	XCHG	AH,AL
  INC		DX				// port+1
	IN		AL,DX			// read MSB port
	XCHG	AH,AL			// restore bytes order
end;
{****************************************************************
 * Port Write byte function																			*
 * Parameter: port address		 																	*
 ****************************************************************}
procedure PortWriteByte(Addr:Word; Value:Byte); assembler; register;
asm
	XCHG	AX,DX
	OUT		DX,AL
end;
{****************************************************************
 * HIGH SPEED Port Write word procedure													*
 * Comment: 	may problem with some cards and computers					*
 *						that can't to access whole word, usualy it work.	*
 ****************************************************************}
procedure PortWriteWord(Addr:word; Value:word); assembler; register;
asm
	XCHG	AX,DX
	OUT		DX,AX
end;
{****************************************************************
 * LOW SPEED Port Write Word procedure													*
 * Parameter: port address		 																	*
 * Return:	 	word value from given port 												*
 * Comment: 	work in all cases, only to adjust DELAY if need		*
 ****************************************************************}
procedure PortWriteWordLS(Addr:word; Value:word); assembler; register;
asm
	XCHG	AX,DX
	OUT		DX,AL			// port LSB
	MOV		ECX,Delay
@1:
	LOOP	@1				// delay between two writes
	XCHG	AH,AL
  INC		DX				// port+1
	OUT		DX,AL			// port MSB
end;

end.
