(*******************************************************************************
**
**  NoTask
**
**	Prevents a program's icons from showing on the Win95 TASKBAR
**  while the program is running and the form is visible.  Works
**  only in Delphi 2.0. Simply drop the component on the form, and
**  set the HideForm property to TRUE to hide the TASKBAR icons.
**  Set to FALSE to show the TASKBAR icons.
**
**  The outline of this code was shamelessly stolen from the most
**  Excellent (Freeware!!) TPREVCHEK component which prevents a second
**  instance of an application.  Ironically enough, PREVCHEK only works
**  in DELPHI 1.0, whereas NOTASK only works in Delphi 2.0...  Go
**  figure.  The author also owes a debt of gratitude to the author of
**  TMinMax, Patrick Brisacier.  All of the PARENT routines came from that
**  wonderful component.  Anyway, try this out, let me know what you think.
**  This is generally intended to be used with one of the TASKTRAY components.
**
**  Feedback to:
**	Eric Lawrence
**	Lead Programmer
**	Delta Programming Group
**
**	deltagrp@juno.com    or    deltagrp@keynetcorp.net
**
**  This component should be dropped on either the main form of the
**  application or on the Splash screen form, whichever shows first.
**
**  This code may be used, modified, included in applications without any
**  license agreements as long as the disclaimers are accepted.  Credit should
**  be given where it is due.
**
**  Disclaimer:
**  This software is released into the public domain on the strict understanding
**  that neither myself nor any associates or companies I work for have any
**  liability explicitly or implied.
**
**  Possible Enhancements:
**	Beats me.  Any ideas?
*******************************************************************************)
unit NoTask;

interface
uses
  WinTypes, WinProcs, Classes, Forms, SysUtils, Controls, Messages;

type
  TDuplicateComponent = class(Exception);
  { Define a Form not Owner object exception }
  TFormNotOwner = class(Exception);
  { The NoTask Class declaration }
  TNoTask = class(TComponent)
  private
    { Private declarations - Attributes }
    FHideForm: boolean;
    OldWndProc: TFarProc;
    NewWndProc: Pointer;


    { Private declarations - Methods }

    Function IsIt:boolean;
    Procedure SetIt (value:boolean);

    {Start of Block to trap Parent form's messages...}
    procedure HookParent;
    procedure UnhookParent;
    procedure HookWndProc(var Message: TMessage);
    {End of Block to trap Parent form's messages...}

  protected

  public
    { Public declarations - Methods }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy;override;
    procedure Loaded; override;
    procedure ProcessEnabled;
  published
    { Published declarations }
    property HideForm: boolean read IsIt write SetIt stored true default true;
  end;

procedure Register;                     { Register for Object Inspector }

implementation

destructor Tnotask.Destroy;
begin
  { Always make sure that the hook is removed. }
  UnhookParent;
  inherited destroy;
end;


(*
**  Overridden constructor for our component.  Creates underlying TComponent,
**  sets our own method pointer to an unassigned state, and checks that there
**  is only one TNoTask Component on the form.  If there is another one,
**  this one is destroyed by virtue of the exception handler within the design
**  mode.
*)

constructor TNoTask.Create(AOwner: TComponent);
var
  i: word;				{ General Loop Counter }
  CompCount: byte;			{ TNoTask Component count }
begin
  inherited Create(AOwner);             { Call TComponent Constructor }
  fhideform:=true;   //Default to hidden
  NewWndProc := nil;
  OldWndProc := nil;
  CompCount := 0;                       { Initialise Component Count to zero }
  { If we are designing at present }
  if (csDesigning in ComponentState) then
    if (AOwner is TForm) then
      with (AOwner as TForm) do
      begin
        for i := 0 to ComponentCount - 1 do { Check if there is already one of us! }
          if Components[i] is TNoTask then inc(CompCount);

if CompCount > 1 then raise TDuplicateComponent.Create ('There is already a TNoTask component on this Form');
     end
      else
        raise TFormNotOwner.Create
              ('The owner of TNoTask Component is not a TForm');
        HookParent;

end;


(*
**  Overridden LOADED method.  This ensures that the check for a previous
**  instance of our Application is done immediately after the TNoTask
**  components properties have been read in from the form, and initialized.
*)

procedure TNoTask.Loaded;
begin
  inherited Loaded;                     { Always call inherited Loaded method }
 if not (csDesigning in ComponentState) then
  ProcessEnabled;
 end;


Procedure TNoTask.ProcessEnabled;
begin
//if (owner as tform).windowstate<>wsMinimized then exit;
if fHideform then
showwindow(FindWindow (nil,@Application.Title[1]),sw_hide)
else
showwindow(FindWindow (nil,@Application.Title[1]),sw_restore);
end;


Function TNoTask.IsIt:boolean;
begin
result:=fHideform;
end;

Procedure TNoTask.SetIt(value:boolean);
begin
fhideform:=value;
processenabled;
end;

procedure Tnotask.HookParent;
{ This procedure is used to get the parent's window procedure, save it,      }
{ and replace it with our own.  This allows see all of the parent's messages }
{ before it does.                                                            }
begin
  { If there is no parent, we can't hook it. }
 if owner=nil then exit;
  { Get the old window procedure via API call and store it. }
  OldWndProc := TFarProc(GetWindowLong((owner as tform).Handle, GWL_WNDPROC));
  { Convert our object method into something Windows knows how to call }
  NewWndProc := MakeObjectInstance(HookWndProc);
  { Install it as the new Parent window procedure }
  SetWindowLong((owner as tform).Handle, GWL_WNDPROC, LongInt(NewWndProc));
end;

procedure Tnotask.UnhookParent;
{ Remove our window function and reinstall the original. }
begin
  { We must have a parent, and we must have already hooked it. }
  if (owner <> NIL) and assigned(OldWndProc) then
    { Set back to original window procedure }
    SetWindowLong((owner as tform).Handle, GWL_WNDPROC, LongInt(OldWndProc));
  { If we have created a window procedure via MakeObjectInstance, }
  { it must be disposed of.                                       }
  if assigned(NewWndProc) then
    FreeObjectInstance(NewWndProc);
  { Reset variables to NIL }
  NewWndProc := NIL;
  OldWndProc := NIL;
end;


procedure Register;
{Register for the Object Inspector & Component Palette}
begin
  RegisterComponents('Additional', [TNoTask]);
end;
                          

{ The window procedure that is installed into our parent. }
procedure Tnotask.HookWndProc(var Message: TMessage);

begin
  { If there's no parent, something has really gone wrong. }
  if owner = NIL then exit;
        if (message.msg=wm_showwindow) then
            begin
              if (message.wparam<>0) then {restoring...}
                   ProcessEnabled;
            end;

{ ALWAYS call the old window procedure so the parent can process its stuff  }
message.Result := CallWindowProc(OldWndProc, (owner as tform).Handle, message.Msg, message.wParam, message.lParam);

end;

end.

