{$IfDef Win32}
  {$APPTYPE CONSOLE}
{$EndIf}
Program TestCRT;
Uses
  NewCRT;
Var
  S: {$IfDef Win32}ShortString{$Else}String{$EndIf};
  LastCol,LastRow: Word;

{  }
{  The "_" cursor blinking at actual position and wait for press any key }
{  }
Procedure ReadKeyWithUlCursor;
Begin
  SetCursor(UlCursor);
  ReadKey;
  SetCursor(NoCursor);
End;
{  }
{  Clear the screen and write the window informations }
{  }
Procedure WriteWindowRect;
Begin
  ClrScr;
  WriteLn('WinMax: ',Lo(WindMax),'/',Hi(WindMax),' Press any key ...' );
  {ReadKeyWithUlCursor;}
  Repeat
  Until KeyPressed OR MouseKeyPressed;
  If MousePressedButtons=0 Then
    ReadKey
  Else WriteLn('Mouse(X,Y)=(',MouseWhereX,',',MouseWhereY,')');
End;
{  }
{  Write the next operation name on screen }
{  }
Procedure ShowOperation( Name: String );
Begin
  WriteLn;
  Write(' '+Name);
  ReadKeyWithUlCursor;
End;
{  }
{  Make a random window and show it }
{  }
procedure MakeWindow;
var
  X,Y,Width,Height: Word;
begin
  Width:=Random(LastCol-2)+2;          { random window size }
  Height:=Random(LastRow-2)+2;
  X:=Random(LastCol-Width)+1;          { random position on screen }
  Y:=Random(LastRow-Height)+1;
  Window(X,Y,X+Width,Y+Height);
  TextBackground(Random(8));
  TextColor(Random(7)+9);
  ClrScr;
end;
{  }
{  The test program }
{  }
BEGIN
  MouseGotoXY(1,1);
  {  }
  SetCursor(NoCursor);
  TextColor(White);
  TextBackground(Blue);
  WriteWindowRect;
  {  }
  ShowOperation( 'DrawBorder(1,1,80,25,ThinLine);' );
  DrawBorder(1,1,80,25,ThinLine);
  WriteWindowRect;
  {  }
  ShowOperation( 'FillerScreen('''');' );
  FillerScreen('');
  {  }
  ShowOperation( 'Window(20, 5,60,20);' );
  Window(20, 5,60,20);
  TextBackground(Red);
  WriteWindowRect;
  {  }
  S:='01234567890123456789012345678901234567890123456789';
  ShowOperation( 'WriteLn(S);' );
  WriteLn(S);
  ShowOperation( 'GotoXY(1,16);WriteLn(S);' );
  GotoXY(1,16);WriteLn(S);
  {  }
  GotoXY(1,8);
  ShowOperation( 'GotoXY(WhereX,WhereY);InsLine;' );
  GotoXY(WhereX,WhereY);InsLine;
  ReadKey;
  {  }
  ShowOperation( 'GotoXY(WhereX,WhereY);DelLine;' );
  GotoXY(WhereX,WhereY);DelLine;
  ReadKey;
  {  }
  ClrScr;
  ShowOperation( 'DrawBorder(1,1,80,25,DoubleLinLine);' );
  TextBackground(Green);
  DrawBorder(1,1,80,25,DoubleLine);
  WriteWindowRect;
  ShowOperation( 'Repeat RandomWindows Until Keypressed;' );
  {  }
  Window(1,1,80,25);
  TextBackground(Green);
  ClrScr;
  LastCol:=Lo(WindMax)+1;
  LastRow:=Hi(WindMax)+1;
  Randomize;
  Repeat
    MakeWindow;
  Until KeyPressed;
  ReadKey;
  Alarm;
END.
