unit NetDlgs;

interface

uses
  Windows,{ Messages,} SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TResourceType=(rtDisk,rtPrinter);
  TNetDlg=Class (TComponent)
   protected
   FErrorID:DWORD;
   function GetErrorString:String;
  public
    { Public declarations }
    property ErrorString:String read GetErrorString;
    property ErrorID:DWORD Read FErrorID;
  end;

  TNetConnectDlg = class(TNetDlg)
  public
    { Public declarations }
    procedure Execute;
  end;

  TNetDisConnectDlg = class(TNetDlg)
  private
  FResourceType:TResourceType;
  public
    { Public declarations }
    procedure Execute;
  published
    property ResourceType:TResourceType read   FResourceType write FResourceType;
  end;

procedure Register;

implementation
function TNetDlg.GetErrorString:String;
begin
Result:=SysErrorMessage(FErrorID);
end;

procedure TNetDisConnectDlg.Execute;
begin
FErrorID:=WNetDisconnectDialog(Application.Handle,Integer(FResourceType)+1);
end;

procedure TNetConnectDlg.Execute;
begin
FErrorID:=WNetConnectionDialog(Application.Handle,RESOURCETYPE_DISK);
end;

procedure Register;
begin
  RegisterComponents('Dialogs', [TNetConnectDlg,TNetDisConnectDlg]);
end;

end.
