unit Ntcon;
(* (C) copyright Andrew Skinner 1998 *)
(* Skinner_doc@compuserve.com        *)
(* Free, use at your own risk        *)
(* Methods Execute, showlogondialog  *)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;



type
  TResType = (Drive,Printer); {drives and printers are handled differently}
type
  ENetconexception = class(Exception);
type
  TNetcon = class(TComponent)

private
fLocal,fUrl:string;
FResType:TRestype;
fkeep:boolean;

published
property Local:string read fLocal write fLocal;
property URL:string read furl write furl;
property ResType:TRestype read FResType write FResType;
property KeepConnectionAtLogon:boolean read fkeep write fkeep;
public
constructor Create(AOwner:TComponent);override;
procedure execute;
procedure showlogondialog;
end;

procedure Register;


implementation

Constructor TNetcon.create(AOwner:TComponent);
begin
inherited Create(AOwner);
end;

Procedure Register;
begin
RegisterComponents('Andrew''s',[TNetCon]);
end;

procedure TNetCon.execute;
var
pLocal,pURL: Array [0..200] of char;
dwresult:DWORD;
nr:TNetResource;
temp,temp2: pchar;

begin

{temp1, temp2 are null strings for the functions
lpPassword, lpUsername.  The API function uses defaults.
You could add these to the component if you need to.
They should be analagous to furl & purl for the URL to the resource.}

temp:='';
temp2:='';
if restype = drive then flocal:=flocal[1]+':';
strpcopy(Plocal,flocal);
StrPCopy(Purl,FURL);
with nr do begin
dwscope:=RESOURCE_GLOBALNET;
if Restype = drive then dwtype:=RESOURCETYPE_DISK else dwtype:=RESOURCETYPE_PRINT;
dwDisplaytype:=RESOURCEDISPLAYTYPE_GENERIC;
dwusage:=RESOURCEUSAGE_CONNECTABLE;
lpLocalName:=plocal;
lpRemoteName:=purl;
lpprovider:='';
lpcomment:='';
end;
if fkeep then
dwResult := WNetAddConnection2(nr,temp,temp2,CONNECT_UPDATE_PROFILE) else dwResult := WNetAddConnection2(nr,temp,temp2,0);
if DwResult <> No_error then
begin
raise ENetconexception.create('Network connection failed');
end;
end;

procedure TNetCon.showlogondialog;
begin
if Restype = drive then
WNetConnectionDialog(0,RESOURCETYPE_DISK);
end;

end.
