unit Main;

{ Main Body of NDS Password Validation
	by	Glenn Crouch esb@gold.net.au
		(c) 1997 	ESB Consultancy
				PO Box 2259
				Boulder WA 6432
				AUSTRALIA
				http://www.gold.net.au/~esb

	v1.1 18 Sept 1997
		- Now works properly with Windows NT 4 + Client32

	Work here based on information obtained from Novell's
	publicly available information.

	You are free to use the code as you see fit, however an
	Email or Postcard would be nice, as would a reference to
	our web site included on our web site or in your docs.
	Though none of this is obligatory.

	ESB Consultancy makes no guarantees regarding the capabilities
	nor the "Safeness" of this code. It is free after all,
	so you take all the risks :-)

	ESB Consultancy makes no promise of support for this code,
	however we are happy to receive Email comments
}

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, Messages;

type
  TNDSPasswordDlg = class(TForm)
    Label1: TLabel;
    Password: TEdit;
    Label2: TLabel;
    User: TEdit;
    Validate: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure ValidateClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  NDSPasswordDlg: TNDSPasswordDlg;

implementation

{$R *.DFM}

uses
	ESBNDSIO;

procedure TNDSPasswordDlg.FormCreate(Sender: TObject);
begin
	User.Text := GetNDSTypelessName; // Set User Name to current's user name;
	PostMessage(Handle, WM_NextDlgCtl, Password.Handle, 1); // Make password have the focus
end;

procedure TNDSPasswordDlg.ValidateClick(Sender: TObject);
var
	Name, Pass: String;
	Success: Boolean;
begin
	Screen.Cursor := crHourGlass;
	try
		Name := AnsiUpperCase (User.Text);
		Pass := AnsiUpperCase (Password.Text);
		Success := VerifyNDSPassword (Name, Pass);
		{ Verify's Password
			Note Netware causes a 'long' delay if the Password is invalid }
	finally
		Screen.Cursor := crDefault;
	end;
	if Success then
		Application.MessageBox('That was the correct Password!',
			'Succesful Validation', MB_OK or MB_ICONWARNING )
	else
		Application.MessageBox('I''m sorry but that password was incorrect!',
			'Unsuccesful Validation', MB_OK or MB_ICONERROR );
end;

end.

