unit ESBNDSIO;

{ NDS Access for NDS Password Validation Program.

	Netware 4.1 or better required
	Netware Client 32 for Windows 95 required
	
	by	Glenn Crouch esb@gold.net.au
		(c) 1997 	ESB Consultancy
				PO Box 2259
				Boulder WA 6432
				AUSTRALIA
				http://www.gold.net.au/~esb

	v1.1 18 Sept 1997
		- Now works properly with Windows NT 4 + Client32

	Work here based on information obtained from Novell's
	publicly available information.

	You are free to use the code as you see fit, however an
	Email or Postcard would be nice, as would a reference to
	our web site included on our web site or in your docs.
	Though none of this is obligatory.

	ESB Consultancy makes no guarantees regarding the capabilities
	nor the "Safeness" of this code. It is free after all,
	so you take all the risks :-)

	ESB Consultancy makes no promise of support for this code,
	however we are happy to receive Email comments
}
interface

const
	DCK_FLAGS = 1;
	DCK_CONFIDENCE = 2;
	DCK_NAME_CONTEXT = 3;
	DCK_TRANSPORT_TYPE = 4;
	DCK_REFERRAL_SCOPE = 5;
	DCK_LAST_CONNECTION = 8;
	DCK_LAST_SERVER_ADDRESS = 9;  // NLM only--see NWDSIPXNetworkAddr */
	DCK_LAST_ADDRESS_USED = 10; // NLM only--above valid only if this set */
	DCK_TREE_NAME = 11;

const
	DCV_DEREF_ALIASES = $00000001;
	DCV_XLATE_STRINGS = $00000002;
	DCV_TYPELESS_NAMES = $00000004;
	DCV_ASYNC_MODE = $00000008;
	DCV_CANONICALIZE_NAMES = $00000010;
	DCV_DEREF_BASE_CLASS = $00000040;
	DCV_DISALLOW_REFERRALS = $00000080;

type
	NWDSContextHandle = Integer;
	NWConnHandle = Integer;
	pNWConnHandle = ^Integer;
	NWConnNum = Byte;
	NWCCode = Integer;

var
	NetwarePresent: Boolean = False;
	{ If Novell & 32-bit Client present then this will be True }
	NWC: NWDSContextHandle = -1;
	{ NDS Context Handle }
	ESBConnRef: Integer = 0;
	{ If Novell & 32-bit Client present then this will NOT be 0
		and will contain the Primary Connection Reference }
	ESBConnHandle: NWConnHandle = 0;
	{ If Novell & 32-bit Client present then this will NOT be 0
		and will contain the Connection Handle used by
		subsequent Routines }
var
	NWResult: NWCCode = 0;

function GetNDSTypelessName: String;

{ Returns the current User's name qualified but without types }

function VerifyNDSPassword (Name, Password: String) : Boolean;

{ Returns True if Valid Password is given.
	Both Password & Username must be in Capitals }

{*** Calls to DLLs ***}

function NWCCGetPrimConnRef (var ConnRef : Integer): NWCCode; stdcall;

function NWCCGetConnInfo (ConnHandle: NWConnHandle;
	InfoType : Integer; Len : Integer; buffer: Pointer): NWCCode; stdcall;

function NWCCOpenConnByRef(ConnRef: Integer; OpenState: Integer;
	Reserved: Integer; var ConnHandle : NWConnHandle): NWCCODE; stdcall;

function NWCallsInit (InPtr, OutPtr: Pointer): NWCCode; stdcall;

function NWDSCreateContext: NWDSContextHandle; stdcall;

function NWDSGetContext (Context : NWDSContextHandle;
	Key: Integer; Value : Pointer): NWCCODE; stdcall;

function NWDSSetContext (Context : NWDSContextHandle;
	Key: Integer; Value : Pointer): NWCCODE; stdcall;

function NWDSWhoAmI (Context : NWDSContextHandle;
	ObjectName: PChar): NWCCODE; stdcall;

function NWDSVerifyObjectPassword (Context : NWDSContextHandle;
	OptionsFlag: Integer; ObjectName: PChar;
	Password: PChar): NWCCODE; stdcall;

implementation

uses
	SysUtils;

function NWCCGetPrimConnRef;
	external 'clxwin32.dll';

function NWCCOpenConnByRef;
	external 'clxwin32.dll';

function NWCCGetConnInfo;
	external 'clxwin32.dll';

function NWCallsInit;
	external 'calwin32.dll';

function NWDSCreateContext;
	external 'netwin32.dll';

function NWDSGetContext;
	external 'netwin32.dll';

function NWDSSetContext;
	external 'netwin32.dll';

function NWDSWhoAmI;
	external 'netwin32.dll';

function NWDSVerifyObjectPassword;
	external 'netwin32.dll';

function GetNDSTypelessName: String;
var
	Name: String;
	Flags: Integer;
begin
	if not NetwarePresent then
	begin
		Result := '';
		Exit;
	end;
	NWDSGetContext (NWC, DCK_FLAGS, @Flags);
	Flags := Flags and ($FFFFFFFF - DCV_CANONICALIZE_NAMES)
		or DCV_TYPELESS_NAMES;
	NWDSSetContext (NWC, DCK_FLAGS, @Flags);

	SetLength (Name, 1024);
	if NWDSWhoAmi (NWC, PChar (Name)) = 0 then
	begin
		SetLength (Name, StrLen (PChar (Name)));
		Result := Name;
	end
	else
		Result := '';
end;

function VerifyNDSPassword (Name, Password: String) : Boolean;
var
	Res: NWCCode;
begin
	if not NetwarePresent then
	begin
		Result := False;
		Exit;
	end;
	Res := NWDSVerifyObjectPassword (NWC, 0, PChar (Name),
		PChar (Password));
	Result := Res = 0;
end;

initialization
	NWResult := NWCallsInit (nil, nil);
	NWResult := NWCCGetPrimConnRef (ESBConnRef);
	NetwarePresent := NWResult = 0;
	if NetwarePresent then
	begin
		NetwarePresent := NWCCOpenConnByRef(ESBConnRef, 1,
			0, ESBConnHandle) = 0;
		NWC := NWDSCreateContext;
	end;
	if not NetwarePresent then
	begin
		NWC := -1;
		ESBConnHandle := 0;
		ESBConnRef := 0;
	end;
end.
