unit Mydbnav;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, DBCtrls, StdCtrls, DB;

type
  TMyDBNavigator = class(TDBNavigator)
  private
    FMyClick : ENavClick;
    procedure ButtonClick (Sender : TObject);
  public
    constructor Create (AOwner : TComponent); override;
    procedure BtnClick(Index: TNavigateBtn);
  published
    property BeforeProcessClick : ENavClick read FMyClick write FMyClick;
  end;

  TMyNavDataLink = class;
  TExtendedDBNavigator = class (TMyDBnavigator)
  private
    FDataLink : TMyNavDataLink;
    FEditingChanged : TNotifyEvent;
    FActiveChanged : TNotifyEvent;
    FDataSetChanged : TNotifyEvent;
    FNewButtons : array [low (TNavigateBtn)..high (TNavigateBtn)] of TControl;
    FMethods : array [low (TNavigateBtn)..high (TNavigateBtn)] of TNotifyEvent;
    procedure WriteButton (Index : integer; AButton : TControl);
    function ReadButton (Index : integer) : TControl;
    procedure MyBtnClick (Sender : TObject);
    procedure UpdateStateOfButtons;
    procedure WriteDataSource (ADataSource : TDataSource);
    function ReadDataSource : TDataSource;
    function GetEnabled : boolean;
    procedure SetEnabled (value : boolean);
  protected
    procedure Notification (AComponent : TComponent; AOperation : TOperation); override;
    procedure Loaded; override;
  public
    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;
  published
    property Enabled : boolean read GetEnabled write SetEnabled;
    property DataSource : TDataSource read ReadDataSource write WriteDataSource;
    property ButtonFirst : TControl index 0 read ReadButton write WriteButton;
    property ButtonPrior : TControl index 1 read ReadButton write WriteButton;
    property ButtonNext : TControl index 2 read ReadButton write WriteButton;
    property ButtonLast : TControl index 3 read ReadButton write WriteButton;
    property ButtonInsert : TControl index 4 read ReadButton write WriteButton;
    property ButtonDelete : TControl index 5 read ReadButton write WriteButton;
    property ButtonEdit : TControl index 6 read ReadButton write WriteButton;
    property ButtonPost : TControl index 7 read ReadButton write WriteButton;
    property ButtonCancel : TControl index 8 read ReadButton write WriteButton;
    property ButtonRefresh : TControl index 9 read ReadButton write WriteButton;
    property OnEditingChanged : TNotifyEvent read FEditingChanged write FEditingChanged;
    property OnDataSetChanged : TNotifyEvent read FDataSetChanged write FDataSetChanged;
    property OnActiveChanged : TNotifyEvent read FActiveChanged write FActiveChanged;
  end;

  TMyNavDataLink = class (TDataLink)
  private
    Nav : TExtendedDBNavigator;
  protected
    procedure EditingChanged; override;
    procedure DataSetChanged; override;
    procedure ActiveChanged; override;
  public
    constructor Create (AOwner : TComponent);
    destructor Destroy; override;
  end;

procedure Register;

implementation

uses
  TypInfo;

procedure Register;
begin
  RegisterComponents('MyComponents', [TMyDBNavigator, TExtendedDBNavigator]);
end;

{ TMyDBNavigator}

constructor TMyDBNavigator.Create;
var
  i : TNavigateBtn;
begin
  inherited Create (AOwner);
  for I := Low(Buttons) to High(Buttons) do
    Buttons [i].OnClick := ButtonClick;
end;

procedure TMyDBNavigator.ButtonClick;
var
  Temp : TNavigateBtn;
begin
  Temp := TNavButton (Sender).Index;
  if not (csDesigning in ComponentState) and assigned (FMyClick)
    then FMyClick (self, Temp);
  inherited BtnClick (Temp);
end;

procedure TMyDBNavigator.BtnClick;
begin
  ButtonClick (Buttons [Index]);
end;

{ TExtendedDBNavigator }

constructor TExtendedDBNavigator.Create;
begin
  inherited Create (AOwner);
  FDataLink := TMyNavDataLink.Create (self);
end;

destructor TExtendedDBNAvigator.Destroy;
begin
  FDataLink.Free;
  FDataLink := nil;
  inherited Destroy;
end;

procedure TExtendedDBNavigator.Loaded;
begin
 inherited Loaded;
 UpdateStateOfButtons;
end;

procedure TExtendedDBNavigator.MyBtnClick;
var
  i : TNavigateBtn;
begin
  for i := low (TNavigateBtn) to high (TNavigateBtn) do
    if FNewButtons [i] = sender
      then
      begin
        ButtonClick (Buttons [i]);
        if assigned (FMethods [i])
          then FMethods [i] (sender);
      end;
end;

function TExtendedDBNavigator.GetEnabled;
begin
  Result := inherited Enabled;
end;

procedure TExtendedDBNavigator.SetEnabled;
begin
  inherited Enabled := Value;
  UpdateStateOfButtons;
end;

procedure TExtendedDBNavigator.WriteDataSource;
begin
  inherited DataSource := ADataSource;
  if FDataLink <> nil
    then FDataLink.DataSource := ADataSource;
end;

function TExtendedDBNavigator.ReadDataSource;
begin
  Result := inherited DataSource;
end;

procedure TExtendedDBNavigator.UpdateStateOfButtons;
var
  i : TNavigateBtn;
begin
  for i := low (TNavigateBtn) to high (TNavigateBtn) do
    if FNewButtons [i] <> nil
      then FNewButtons [i].Enabled := Buttons [i].Enabled;
end;

procedure TExtendedDBNAvigator.WriteButton;
var
  Indice : TNavigateBtn absolute Index;
  Method : TMethod;
begin
  if FNewButtons [Indice] <> AButton
    then
    begin
      if not (csDesigning in ComponentState)
        then if AButton <> nil
          then
          begin
            FMethods [Indice] := TNotifyEvent (GetMethodProp (AButton, GetPropInfo (AButton.ClassInfo, 'OnClick')));
            Method.Data := self;
            Method.Code := @TExtendedDBNavigator.MyBtnClick;
            SetMethodProp (AButton, GetPropInfo (AButton.ClassInfo, 'OnClick'), Method);
          end
          else
          begin
            SetMethodProp (FNewButtons [Indice], GetPropInfo (FNewButtons [Indice].ClassInfo, 'OnClick'), TMethod (FMethods [Indice]));
            FMethods [Indice] := nil;
          end;
      FNewButtons [Indice] := AButton;
    end;
end;

function TExtendedDBNAvigator.ReadButton;
begin
  Result := FNewButtons [TNavigateBtn (Index)];
end;

procedure TExtendedDBNavigator.Notification;
var
  i : TNavigateBtn;
begin
  inherited Notification (AComponent, AOperation);
  if AOperation = opRemove
    then
    begin
      for i := low (TNavigateBtn) to high (TNavigateBtn) do
        if FNewButtons [i] = AComponent
          then FNewButtons [i] := nil;
    end;
end;

{ TMyNavDataLink }

constructor TMyNavDataLink.Create;
begin
  inherited Create;
  Nav := TExtendedDBNavigator (AOwner);
end;

destructor TMyNavDataLink.Destroy;
begin
  Nav := nil;
  inherited Destroy;
end;

procedure TMyNAvDataLink.EditingChanged;
begin
  if Nav <> nil
    then
    begin
      Nav.UpdateStateOfButtons;
      if assigned (Nav.FEditingChanged)
        then Nav.FEditingChanged (Nav);
    end;
end;

procedure TMyNavDataLink.DataSetChanged;
begin
  if Nav <> nil
    then
    begin
      Nav.UpdateStateOfButtons;
      if assigned (Nav.FDataSetChanged)
        then Nav.FDataSetChanged (Nav);
    end;
end;

procedure TMyNavDataLink.ActiveChanged;
begin
  if Nav <> nil
    then
    begin
      Nav.UpdateStateOfButtons;
      if assigned (Nav.FActiveChanged)
        then Nav.FActiveChanged (Nav);
    end;
end;

end.
