{
  MyDBNavigator97 version 1.02

  This component was developed by Jose Sebastian Battig
  EMail: sbattig@bigfoot.com

  I developed this component for my own use, it's freeware and you are entitled to
  use it as you want... but, if you want to publish it as a subset of another
  software product developed by you, please include my name as the author.
  If you have question or bugs reports just e-mail me. That don't bother me.

  Read notes.txt for version diferences.
}

unit MyDbNav97;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  COMPFORM, DBCtrls, Mydbnav, TB97, ExtCtrls, DB;

type
  TMyNavigateBtn97 = (nbFirst97, nbPrior97, nbNext97, nbLast97, nbInsert97, nbDelete97,
                      nbEdit97, nbPost97, nbCancel97, nbRefresh97, nbBookmark97);
  TMyButtonSet97 = set of TMyNavigateBtn97;
  TMyNavClick97 = procedure (Sender: TObject; Button: TMyNavigateBtn97) of object;
  TMyDBNavigator97 = class(TComponentForm)
  { Important!!!!!!!!!: This fields and methods MUST be considered privated !!!,
    they are published because Delphi needs this if you want to edit visually
    the component... well, maybe a new kind of access specifier will be necesary...
    something like: PrivateButPublishedForDesigners a bit long the name don't you
    think? }
    PanelPrincipal: TPanel;
    ButtonFirst: TToolbarButton97;
    ButtonPrior: TToolbarButton97;
    ButtonNext: TToolbarButton97;
    ButtonLast: TToolbarButton97;
    ButtonBookmark: TToolbarButton97;
    ButtonInsert: TToolbarButton97;
    ButtonDelete: TToolbarButton97;
    ButtonEdit: TToolbarButton97;
    ButtonPost: TToolbarButton97;
    ButtonCancel: TToolbarButton97;
    ButtonRefresh: TToolbarButton97;
    Navigator: TExtendedDBNavigator;
    procedure NavigatorBeforeProcessClick(Sender: TObject;
      Button: TNavigateBtn);
    procedure NavigatorClick(Sender: TObject; Button: TNavigateBtn);
    procedure ButtonBookmarkClick(Sender: TObject);
    procedure NavigatorChanged(Sender: TObject);
  private
    Bookmark : TBookmark;
    FVisibleButtons : TMyButtonSet97;
    Buttons : array [low (TMyNavigateBtn97)..high (TMyNavigateBtn97)] of TToolbarButton97;
    FBeforeProcessClick : TMyNavClick97;
    FOnClick : TMyNavClick97;
    function GetEnabled : boolean;
    procedure SetEnabled (Value : boolean);
    function GetConfirmDelete : boolean;
    procedure SetConfirmDelete (Value : boolean);
    function GetDataSource : TDataSource;
    procedure SetDataSource (Value : TDataSource);
    procedure SetVisibleButtons (Btns : TMyButtonSet97);
    function GetHints : TStrings;
    procedure SetHints (Value : TStrings);
    function GetGlyph (index : integer) : TBitmap;
    procedure SetGlyph (index : integer; Value : TBitmap);
    function GetNumGlyphs (index : integer) : integer;
    procedure SetNumGlyphs (index, value : integer);
    procedure UpdateButtons;
    procedure UpdateEnabled;
    procedure WMSize (var Msg : TMessage); message WM_SIZE;
  protected
    procedure CreateWnd; override;
    procedure Loaded; override;
    procedure Notification (AComponent : TComponent; AOperation : TOperation); override;
  public
    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;
    procedure FreeBookmark; virtual;
  published
    property Align;
    property Cursor;
    property Enabled : boolean read GetEnabled write SetEnabled;
    property ParentCtl3D;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Visible;
    property ConfirmDelete : boolean read GetConfirmDelete write SetConfirmDelete;
    property DataSource : TDataSource read GetDataSource write SetDataSource;
    property VisibleButtons : TMyButtonSet97 read FVisibleButtons write SetVisibleButtons;
    property Hints : TStrings read GetHints write SetHints;
    property GlyphFirst : TBitmap index 0 read GetGlyph write SetGlyph;
    property GlyphPrior : TBitmap index 1 read GetGlyph write SetGlyph;
    property GlyphNext : TBitmap index 2 read GetGlyph write SetGlyph;
    property GlyphLast : TBitmap index 3 read GetGlyph write SetGlyph;
    property GlyphInsert : TBitmap index 4 read GetGlyph write SetGlyph;
    property GlyphDelete : TBitmap index 5 read GetGlyph write SetGlyph;
    property GlyphEdit : TBitmap index 6 read GetGlyph write SetGlyph;
    property GlyphPost : TBitmap index 7 read GetGlyph write SetGlyph;
    property GlyphCancel : TBitmap index 8 read GetGlyph write SetGlyph;
    property GlyphRefresh : TBitmap index 9 read GetGlyph write SetGlyph;
    property GlyphBookmark : TBitmap index 10 read GetGlyph write SetGlyph;
    property NumGlyphsFirst : integer index 0 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsPrior : integer index 1 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsNext : integer index 2 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsLast : integer index 3 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsInsert : integer index 4 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsDelete : integer index 5 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsEdit : integer index 6 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsPost : integer index 7 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsCancel : integer index 8 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsRefresh  : integer index 9 read GetNumGlyphs write SetNumGlyphs;
    property NumGlyphsBookmark  : integer index 10 read GetNumGlyphs write SetNumGlyphs;
    { Event Handlers }
    property BeforeProcessClick : TMyNavClick97 read FBeforeProcessClick write FBeforeProcessClick;
    property OnClick : TMyNavClick97 read FOnClick write FOnClick;
    property OnDblClick;
    property OnResize;
  end;

procedure Register;

implementation

uses
  TypInfo;

{$R *.DFM}
{$R *.RES}

procedure Register;
begin
  RegisterComponents ('New', [TMyDBNavigator97]);
end;

constructor TMyDBNavigator97.Create;
var
  i : integer;
  j : TMyNavigateBtn97;
begin
  inherited Create (AOwner);
  Bookmark := nil;
  FVisibleButtons := [nbFirst97, nbPrior97, nbNext97, nbLast97, nbBookmark97,
                      nbInsert97, nbDelete97, nbEdit97, nbPost97, nbCancel97, nbRefresh97];
  Width := 264;
  Height := 25;
  Caption := '';
  BevelOuter := bvNone;
  ControlStyle := ControlStyle - [csAcceptsControls];
  PanelPrincipal.ControlStyle := PanelPrincipal.ControlStyle - [csAcceptsControls];
  j := low (j);
  for i := 0 to ComponentCount - 1 do
    if Components [i] is TToolbarButton97
      then
      begin
        Buttons [j] := Components [i] as TToolbarButton97;
        inc (j);
      end;
end;

destructor TMyDBNavigator97.Destroy;
begin
  FreeBookmark;
  inherited Destroy;
end;

procedure TMyDBNavigator97.FreeBookmark;
begin
  if (Bookmark <> nil) and (Navigator <> nil) and
     (Navigator.DataSource <> nil) and (Navigator.DataSource.DataSet <> nil)
    then try
      Navigator.DataSource.DataSet.FreeBookmark (Bookmark);
    finally
      Bookmark := nil;
      ButtonBookmark.Down := false;
    end;
end;

procedure TMyDBNAvigator97.CreateWnd;
var
  i : TMyNavigateBtn97;
begin
  inherited CreateWnd;
  for i := low (i) to high (i) do
    with Buttons [i] do
      if Glyph.Empty
        then Glyph.LoadFromResourceName (HInstance, 'MYBMP' + UpperCase (copy (Name, 7, length (Name) - 6)));
end;

procedure TMyDBNavigator97.Loaded;
var
  i : integer;
  j : TMyNavigateBtn97;
begin
  inherited Loaded;
  if (not (csDesigning in ComponentState)) and (Navigator <> nil)
    then
    begin
      for i := 0 to ComponentCount - 1 do
        SetMethodProp (Components [i], GetPropInfo (Components [i].ClassInfo, 'OnDblClick'), TMethod (OnDblClick));
      for j := low (j) to high (j) do
        with Buttons [j] do
          begin
            if ord (j) < Navigator.Hints.Count
              then
              begin
                Hint := Navigator.Hints [ord (j)];
                ShowHint := Self.ShowHint;
              end;
          end;
    end;
  UpdateEnabled;
end;

procedure TMyDBNavigator97.Notification;
begin
  inherited Notification (AComponent, AOperation);
  if ([csDestroying, csDesigning] * ComponentState = []) and
     (AOperation = opRemove) and (Navigator <> nil) and
     ((((AComponent = Navigator.DataSource) and (Navigator.DataSource.DataSet <> nil)) or
     ((Navigator.DataSource <> nil) and (Navigator.DataSource.DataSet = AComponent))) and
     (Bookmark <> nil))
    then FreeBookmark;
  if (not (csDestroying in ComponentState)) and (AOperation = opRemove) and
     (AComponent = DataSource)
    then DataSource := nil;
end;

function TMyDBNavigator97.GetEnabled;
begin
  Result := inherited Enabled;
end;

procedure TMyDBNavigator97.SetEnabled;
begin
  inherited Enabled := Value;
  if Navigator <> nil
    then Navigator.Enabled := Value;
  UpdateEnabled;
end;

function TMyDBNavigator97.GetConfirmDelete;
begin
  if Navigator <> nil
    then Result := Navigator.ConfirmDelete
    else Result := false;
end;

procedure TMyDBNavigator97.SetConfirmDelete;
begin
  if Navigator <> nil
    then Navigator.ConfirmDelete := Value;
end;

function TMyDBNavigator97.GetDataSource;
begin
  if Navigator <> nil
    then Result := Navigator.DataSource
    else Result := nil;
end;

procedure TMyDBNavigator97.SetDataSource;
begin
  if Navigator <> nil
    then
    begin
      if ([csDesigning, csDestroying] * ComponentState = []) and
         (Value <> Navigator.DataSource) and (Navigator.DataSource <> nil) and
         (Navigator.DataSource.DataSet <> nil) and (Bookmark <> nil)
        then FreeBookmark;
      Navigator.DataSource := Value;
    end;
  UpdateEnabled;
end;

procedure TMyDBNavigator97.SetVisibleButtons;
var
  Temp : TMyButtonSet97;
begin
  FVisibleButtons := Btns;
  if Navigator <> nil
    then
    begin
      Temp := Btns - [nbBookmark97];
      Navigator.VisibleButtons := TButtonSet (Temp);
    end;
  UpdateButtons;
end;

function TMyDBNavigator97.GetHints;
begin
  if Navigator <> nil
    then Result := Navigator.Hints
    else Result := nil;
end;

procedure TMyDBNavigator97.SetHints;
begin
  if Navigator <> nil
    then Navigator.Hints := Value;
end;

function TMyDBNavigator97.GetGlyph;
begin
  Result := Buttons [TMyNavigateBtn97 (Index)].Glyph;
end;

procedure TMyDBNavigator97.SetGlyph;
begin
  Buttons [TMyNavigateBtn97 (Index)].Glyph.Assign (Value);
end;

function TMyDBNavigator97.GetNumGlyphs;
begin
  Result := Buttons [TMyNavigateBtn97 (Index)].NumGlyphs;
end;

procedure TMyDBNavigator97.SetNumGlyphs;
begin
  Buttons [TMyNavigateBtn97 (Index)].NumGlyphs := Value;
end;

procedure TMyDBNavigator97.WMSize;
begin
  inherited;
  if Navigator <> nil
    then Navigator.Top := Height + 1;
  UpdateButtons;
end;

procedure TMyDBNavigator97.UpdateEnabled;
begin
  if not (csDestroying in ComponentState)
    then ButtonBookmark.Enabled := ButtonNext.Enabled or ButtonPrior.Enabled;
end;

procedure TMyDBNavigator97.UpdateButtons;
var
  i : TMyNavigateBtn97;
  CountV : integer;
  W, R, Wt, Ac : integer;
begin
  if not (csDestroying in ComponentState)
    then
    begin
      CountV := 0;
      for i := low (i) to high (i) do
        begin
          Buttons [i].Visible := i in FVisibleButtons;
          if Buttons [i].Visible
            then inc (CountV);
        end;
      try
        W := Width div CountV;
        R := Width mod CountV;
      except
        W := 0;
        R := 0;
      end;
      Ac := 0;
      for i := low (i) to high (i) do
        if Buttons [i].Visible
          then
          begin
            if R > 0
              then Wt := W + 1
              else Wt := W;
            with Buttons [i] do
              begin
                Top := 0;
                Left := Ac;
                Height := Self.Height;
                Width := Wt;
              end;
            inc (Ac, Wt);
            dec (R);
          end
          else Buttons [i].Top := Height + 1;
    end;
end;

procedure TMyDBNavigator97.NavigatorBeforeProcessClick(Sender: TObject;
  Button: TNavigateBtn);
begin
  inherited;
  if assigned (FBeforeProcessClick)
    then FBeforeProcessClick (self, TMyNavigateBtn97 (Button));
end;

procedure TMyDBNavigator97.NavigatorClick(Sender: TObject;
  Button: TNavigateBtn);
begin
  inherited;
  if assigned (FOnClick)
    then FOnClick (Self, TMyNavigateBtn97 (Button));
end;

procedure TMyDBNavigator97.ButtonBookmarkClick(Sender: TObject);
begin
  inherited;
  if (Navigator <> nil) and (Navigator.DataSource <> nil) and
     (Navigator.DataSource.DataSet <> nil)
    then
    begin
      if assigned (FBeforeProcessClick)
        then FBeforeProcessClick (Self, nbBookmark97);
      if Bookmark = nil
        then Bookmark := Navigator.DataSource.DataSet.GetBookmark
        else with Navigator.DataSource.DataSet do
          try
            GotoBookmark (Self.Bookmark);
          finally
            Self.FreeBookmark;
          end;
      ButtonBookmark.Down := Bookmark <> nil;
      if assigned (FOnClick)
        then FOnClick (Self, nbBookmark97);
    end;
end;

procedure TMyDBNavigator97.NavigatorChanged(Sender: TObject);
begin
  inherited;
  UpdateEnabled;
end;

end.
