unit CompForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TComponentForm = class(TCustomPanel)
  private
    procedure ReadTextHeight (Reader : TReader);
    procedure ReadPixelsPerInch (Reader : TReader);
    procedure WriteTextHeight (Writer : TWriter);
    procedure WritePixelsPerInch (Writer : TWriter);
  protected
    procedure DefineProperties (Filer : TFiler); override;
  public
    constructor Create (AOwner : TComponent); override;
  end;

implementation

{$R *.DFM}

constructor TComponentForm.Create;
begin
  inherited Create (AOwner);
  ReadComponentRes (self.ClassName, self);
end;

procedure TComponentForm.DefineProperties;
begin
  inherited DefineProperties (Filer);
  Filer.DefineProperty('PixelsPerInch', ReadPixelsPerInch, WritePixelsPerInch, false);
  Filer.DefineProperty ('TextHeight', ReadTextHeight, WriteTextHeight, false);
end;

procedure TComponentForm.ReadTextHeight;
begin
  Reader.ReadInteger;
end;

procedure TComponentForm.WriteTextHeight;
begin
  Writer.WriteInteger (0);
end;

procedure TComponentForm.ReadPixelsPerInch;
begin
  Reader.ReadInteger;
end;

procedure TComponentForm.WritePixelsPerInch;
begin
  Writer.WriteInteger (0);
end;

end.
