{+--------------------------------------------------------------------------+
 | Component:   TLineToken
 | Created:     18.06.97
 | Author:      Martin Waldenburg
 | Copyright    1997, all rights reserved.
 | Description: TLineToken breaks a PChar into Lines and filters all comments.
 |              On my Pentium 166 about 8.5MB/Second. Without the filter it's
 |              double as fast.
 | Version:     1.2
 | State:       FreeWare
 +--------------------------------------------------------------------------+}
 { Disclaimer:
   This is provided as is, expressly without a warranty of any kind.
   You use it at your own risc.}

unit mwLineToken;

{$R-}


interface

uses SysUtils, Windows, Dialogs;

type

 { TLineToken class }
  PITokenArray = ^TITokenArray;
  TITokenArray = array[0..0] of PChar;
  TLineToken = class(TObject)
  private
    FTokenPos: PChar;
    FLineToken: PITokenArray;
    FCount: Integer;
    fCapacity:Integer;
    fOrigin:PChar;
    fDelimiters: array[0..50] of Char;
    procedure Expand;
    procedure SetCapacity(NewCapacity:Integer);
    function GetToken(Index: Integer):PChar;
    function GetPosition(Index: Integer):Integer;
    function GetLength(Index: Integer):Integer;
  protected
    function GetItems(Index: Integer):PChar;
    procedure SetItems(Index: Integer;  Item: PChar);
  public
    constructor create;
    destructor Destroy; override;
    function Add(Item: PChar):Integer;
    procedure Tokenize(OriginPtr: PChar; StartCapacity: Integer);
    procedure Clear;
    procedure Pack;
    property Capacity:Integer read fCapacity write SetCapacity;
    property Count: Integer read FCount;
    property Items[Index: Integer]: PChar read GetItems write SetItems; default;
    property Origin:PChar read fOrigin write fOrigin;
    property Token[Index: Integer]:PChar read GetToken;
    property Position[Index: Integer]:Integer read GetPosition;
    property Length[Index: Integer]:Integer read GetLength;
  published
  end;

implementation

{ TLineToken }

constructor TLineToken.create;
begin
  inherited Create;
end;

procedure TLineToken.Clear;
begin
  FCount:= 0;
  FCapacity:= 0;
  ReallocMem(FLineToken, 0 * SizeOf(PChar));
end;

destructor TLineToken.Destroy;
begin
  Clear;
  Inherited Destroy;
end;

procedure TLineToken.Expand;
begin
  SetCapacity(FCapacity + 1024);
end;

procedure TLineToken.SetCapacity(NewCapacity:Integer);
begin
  FCapacity:= NewCapacity;
  ReallocMem(FLineToken, FCapacity * SizeOf(PChar));
end;

function TLineToken.Add(Item: PChar):Integer;
begin
  Result := FCount;
  if Result = FCapacity then Expand;
  FLineToken[Result] := Item;
  Inc(FCount);
end;

function TLineToken.GetItems(Index: Integer):PChar;
begin
  Result := FLineToken[Index];
end;

procedure TLineToken.SetItems(Index: Integer;  Item: PChar);
begin
  FLineToken[Index]:= Item;
end;

procedure TLineToken.Pack;
begin
  ReallocMem(FLineToken, FCount * SizeOf(PChar));
end;

function TLineToken.GetLength(Index: Integer):Integer;
var
  First, Final: PChar;
begin
  First:= FLineToken[Index];
  Final:= First;
  while Final^ <> #13 do inc(Final);
  Result:= Final - First;
end;

function TLineToken.GetPosition(Index: Integer):Integer;
var
  First, Final: PChar;
begin
  First:= FLineToken[Index];
  Result:= First - FOrigin;
end;

function TLineToken.GetToken(Index: Integer):PChar;
var
  First, Final: PChar;
  TokenLen: Integer;
  aToken: array[0..1024] of Char;
begin
  First:= FLineToken[Index];
  TokenLen:= GetLength(Index);
  StrLCopy(aToken, First, TokenLen);
  aToken[TokenLen +1]:= #0;
  Result:= aToken;
end;

procedure TLineToken.Tokenize(OriginPtr: PChar; StartCapacity: Integer);
var
  Start, Run: PChar;
  Comment, Slashes, Text, AnsiComment, StarBrace: Boolean;
begin
  fOrigin:= OriginPtr;
  SetCapacity(StartCapacity);
  Text:= False;
  Comment:= False;
  Slashes:= False;
  AnsiComment:= False;
  Run:= FOrigin;
  while (Run^<>#0) do
  begin
    Start:= Run;
    Add(Start);
    while (Run^<>#0) and (Run^ <> #13) do
    begin
    {+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
      Case Run^ of
        #39:  if not Comment and not AnsiComment then begin Text:= not Text; Run^:= #32; end;
        #40:  if not Comment and not Text then
              begin
                Inc(Run);
                if Run^ = #42 then
                begin
                  AnsiComment:= True;
                end;
                dec(Run);
              end;

        #42:   if not Comment and not Text then
               begin
                 Inc(Run);
                 if Run^ = #41 then
                 begin
                   AnsiComment:= False;
                   StarBrace:= True;
                   Run^:= #32;
                 end;
                 dec(Run);
                 if StarBrace then Run^:= #32;
                 StarBrace:= False;
               end;

        #47:  if not Comment and not Text and not AnsiComment then
              begin
                Inc(Run);
                if Run^ = #47 then
                begin
                  Slashes:= True;
                  Comment:= True;
                end;
                dec(Run);
              end;

        #123: if not Text and not Slashes and not AnsiComment then Comment:= True;
        #125: if not Text and not Slashes and not AnsiComment then begin Comment:= False; Run^:= #32; end;
      end;
      if Text or Comment or AnsiComment then Run^:= #32;
      Inc(Run);
    {+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
    end;
    if Slashes then
    begin
      Comment:= False;
      Slashes:= False;
    end;
    Inc(Run, 2);
  end;
end;

end.
