unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, mwPCharStream, mwTokenList, mwFastTime;

type
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Time1: TmwFastTime;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  DelimTable: TDelimiter;

implementation

{$R *.DFM}

procedure MakeDelimiters;
var
  I: Char;
  K, StringLength: Integer;
  Delim: String;
begin
  Delim := ' ;:()=.,[]-{}{<>*+/!?"' + #39 + #34 + #9 + #13 + #10 + #0;
  StringLength := System.Length(Delim);
  for I := #0 to #255 do DelimTable[I] := False;
  for K := 1 to StringLength do
  begin
    DelimTable[Delim[K]] := True;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  PcharStream: TPcharStream;
  TokenList: TTokenList;
  OutFile: TextFile;
  Counter, I: Integer;
  Token: String;
begin
  if OpenDialog1.Execute then
  begin
  //  Counter := 0;
  //  AssignFile(OutFile, 'OutPut.txt');
  //  Rewrite(OutFile);
    PcharStream := TPcharStream.Create;
    PcharStream.LoadFromFile(OpenDialog1.FileName);
    TokenList := TTokenList.Create(PcharStream.AsPchar);
    TokenList.Delimiters := DelimTable;
    Time1.Start;
    while not TokenList.Finished do
    begin
      Token := TokenList.Next;
      //if (Token <> #13) and (Token <> #10) and (Token <> #32) then
        //Writeln(OutFile, Token);
      inc(Counter);
    end;
   { TokenList.Tokenize(trunc(PcharStream.Size / 3));
    for I := 0 to TokenList.Count - 1 do
    begin
      Token := TokenList.Token[I];
    //if (Token <> #13) and (Token <> #10) and (Token <> #32)then
    //Writeln(OutFile, Token);
    end; }
    Time1.Stop;
    Label1.Caption := IntToStr(PcharStream.Size) + ' Byte';
    Label2.Caption := 'Token count: ' + IntToStr(Counter);
    //Label2.Caption := 'Token count: ' + IntToStr(TokenList.Count);
    Label3.Caption := Time1.ElapsedTime;
    TokenList.Free;
    PcharStream.Free;
    //CloseFile(OutFile);
  end;
end;

Initialization

  MakeDelimiters;

end.

