{+--------------------------------------------------------------------------+
 | Created:     1.98
 | Author:      Martin Waldenburg
 | Copyright    1997, all rights reserved.
 | Description: Demo for mwEPParser, it retrives all classes in an unit.
 | Version:     1.0
 | Status:      FreeWare
 | DISCLAIMER:  This is provided as is, expressly without a warranty of any kind.
 |              You use it at your own risc.
 +--------------------------------------------------------------------------+}

unit BrowserUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  mwFastTime, StdCtrls, mwPasParser, mwEPParser, ComCtrls, ExtCtrls;

type

  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    Button1: TButton;
    TreeView1: TTreeView;
    Time1: TmwFastTime;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Expanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
  private
    Parser: TmeParser;
    Stream: TMemoryStream;
    FFileName: String;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  LastPos: LongInt;
  Info: TmPasInfo;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  Data: String;
  ClassKind: TmInfoKind;
  aNode, ClForwardNode, ClassesNode, ClReferenceNode, ExceptionsNode: TTreeNode;
begin
  TreeView1.Items.Clear;
  TreeView1.Items.BeginUpdate;
  if OpenDialog1.Execute then
  begin
    Time1.Start;
    FFileName:= OpenDialog1.FileName;
    Parser:= TmEParser.Create;
    Stream:= TMemoryStream.Create;
    Stream.LoadFromFile(FFileName);
    Parser.Origin:= Stream.Memory;
    ExceptionsNode:= TreeView1.Items.AddChild(nil, 'EXCEPTIONS');
    ClForwardNode:= TreeView1.Items.AddChild(nil, 'CLASS FORWARD');
    ClReferenceNode:= TreeView1.Items.AddChild(nil, 'CLASS REFERENCES');
    ClassesNode:= TreeView1.Items.AddChild(nil, 'CLASSES');
    repeat
      ClassKind:= Parser.NextClassKind;
      Data:= Parser.Info.Data;
      Case ClassKind of
        ikClass:
          begin
            if Data[1] = 'T' then
            aNode:= TreeView1.Items.AddChild(ClassesNode, Data);
            if Data[1] = 'E' then
            aNode:= TreeView1.Items.AddChild(ExceptionsNode, Data);
            aNode.HasChildren:= True;
            Info:= TmPasInfo.Create;
            Info.ID:= Parser.Info.ID;
            Info.Data:= Parser.Info.Data;
            Info.LineNumber:= Parser.Info.LineNumber;
            Info.LinePos:= Parser.Info.LinePos;
            Info.AI:= TmAdditionalInfo.Create;
            Info.AI.Ready:= False;
            aNode.Data:= Info;
          end;

        ikClEmpty:
          begin
            if Data[1] = 'T' then
            TreeView1.Items.AddChild(ClassesNode, Data);
            if Data[1] = 'E' then
            TreeView1.Items.AddChild(ExceptionsNode, Data);
          end;

        ikClForward:
          TreeView1.Items.AddChild(ClForwardNode, Data);

        ikClReference:
          TreeView1.Items.AddChild(ClReferenceNode, Data);
      end;
    until ClassKind = ikNull;
    Time1.Stop;
    Edit1.Text:= Time1.ElapsedTime;
    Parser.Free;
    Stream.Free;
  end;
  TreeView1.Items.EndUpdate;
end;

procedure TForm1.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
begin
  if Node.Data <> nil then
  begin
    TmPasInfo(Node.Data).Free;
    Node.Data:= nil;
  end;
end;

procedure TForm1.TreeView1Expanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
begin
  if (Node.Data <> nil) then
  if not TmPasInfo(Node.Data).AI.Ready then
  begin
    Time1.Start;
    Parser:= TmEParser.Create;
    Stream:= TMemoryStream.Create;
    Stream.LoadFromFile(FFileName);
    Parser.Origin:= Stream.Memory;
    Parser.RunPos:= TmPasInfo(Node.Data).LinePos;
    Parser.Token.LineNumber:= TmPasInfo(Node.Data).LineNumber;
    Parser.NextClassKind;
    repeat
      Parser.NextClassElement;
      if Parser.Info.ID = ikNull then break;
      TreeView1.Items.AddChild(Node, Parser.Info.Data);
    until Parser.Info.ID = ikClEnd;
    TmPasInfo(Node.Data).AI.Ready:= True;
    Time1.Stop;
    Edit1.Text:= Time1.ElapsedTime;
    Parser.Free;
    Stream.Free;
  end;
end;

end.
