{+--------------------------------------------------------------------------+
 | Unit:        GenUnit
 | Created:     7.98
 | Author:      Martin Waldenburg
 | Copyright    1998, all rights reserved.
 | Description: Generator for heigh speed token lists, drived by a simple grammar.
 | Version:     0.7 Beta
 | Status       FreeWare
 | DISCLAIMER:  This is provided as is, expressly without a warranty of any kind.
 |              You use it at your own risc.
 +--------------------------------------------------------------------------+}
unit GenUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, mGenLex, mwFastTime;
var
  mKeyHashTable: array[#0..#255] of Integer;
  mSKeyHashTable: array[#0..#255] of Integer;

type
  TLexKeys = Class
  public
    KeyName: String;
    Key: Integer;
  end;

  TLexCharsets = Class
  public
    SetName: String;
    Charset: String;
    ProcData: String;
    FuncData: String;
  end;

  TGenFrm = class(TForm)
    StartBtn: TButton;
    OpenDialog1: TOpenDialog;
    procedure StartBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    LexName: String;
    IdentPre: String;
    IdentStart: String;
    IdentContent: String;
    OutFile: TextFile;
    Sensitivity: Boolean;
    Stream: TMemoryStream;
    Lex: TmwGenLex;
    KeyList: TList;
    SetList: TList;
    IdentList: TStringList;
    procedure MakeHashTable;
    procedure MakeSensitiveHashTable;
    procedure FillKeyList;
    procedure OutFileCreate(InName: String);
    procedure ParseCharsets;
    procedure RetriveCharset;
    function KeyHash(ToHash: String): Integer;
    function SensKeyHash(ToHash: String): Integer;
    procedure WriteRest;
  public
    { Public-Deklarationen }
  end;

var
  GenFrm: TGenFrm;

implementation

{$R *.DFM}

function CompareKeys(Item1, Item2: Pointer): Integer;
begin
  if TLexKeys(Item1).Key < TLexKeys(Item2).Key then Result := -1 else
    if TLexKeys(Item1).Key = TLexKeys(Item2).Key then Result := 0 else
      if TLexKeys(Item1).Key > TLexKeys(Item2).Key then Result := 1;
end;

function CompareSets(Item1, Item2: Pointer): Integer;
begin
  if TLexCharsets(Item1).SetName < TLexCharsets(Item2).SetName then Result := -1 else
    if TLexCharsets(Item1).SetName = TLexCharsets(Item2).SetName then Result := 0 else
      if TLexCharsets(Item1).SetName > TLexCharsets(Item2).SetName then Result := 1;
end;

procedure TGenFrm.MakeSensitiveHashTable;
var
  I: Char;
begin
  for I := #0 to #255 do
  begin
    Case I in ['_', 'A'..'Z', 'a'..'z'] of
      True:
        begin
          if (I > #64) and (I < #91) then mSKeyHashTable[I] := Ord(I) - 64 else
            if (I > #96) then mSKeyHashTable[I] := Ord(I) - 95;
        end;
    else mSKeyHashTable[I] := 0;
    end;
  end;
end;

procedure TGenFrm.MakeHashTable;
var
  I, J: Char;
begin
  for I := #0 to #255 do
  begin
    J := UpperCase(I)[1];
    Case I in ['_', 'A'..'Z', 'a'..'z'] of
      True: mKeyHashTable[I] := Ord(J) - 64;
    else mKeyHashTable[I] := 0;
    end;
  end;
end;

function TGenFrm.SensKeyHash(ToHash: String): Integer;
var
  I: Integer;
begin
  Result := 0;
  for I := 1 to Length(ToHash) do
    inc(Result, mSKeyHashTable[ToHash[I]]);
end; { SensKeyHash }

function TGenFrm.KeyHash(ToHash: String): Integer;
var
  I: Integer;
begin
  Result := 0;
  for I := 1 to Length(ToHash) do
    inc(Result, mKeyHashTable[ToHash[I]]);
end; { KeyHash }

procedure TGenFrm.FormCreate(Sender: TObject);
begin
  Stream := TMemoryStream.Create;
  Lex := TmwGenLex.Create;
  KeyList := TList.Create;
  SetList := TList.Create;
  IdentList := TStringList.Create;
  MakeHashTable;
  MakeSensitiveHashTable;
end;

procedure TGenFrm.FormDestroy(Sender: TObject);
var
  I: Integer;
begin
  Lex.Free;
  Stream.Free;
  IdentList.Free;
  for I := 0 to KeyList.Count - 1 do TObject(KeyList[I]).Free;
  KeyList.Free;
  for I := 0 to SetList.Count - 1 do TObject(SetList[I]).Free;
  SetList.Free;
end;

procedure TGenFrm.StartBtnClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    Stream.Clear;
    Stream.LoadFromFile(OpenDialog1.FileName);
    Lex.Origin := Stream.Memory;
    Lex.Tokenize;
    while Lex.RunId <> IDIdentifier do Lex.Next;
    LexName := Lex.RunToken;
    Lex.Next;
    while Lex.RunId <> IDIdentifier do Lex.Next;
    IdentPre := Lex.RunToken;
    OutFileCreate(OpenDialog1.FileName);
    while not (Lex.RunId in [IdSensitive, IdIdentStart]) do Lex.Next;
    if Lex.RunId = IdSensitive then Sensitivity := True else Sensitivity := False;
    Lex.Next;
    while Lex.RunId <> IDCharSet do Lex.Next;
    IdentStart := Lex.RunToken;
    Lex.Next;
    while Lex.RunId <> IDCharSet do Lex.Next;
    IdentContent := Lex.RunToken;
    while Lex.RunId <> IDKeys do Lex.Next;
    FillKeyList;
    while Lex.RunId <> IDChars do Lex.Next;
    ParseCharsets;
    WriteRest;
    while Lex.RunId <> IdNull do
    begin
      Lex.Next;
    end;
    CloseFile(OutFile);
  end;
end;

//Method_Marker(TForm1.FillKeyList)

procedure TGenFrm.FillKeyList;
var
  aLexKey: TLexKeys;
begin
  Lex.Next;
  while Lex.RunId <> IdStop do
  begin
    while Lex.RunId in [IdSpace, IdBraceOpen, IdCRLF, IDUnknown] do Lex.Next;
    if Lex.RunId <> IdStop then
    begin
      aLexKey := TLexKeys.Create;
      aLexKey.KeyName := Lex.RunToken;
      if Sensitivity then aLexKey.Key := SensKeyHash(aLexKey.KeyName) else
        aLexKey.Key := KeyHash(aLexKey.KeyName);
      KeyList.Add(aLexKey);
      IdentList.Add(IdentPre + Lex.RunToken);
    end else break;
    Lex.Next;
  end;
  Lex.Next;
  while Lex.RunId <> IdStop do
  begin
    while Lex.RunId in [IdSpace, IdBraceOpen, IdCRLF, IDUnknown] do Lex.Next;
    if Lex.RunId <> IdStop then IdentList.Add(IdentPre + Lex.RunToken) else break;
    Lex.Next;
  end;
  KeyList.Sort(CompareKeys);
end;


//Method_Marker(TForm1.OutFileCreate)

procedure TGenFrm.OutFileCreate(InName: String);
var
  OutName, UName: String;
begin
  OutName := ExtractFileName(InName);
  Delete(OutName, Length(OutName) - 3, 4);
  Uname := OutName;
  OutName := OutName + '.pas';
  AssignFile(OutFile, OutName);
  rewrite(OutFile);
  Writeln(OutFile, '{Created by mwLexGen}');
  Writeln(OutFile, 'unit ' + Uname + ';' + #13#10);
  Writeln(OutFile, 'interface' + #13#10);
  Writeln(OutFile, 'uses');
  Writeln(OutFile, '  SysUtils, Windows, Messages, Classes, Controls, mwTLongIntList;' + #13#10);
  Writeln(OutFile, 'var');
  Writeln(OutFile, '  Identifiers: array[#0..#255] of ByteBool;');
  Writeln(OutFile, '  mHashTable: array[#0..#255] of Integer;' + #13#10);
  Writeln(OutFile, 'Type');
  Writeln(OutFile, '  T' + IdentPre + 'TokenKind = (');
end;


//Method_Marker(TForm1.ParseCharsets)

procedure TGenFrm.ParseCharsets;
begin
  Lex.Next;
  while Lex.RunId <> IdStop do
  begin
    Case Lex.RunId of
      IdCharset: RetriveCharset;
    else Lex.Next;
    end;
  end;
end;


//Method_Marker(TForm1.RetriveCharset)

procedure TGenFrm.RetriveCharset;
var
  aSet: TLexCharsets;
begin
  aSet := TLexCharsets.Create;
  aSet.Charset := Lex.RunToken;
  while Lex.RunId <> IDIdentifier do Lex.Next;
  aSet.SetName := Lex.RunToken;
  IdentList.Add(IdentPre + aSet.SetName);
  while Lex.RunId <> IDBeginProc do Lex.Next;
  Lex.Next;
  while Lex.RunId in [IdCRLF, IdSpace] do Lex.Next;
  while not (Lex.RunId = IdEndProc) do
  begin
    aSet.ProcData := aSet.ProcData + Lex.RunToken;
    Lex.Next;
  end;
  while Lex.RunId <> IDBeginFunc do Lex.Next;
  Lex.Next;
  while Lex.RunId in [IdCRLF, IdSpace] do Lex.Next;
  while not (Lex.RunId = IdEndFunc) do
  begin
    aSet.FuncData := aSet.FuncData + Lex.RunToken;
    Lex.Next;
  end;
  SetList.Add(aSet);
  Lex.Next;
end;


//Method_Marker(TForm1.WriteRest)

procedure TGenFrm.WriteRest;
var
  I: Integer;
  KeyString, NameString: String;
begin
  IdentList.Sort;
  SetList.Sort(CompareSets);
  I := 0;
  while I < IdentList.Count - 1 do
  begin
    Writeln(OutFile, '    ' + IdentList[I] + ',');
    inc(I);
  end;
  Writeln(OutFile, '    ' + IdentList[I] + ');');
  Writeln(OutFile, '');
  Writeln(OutFile, 'type');
  Writeln(OutFile, '  ' + LexName + ' = class(TObject)');
  Writeln(OutFile, '  private');
  Writeln(OutFile, '    fOrigin: PChar;');
  Writeln(OutFile, '    fProcTable: array[#0..#255] of procedure of Object;');
  Writeln(OutFile, '    fFuncTable: array[#0..#255] of function: T' + IdentPre + 'TokenKind of Object;');
  Writeln(OutFile, '    Run: LongInt;');
  Writeln(OutFile, '    Walker: LongInt;');
  Writeln(OutFile, '    Running: LongInt;');
  Writeln(OutFile, '    FRoundCount: Integer;');
  Writeln(OutFile, '    FSquareCount: Integer;');
  Writeln(OutFile, '    fStringLen: Integer;');
  Writeln(OutFile, '    fToIdent: PChar;');
  Writeln(OutFile, '    fTokenizing: Boolean;');
  Writeln(OutFile, '    FLinePosList: TLongIntList;');
  Writeln(OutFile, '    FTokenPositionsList: TLongIntList;');
  KeyString := IntToStr(TLexKeys(KeyList[KeyList.Count - 1]).Key);
  Writeln(OutFile, '    fIdentFuncTable: array[0..' + KeyString + '] of function: T' + IdentPre + 'TokenKind of Object;');
  Writeln(OutFile, '    function KeyHash(ToHash: PChar): Integer;');
  Writeln(OutFile, '    function KeyComp(aKey: String): Boolean;');
  I := 0;
  while I < KeyList.Count do
  begin
    if I = 0 then
      Writeln(OutFile, '    function Func' + IntToStr(TLexKeys(KeyList[I]).Key) + ':T' + IdentPre + 'TokenKind;')else
    if (TLexKeys(KeyList[I-1]).Key <> TLexKeys(KeyList[I]).Key) then
    Writeln(OutFile, '    function Func' + IntToStr(TLexKeys(KeyList[I]).Key) + ':T' + IdentPre + 'TokenKind;');
    inc(I);
  end;

  I := 0;
  while I < SetList.Count do
  begin
    Writeln(OutFile, '    procedure ' + TLexCharsets(SetList[I]).SetName + 'Proc;');
    Writeln(OutFile, '    function ' + TLexCharsets(SetList[I]).SetName + 'Func:T' + IdentPre + 'TokenKind;');
    inc(I);
  end;

  Writeln(OutFile, '    procedure UnknownProc;');
  Writeln(OutFile, '    function UnknownFunc: T' + IdentPre + 'TokenKind;');
  Writeln(OutFile, '    function AltFunc: T' + IdentPre + 'TokenKind;');
  Writeln(OutFile, '    procedure InitIdent;');
  Writeln(OutFile, '    function IdentKind(MayBe: PChar): T' + IdentPre + 'TokenKind;');
  Writeln(OutFile, '    procedure SetOrigin(NewValue: PChar);');
  Writeln(OutFile, '    procedure SetRunPos(Value: Integer);');
  Writeln(OutFile, '    procedure MakeMethodTables;');
  Writeln(OutFile, '    function GetRunId: T' + IdentPre + 'TokenKind;');
  Writeln(OutFile, '    function GetRunToken: String;');
  Writeln(OutFile, '  protected');
  Writeln(OutFile, '  public');
  Writeln(OutFile, '    constructor Create;');
  Writeln(OutFile, '    destructor Destroy; override;');
  Writeln(OutFile, '    procedure Tokenize;');
  Writeln(OutFile, '    procedure Next;');
  Writeln(OutFile, '    property Origin: PChar read fOrigin write SetOrigin;');
  Writeln(OutFile, '    property RunPos: Integer read Run write SetRunPos;');
  Writeln(OutFile, '    function NextToken: String;');
  Writeln(OutFile, '    property RunId: T' + IdentPre + 'TokenKind read GetRunId;');
  Writeln(OutFile, '    property RunToken: String read GetRunToken;');
  Writeln(OutFile, '  published ');
  Writeln(OutFile, '  end;');
  Writeln(OutFile, '');
  Writeln(OutFile, 'implementation');
  Writeln(OutFile, '');

  if Sensitivity then
  begin
    Writeln(OutFile, 'procedure MakeIdentTable;');
    Writeln(OutFile, 'var');
    Writeln(OutFile, '  I: Char;');
    Writeln(OutFile, 'begin');
    Writeln(OutFile, '  for I := #0 to #255 do');
    Writeln(OutFile, '  begin');
    Writeln(OutFile, '    Case I of');
    Writeln(OutFile, '      ' + IdentContent + ': Identifiers[I] := True;');
    Writeln(OutFile, '    else Identifiers[I] := False;');
    Writeln(OutFile, '    end;');
    Writeln(OutFile, '    Case I in[' + IdentStart + '] of');
    Writeln(OutFile, '      True:');
    Writeln(OutFile, '        begin');
    Writeln(OutFile, '          if (I > #64) and (I < #91) then mHashTable[I] := Ord(I) - 64 else');
    Writeln(OutFile, '            if (I > #96) then mHashTable[I] := Ord(I) - 95;');
    Writeln(OutFile, '        end;');
    Writeln(OutFile, '    else mHashTable[I] := 0;');
    Writeln(OutFile, '    end;');
    Writeln(OutFile, '  end;');
    Writeln(OutFile, 'end;');
    Writeln(OutFile, '');
  end else
  begin
    Writeln(OutFile, 'procedure MakeIdentTable;');
    Writeln(OutFile, 'var');
    Writeln(OutFile, '  I, J: Char;');
    Writeln(OutFile, 'begin');
    Writeln(OutFile, '  for I := #0 to #255 do');
    Writeln(OutFile, '  begin');
    Writeln(OutFile, '    Case I of');
    Writeln(OutFile, '      ' + IdentContent + ': Identifiers[I] := True;');
    Writeln(OutFile, '    else Identifiers[I] := False;');
    Writeln(OutFile, '    end;');
    Writeln(OutFile, '    J := UpperCase(I)[1];');
    Writeln(OutFile, '    Case I in[' + IdentStart + '] of');
    Writeln(OutFile, '      True: mHashTable[I] := Ord(J) - 64');
    Writeln(OutFile, '    else mHashTable[I] := 0;');
    Writeln(OutFile, '    end;');
    Writeln(OutFile, '  end;');
    Writeln(OutFile, 'end;');
    Writeln(OutFile, '');
  end;

  Writeln(OutFile, 'procedure ' + LexName + '.InitIdent;');
  Writeln(OutFile, 'var');
  Writeln(OutFile, '  I: Integer;');
  Writeln(OutFile, 'begin');
  KeyString := IntToStr(TLexKeys(KeyList[KeyList.Count - 1]).Key);
  Writeln(OutFile, '  for I := 0 to ' + KeyString + ' do');
  Writeln(OutFile, '    Case I of');
  I := 0;
  while I < KeyList.Count do
  begin
    if I < KeyList.Count - 1 then
      while TLexKeys(KeyList[I]).Key = TLexKeys(KeyList[I + 1]).Key do
      begin
        inc(I);
        if I >= KeyList.Count -1 then break;
      end;
    KeyString := IntToStr(TLexKeys(KeyList[I]).Key);
    Writeln(OutFile, '      ' + KeyString + ': fIdentFuncTable[I] := Func' + KeyString + ';');
    inc(I);
  end;
  Writeln(OutFile, '    else fIdentFuncTable[I] := AltFunc;');
  Writeln(OutFile, '    end;');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  Writeln(OutFile, 'function ' + LexName + '.KeyHash(ToHash: PChar): Integer;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  Result := 0;');
  Writeln(OutFile, '  while ToHash^ in [' + IdentContent + '] do');
  Writeln(OutFile, '  begin');
  Writeln(OutFile, '    inc(Result, mHashTable[ToHash^]);');
  Writeln(OutFile, '    inc(ToHash);');
  Writeln(OutFile, '  end;');
  Writeln(OutFile, '  fStringLen := ToHash - fToIdent;');
  Writeln(OutFile, 'end; { KeyHash }');
  Writeln(OutFile, '');

  if Sensitivity then
  begin
    Writeln(OutFile, 'function ' + LexName + '.KeyComp(aKey: String): Boolean;');
    Writeln(OutFile, 'var');
    Writeln(OutFile, '  I: Integer;');
    Writeln(OutFile, '  Temp: PChar;');
    Writeln(OutFile, 'begin');
    Writeln(OutFile, '  Temp := fToIdent;');
    Writeln(OutFile, '  if Length(aKey) = fStringLen then');
    Writeln(OutFile, '  begin');
    Writeln(OutFile, '    Result := True;');
    Writeln(OutFile, '    for i := 1 to fStringLen do');
    Writeln(OutFile, '    begin');
    Writeln(OutFile, '      if Temp^ <> aKey[i] then');
    Writeln(OutFile, '      begin');
    Writeln(OutFile, '        Result := False;');
    Writeln(OutFile, '        break;');
    Writeln(OutFile, '      end;');
    Writeln(OutFile, '      inc(Temp);');
    Writeln(OutFile, '    end;');
    Writeln(OutFile, '  end else Result := False;');
    Writeln(OutFile, 'end; { KeyComp }');
    Writeln(OutFile, '');
  end else
  begin
    Writeln(OutFile, 'function ' + LexName + '.KeyComp(aKey: String): Boolean;');
    Writeln(OutFile, 'var');
    Writeln(OutFile, '  I: Integer;');
    Writeln(OutFile, '  Temp: PChar;');
    Writeln(OutFile, 'begin');
    Writeln(OutFile, '  Temp := fToIdent;');
    Writeln(OutFile, '  if Length(aKey) = fStringLen then');
    Writeln(OutFile, '  begin');
    Writeln(OutFile, '    Result := True;');
    Writeln(OutFile, '    for i := 1 to fStringLen do');
    Writeln(OutFile, '    begin');
    Writeln(OutFile, '      if mHashTable[Temp^] <> mHashTable[aKey[i]] then');
    Writeln(OutFile, '      begin');
    Writeln(OutFile, '        Result := False;');
    Writeln(OutFile, '        break;');
    Writeln(OutFile, '      end;');
    Writeln(OutFile, '      inc(Temp);');
    Writeln(OutFile, '    end;');
    Writeln(OutFile, '  end else Result := False;');
    Writeln(OutFile, 'end; { KeyComp }');
    Writeln(OutFile, '');
  end;

  I := 0;
  while I < KeyList.Count do
  begin
    KeyString := IntToStr(TLexKeys(KeyList[I]).Key);
    NameString := TLexKeys(KeyList[I]).KeyName;
    Writeln(OutFile, 'function ' + LexName + '.Func' + KeyString + ': T'+IdentPre+'TokenKind;');
    Writeln(OutFile, 'begin');
    KeyString:= '';
      while TLexKeys(KeyList[I]).Key = TLexKeys(KeyList[I + 1]).Key do
      begin
        Writeln(OutFile, KeyString + '  if KeyComp(' + #39 + NameString + #39 + ') then Result := ' + IdentPre + NameString + ' else');
        inc(I);
        if I >= KeyList.Count -1 then break;
        KeyString:= KeyString + '  ';
      end;
    NameString := TLexKeys(KeyList[I]).KeyName;
    Writeln(OutFile, KeyString + '  if KeyComp(' + #39 + NameString + #39 + ') then Result := ' + IdentPre + NameString + ' else Result := '+IdentPre+'Identifier;');
    Writeln(OutFile, 'end;');
    Writeln(OutFile, '');
    inc(I);
  end;

  Writeln(OutFile, 'function ' + LexName + '.AltFunc: T' + IdentPre + 'TokenKind;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  Result := '+ IdentPre +'Identifier;');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  KeyString := IntToStr(TLexKeys(KeyList[KeyList.Count - 1]).Key +1);

  Writeln(OutFile, 'function ' + LexName + '.IdentKind(MayBe: PChar): T' + IdentPre + 'TokenKind;');
  Writeln(OutFile, 'var');
  Writeln(OutFile, '  HashKey: Integer;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  fToIdent := MayBe;');
  Writeln(OutFile, '  HashKey := KeyHash(MayBe);');
  Writeln(OutFile, '  if HashKey < ' + KeyString + ' then Result := fIdentFuncTable[HashKey] else Result := '+IdentPre+'Identifier;');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  Writeln(OutFile, 'procedure ' + LexName + '.MakeMethodTables;');
  Writeln(OutFile, 'var');
  Writeln(OutFile, '  I: Char;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  for I := #0 to #255 do');
  Writeln(OutFile, '    case I of');

  I := 0;
  while I < SetList.Count do
  begin
    Writeln(OutFile, '      ' + TLexCharsets(SetList[I]).Charset + ':');
    Writeln(OutFile, '        begin');
    Writeln(OutFile, '          fProcTable[I] := ' + TLexCharsets(SetList[I]).SetName + 'Proc;');
    Writeln(OutFile, '          fFuncTable[I] := ' + TLexCharsets(SetList[I]).SetName + 'Func;');
    Writeln(OutFile, '        end;');
    inc(I);
  end;

  Writeln(OutFile, '    else');
  Writeln(OutFile, '      begin');
  Writeln(OutFile, '        fProcTable[I] := UnknownProc;');
  Writeln(OutFile, '        fFuncTable[I] := UnknownFunc;');
  Writeln(OutFile, '      end;');
  Writeln(OutFile, '    end;');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');




  Writeln(OutFile, 'constructor ' + LexName + '.Create;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  inherited Create;');
  Writeln(OutFile, '  InitIdent;');
  Writeln(OutFile, '  MakeMethodTables;');
  Writeln(OutFile, '  FTokenPositionsList := TLongIntList.Create;');
  Writeln(OutFile, '  FLinePosList := TLongIntList.Create;');
  Writeln(OutFile, 'end; { Create }');
  Writeln(OutFile, '');

  Writeln(OutFile, 'destructor ' + LexName + '.Destroy;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  inherited Destroy;');
  Writeln(OutFile, '  FTokenPositionsList.Free;');
  Writeln(OutFile, '  FLinePosList.Free;');
  Writeln(OutFile, 'end; { Destroy }');
  Writeln(OutFile, '');

  Writeln(OutFile, 'procedure ' + LexName + '.SetOrigin(NewValue: PChar);');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  fOrigin := NewValue;');
  Writeln(OutFile, '  Run := 0;');
  Writeln(OutFile, '  Walker := 0;');
  Writeln(OutFile, '  FTokenPositionsList.Clear;');
  Writeln(OutFile, '  FTokenPositionsList.Add(0);');
  Writeln(OutFile, '  FLinePosList.Clear;');
  Writeln(OutFile, '  FLinePosList.Add(0);');
  Writeln(OutFile, 'end; { SetOrigin }');
  Writeln(OutFile, '');

  Writeln(OutFile, 'procedure ' + LexName + '.SetRunPos(Value: Integer);');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  Run := Value;');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');







  I := 0;
  while I < SetList.Count do
  begin
    Writeln(OutFile, 'procedure ' + LexName + '.' + TLexCharsets(SetList[I]).SetName + 'Proc;');
    Writeln(OutFile, 'begin');
    Write(OutFile, '  ' + TLexCharsets(SetList[I]).ProcData);
    Writeln(OutFile, 'end;');
    Writeln(OutFile, '');

    Writeln(OutFile, 'function ' + LexName + '.' + TLexCharsets(SetList[I]).SetName + 'Func:T' + IdentPre + 'TokenKind;');
    Writeln(OutFile, 'begin');
    Write(OutFile, '  ' + TLexCharsets(SetList[I]).FuncData);
    Writeln(OutFile, 'end;');
    Writeln(OutFile, '');

    inc(I);
  end;

  Writeln(OutFile, 'procedure ' + LexName + '.UnknownProc;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  inc(Walker);');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  Writeln(OutFile, 'function ' + LexName + '.UnknownFunc: T' + IdentPre + 'TokenKind;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  Result := ' + IdentPre + 'Unknown;');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');


  Writeln(OutFile, 'function ' + LexName + '.GetRunId: T' + IdentPre + 'TokenKind;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  Running := FTokenPositionsList[Run];');
  Writeln(OutFile, '  Result := fFuncTable[fOrigin[Running]];');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  Writeln(OutFile, 'function ' + LexName + '.GetRunToken: String;');
  Writeln(OutFile, 'var');
  Writeln(OutFile, '  StartPos, EndPos, StringLen: Integer;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  StartPos := FTokenPositionsList[Run];');
  Writeln(OutFile, '  EndPos := FTokenPositionsList[Run + 1];');
  Writeln(OutFile, '  StringLen := EndPos - StartPos;');
  Writeln(OutFile, '  SetString(Result, (FOrigin + StartPos), Stringlen);');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  Writeln(OutFile, 'procedure ' + LexName + '.Tokenize;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  fTokenizing := True;');
  Writeln(OutFile, '  repeat');
  Writeln(OutFile, '    fProcTable[fOrigin[Walker]];');
  Writeln(OutFile, '    FTokenPositionsList.Add(Walker);');
  Writeln(OutFile, '  until fOrigin[Walker] = #0;');
  Writeln(OutFile, '  fTokenizing := False;');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  Writeln(OutFile, 'procedure ' + LexName + '.Next;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  inc(Run);');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  Writeln(OutFile, 'function ' + LexName + '.NextToken: String;');
  Writeln(OutFile, 'var');
  Writeln(OutFile, '  StartPos, EndPos, Len: LongInt;');
  Writeln(OutFile, 'begin');
  Writeln(OutFile, '  StartPos := FTokenPositionsList[Run];');
  Writeln(OutFile, '  EndPos := FTokenPositionsList[Run + 1];');
  Writeln(OutFile, '  Len := EndPos - StartPos;');
  Writeln(OutFile, '  SetString(Result, (FOrigin + StartPos), Len);');
  Writeln(OutFile, '  inc(Run);');
  Writeln(OutFile, 'end;');
  Writeln(OutFile, '');

  Writeln(OutFile, 'Initialization');
  Writeln(OutFile, '  MakeIdentTable;');
  Writeln(OutFile, 'end.');

end;

end.

