{+--------------------------------------------------------------------------+
 | Created:     10.97
 | Author:      Martin Waldenburg
 | Copyright    1997, all rights reserved.
 | Description: Demo for mwTSearch.
 | It's provided as is, without a warranty of any kind.
 | You use it at your own risc.
 | E-Mail me at Martin.Waldenburg@t-online.de
 +--------------------------------------------------------------------------+}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, mwTSearch,
  StdCtrls, mwFastTime;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Time1: TmwFastTime;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    function RndString:String;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function TForm1.RndString:String;
var
  J, Len: integer;
  aChar: Char;
  CharArray: array[0..5] of Char;
begin
  Randomize;
  Len:= random(5);
  for J := 0 to Len -1 do
    begin
      repeat
      aChar := Chr(random(58) + Ord('A'));
      until (aChar <= 'Z') or (aChar >= 'a');
      CharArray[J]:= aChar;
    end;
    CharArray[Len]:= #0;
    Result:= CharArray;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Search: TTISearch;
  TextLine: String;
  I: Integer;
begin
  TextLine:= 'TTSearch  (TurboSearch) is a very fast search engine, ' +
             'about twice as fast as Boyer-Moore, '+
             'based on an article in the German magazine c`t (8/97).' +
             'However "Look_at" isn`t implemented, because I can`t see any sense in Pascal.'+
             'The original is in "C". You can search case sensitive or case insensitive.' + #13#10;
  for I:= 1 to 12 do TextLine:= TextLine + RndString + #13#10 + TextLine;
  Time1.Start;
  Search:= TTISearch.Create;
  Search.Init('isn`t implemented,');
  Search.FindFirst(TextLine);
  while not Search.Finished do Search.Next;
  Time1.Stop;
  Edit1.Text:= 'String Size: ' + IntToStr(Length(TextLine));
  Edit2.Text:= 'Found ' + IntToStr(Search.Count);
  Search.Free;
  Edit3.Text:= Time1.ElapsedTime;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  Search: TTISearch;
  TextLine: String;
  I: Integer;
begin
  TextLine:= 'TTSearch  (TurboSearch) is a very fast search engine, ' +
             'about twice as fast as Boyer-Moore, '+
             'based on an article in the German magazine c`t (8/97).' +
             'However "Look_at" isn`t implemented, because I can`t see any sense in Pascal.'+
             'The original is in "C". You can search case sensitive or case insensitive.' + #13#10;
 for I:= 1 to 12 do TextLine:= TextLine + RndString + #13#10 + TextLine;
  Time1.Start;
  Search:= TTISearch.Create;
  Search.IInit('isN`t imPlemenTed,');
  Search.IFindFirst(TextLine);
  while not Search.Finished do Search.INext;
  Time1.Stop;
  Edit1.Text:= 'String Size: ' + IntToStr(Length(TextLine));
  Edit2.Text:= 'Found ' + IntToStr(Search.Count);
  Search.Free;
  Edit3.Text:= Time1.ElapsedTime;

end;

end.
