{+--------------------------------------------------------------------------+
 | Unit:        mSyntaHEUnit
 | Created:     9.98
 | Author:      Martin Waldenburg
 | Description: A raw sample on how to create a syntax highlighting editor
 |              using TRichEdit, without to much flickering.
 |              The changes are only reflectet for the current line.
 |              Just to give a starting point.
 |              mpas2rtf.zip needed.
 | Version:     1.0
 | Status       Placed to the public domain
 | It's provided as is, without a warranty of any kind.
 | You use it at your own risc.
 | E-Mail me at Martin.Waldenburg@t-online.de
 +--------------------------------------------------------------------------+}

 {
  the following Routines:

  Function EditStreamInCallback
  Function EditStreamOutCallback
  Procedure GetRTFSelection
  Procedure PutRTFSelection

  are from a posting by Peter Below to:
  borland.public.delphi.vcl.components.using
}
unit mSyntaHEUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, mwPasToRtf, ExtCtrls, mwFastTime, mwSynEdit,
  RichEdit;


type
  TPasConversionClass=class of TPasConversion;

  TForm1=class(TForm)
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    Button1: TButton;
    Edit1: TEdit;
    Time1: TmwFastTime;
    Helper: TRichEdit;
    RichEdit1: TRichEdit;
    procedure Button1Click(Sender: TObject);
    procedure RichEdit1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function EditStreamInCallback(dwCookie: Longint; pbBuff: PByte;
  cb: Longint; var pcb: Longint): Longint; Stdcall;
var
  theStream: TStream;
  dataAvail: LongInt;
begin
  theStream:=TStream(dwCookie);
  with theStream do begin
    dataAvail:=Size-Position;
    Result:=0; {assume everything is ok}
    if dataAvail<=cb then begin
      pcb:=Read(pbBuff^, dataAvail);
      if pcb<>dataAvail then{couldn't read req. amount of bytes}
        result:=E_FAIL;
    end
    else begin
      pcb:=Read(pbBuff^, cb);
      if pcb<>cb then
        result:=E_FAIL;
    end;
  end;
end;

Function EditStreamOutCallback(dwCookie: Longint; pbBuff: PByte;
  cb: Longint; var pcb: Longint): Longint; stdcall;
var
  theStream: TStream;
begin
  theStream:=TStream(dwCookie);

  with theStream do begin
    If cb>0 Then
      pcb:=Write(pbBuff^, cb);
    Result:=0;
  end;
end;

Procedure GetRTFSelection(aRichEdit: TRichEdit; intoStream: TStream);
Var
  editstream: TEditStream;
Begin
  With editstream Do Begin
    dwCookie:=Longint(intoStream);
    dwError:=0;
    pfnCallback:=EditStreamOutCallBack;
  end;
  aRichedit.Perform(EM_STREAMOUT, SF_RTF or SFF_SELECTION,
    longint(@editstream));
End;

Procedure PutRTFSelection(aRichEdit: TRichEdit; sourceStream: TStream);
Var
  editstream: TEditStream;
Begin
  With editstream Do Begin
    dwCookie:=Longint(sourceStream);
    dwError:=0;
    pfnCallback:=EditStreamInCallBack;
  end;
  aRichedit.Perform(EM_STREAMIN, SF_RTF or SFF_SELECTION,
    longint(@editstream));
End;

procedure TForm1.Button1Click(Sender: TObject);
var
  PasCon: TPasConversion;
begin
  if OpenDialog1.Execute then
  begin
    Time1.Start;
    PasCon:=TPasConversion.Create;
    PasCon.UseDelphiHighlighting(3);
    PasCon.LoadFromFile(OpenDialog1.FileName);
    PasCon.ConvertReadStream;
    RichEdit1.Lines.BeginUpdate;
    RichEdit1.Lines.LoadFromStream(PasCon);
    RichEdit1.Lines.EndUpdate;
    PasCon.Free;
    Time1.Stop;
    Edit1.Text:=Time1.ElapsedTime;
  end;
end;


procedure TForm1.RichEdit1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  PasCon: TPasConversion;
  aLine: String;
  EditStream: TEditStream;
  aStream: TMemoryStream;
  LineLen: Integer;
  OldStart: Integer;
  aPoint: TPoint;
begin
  Time1.Start;
  OldStart:=RichEdit1.SelStart;
  aPoint:=RichEdit1.CaretPos;
  aStream:=TMemoryStream.Create;
  aLine:=RichEdit1.Lines[aPoint.Y];
  LineLen:=Length(aLine);
  PasCon:=TPasConversion.Create;
  PasCon.UseDelphiHighlighting(3);
  PasCon.Write(aLine[1], LineLen);
  PasCon.Position:=0;
  if LineLen>0 then
    PasCon.ConvertReadStream;
  Helper.Lines.LoadFromStream(PasCon);
  Helper.SelStart:=0;
  Helper.SelLength:=LineLen;
  RichEdit1.Lines[aPoint.Y]:='';
  RichEdit1.SelLength:=0;
  GetRTFSelection(Helper, aStream);
  aStream.Position:=0;
  PutRTFSelection(richedit1, aStream);
  RichEdit1.SelStart:=OldStart;
  PasCon.Free;
  aStream.Free;
  Time1.Stop;
  Edit1.Text:=Time1.ElapsedTime;
end;

end.

