unit MSWord;

interface

uses
  Classes, graphics,DBTables, OleAuto,dialogs;

type
    tWho = (Master,Detail);
    tdirection = (UP,DOWN);
    TMyevents = procedure(Sender : tObject) of object;
    
type
  TMSWord = class(TComponent)
  private
    MSWord: Variant;
    fatp,FDN,FMN,frp : TMyevents;
    ftfont,fdfont:tfont;
    fmcols:integer;
    Key1,Key2,FFileName,FRtitle{,ffq}: String;
    FMQuery,FDQuery: TQuery;
    procedure Setftfont(value : tfont);
    procedure Setfdfont(value : tfont);
    procedure execute(query : tquery);
    procedure openReport;
    procedure closereport;
  public
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    PROCEDURE   PrintSimpleTableReport(cual : twho);
    procedure   PrintMasterDetailReport;
    procedure   WritetoWord(word: string;newline:boolean);
    procedure   ConvertToTable(direction:tdirection;Lines,COLS:integer);
  published
    property DocumentFileName        : String read FFileName write FFileName;
    property QueryForMasterTable     : TQuery read FMQuery write FMQuery;
    property QueryForDetailTable     : tquery read fDquery write FDQuery;
    property DocumentTitle           : string read FRtitle write FRtitle;
    property ColsInSimpleReport      : integer read fmcols write fmcols;
    property FontForTitle            : tfont read fTFont write Setftfont;
    property FontForReport           : tfont read FDfont write SetFdfont;
    property KeyInDetailTableForSimpleFilter : string read key2 write key2;
    property KeyInMasterTableForSimpleFilter : String read key1 write Key1;
    property AfterTitlePrint       : TMyevents read fatp write fatp;
    property AfterReportPrint      : TMyevents read frp  write frp;
    property WhenMasterNeedtoPrint : TMyevents read FMN  write fMN;
    property WhenDetailNeedtoPrint : TMyevents read FDN  write FDN;
  end;

procedure Register;

implementation


procedure Register;
begin
  RegisterComponents('Dennis', [TMSWord]);
end;

constructor TMSWord.Create(AOwner: TComponent);
begin
  ftfont := tfont.create;
  fdfont := tfont.create;
  inherited Create(AOwner);
end;

destructor TMSWord.Destroy;
begin
  ftfont.free;
  fdfont.free;
  inherited Destroy;
end;

procedure Tmsword.ConvertToTable(direction:tdirection;Lines,cols:integer);
begin
     if direction = up then
         msword.LINEUP(Lines,1)
     else
         msword.linedown(lines,0);
     MSWord.TextToTable(ConvertFrom  := 2, NumColumns  := cols);
     if direction = up then
        msword.linedown(lines,0)
     else
        msword.lineup(lines,1);
end;

procedure TmsWord.WritetoWord(word: string;newline:boolean);
begin
  msword.insert(word);
  if newline then
   msword.insert(#13); 
end;

procedure TMSWord.Setftfont(value : tfont);
begin
   ftfont.assign(value);
end;

procedure TMSWORD.PrintMasterDetailReport;
begin
  if (assigned(WhenDetailNeedtoPrint)) and
     (assigned(WhenMasterNeedtoPrint)) then begin
   openreport;
   try
    while not FMQuery.eof do begin
        fdquery.first;
        if (key1 <> '') and (key2 <> '') then
           FDquery.filter  := key2 +' = '+
              Fmquery.fieldbyname(key1).asstring;
        MSWORD.FONT(fdfont.name,fdfont.size);
        WhenMasterNeedtoPrint(self);
        while not FDquery.eof do begin
           MSWORD.FONT(fdfont.name,fdfont.size);
           WhenDetailNeedtoPrint(self);
           FDquery.next;
        end;
        FMquery.next;
    end;
   except
      writetoword('error in parameters',TRUE);
   end;
   closereport;
  end;
end;

PROCEDURE TMSWord.PrintSimpleTableReport(cual : twho);
begin
  if cual = Master then
     execute(FMQuery)
  else
     execute(FDQuery);
end;

procedure TMSWord.Setfdfont(value : tfont);
begin
   fdfont.assign(value);
end;

procedure TMSWord.OpenReport;
begin
 Try
    MsWord := CreateOleObject('Word.Basic');
 except
    raise;
    Exit;
 end;
 MsWord.AppShow;
 MSWord.FileNew;
 msword.centerpara;
 MSWORD.FONT(ftfont.name,ftfont.size);
 msword.insert(frtitle+#10#13);
 msword.leftpara;
 if Assigned(AfterTitlePrint) then begin
   MSWORD.FONT(fdfont.name,fdfont.size);
   AfterTitlePrint(self);
 end;
end;

procedure tmsword.closereport;
begin
  if Assigned(AfterReportPrint) then begin
    MSWORD.FONT(fdfont.name,fdfont.size);
    AfterReportPrint(self);
  end;
  msword.insert(#13+#13+'Unregistered Version'+#13);
  msword.insert('dennisortiz@Hotmail.com ... $5.00 to Register'+#13);
  msword.insert('Denewtech Developers'+#13);
  msword.insert('Urb. Los Robles Flamboyan 114'+#13);
  msword.insert('Moca Puerto Rico, 00676'+#13);
  MSWord.FileSaveAs(FFileName, 0);
end;

PROCEDURE TMSWord.Execute(query : tquery);
var
  S: string;
  l,i,fcounts: Integer;
begin
 try
  Openreport;
  L := 0;
  S := '';
  with Query do begin
    {fcounts := FieldCount-1;}
    fcounts := FMCols-1;
    for i := 0 to Fcounts do
       S := S + Fields[i].displayname + ',';
    inc(l);
    {l := l + ((fcounts+1) div fmcols);}
    First;
    MSWORD.FONT(fdfont.name,fdfont.size);
    MSWORD.INSERT(S+#13);
    S := '';
    while not EOF do begiN
       for i := 0 to fcounts do  begin
           S := S + Fields[i].AsString + ',';
       end;
       MSWORD.FONT(fdfont.name,fdfont.size);
       MSWord.Insert(S);
       inc(l);
       {l := l + ((fcounts+1) div fmcols);}
       S := '';
       Next;
    end;
  end;
  dec(l);
  mSWORD.LINEUP(L,1);
  MSWord.TextToTable(ConvertFrom  := 2, NumColumns  := Fmcols);
  msword.linedown(l,0);
  closereport;
 except
    raise;
    exit;
 end;
end;

end.



 {msword.FileOpen('C:\comp\readme.txt');} { abrir un documento }
 {msword.FilePreview(true);} { nesesito averiguar su sintasis }
 {msword.style('Message Header');} { IS WORK }
 {msword.insertpicture('c:\u1.bmp');} { work too }


