unit myff;

{******************************************************************************
unit MyFF declares the object tMyFF which can be used to scan directories
for files. you can specify filesize (min/max), filetime (min/max), whether to
recurse directories, files' attributes, filename-masks (divided by ';' or ','),
and you can also search for text in files (case-insensitive).

the sample-program can be compiled without installing the component to the vcl.

this object uses the unit tisearch (which includes a fast text-search-object)
written by MARTIN WALDENBURG at Martin.Waldenburg@t-online.de, which should be
included in this package (not him - his unit ;), if not, then you may find this
on DSP (http://sunsite.icm.edu.pl/archive/delphi/) or Torry's Delphi Pages
(http://carbohyd.siobc.ras.ru/torry/).

This stuff is freeware (not PD) and copyrighted by MARKUS STEPHANY at
MirBir.St@Saargate.de / MirBir.St@T-Online.de. there are no limitations to
free-/shareware-authors, commercial developers please contact me and the owner
of (c) from tisearch, M. Waldenburg.

there are no guaranties and warranties and there is no possibility to make me
responsable for any misbehaviour, data-loss or anything else what my happen
if you use MyFF, but you are welcome to write me if there are any questions,
suggestions, bug-reports...

revision 1.01, october 08, 1997

******************************************************************************}

interface

uses
  Windows, SysUtils, Classes,filectrl,mwtisearch,dialogs;

// if we change the directory and/or the file on text-search
// name is the path or file to scan, if fcancel is set to true, tMyFF will return from the find-function
type tfileevent = procedure(name:string; var cancel : boolean) of object;
// if we found a file that matches the specs, this event will be triggered
// path is the file's path, data is the file-data-structure that contains the file's attributes
// if fcancel is set to true, tMyFF will return from the find-function
type taddevent = procedure (path:string; data : twin32finddata; var cancel : boolean) of object;

type
  TMyFF = class(TComponent)
  private
    { Private-Deklarationen }

    ffilemask : tstringlist;
    ftmplist  : tstrings;
    fattr     : integer;
    ftimefirst: tfiletime;
    ftimelast : tfiletime;

    fgrepmask : string;

    fsizemin  : longint;
    fsizemax  : longint;

    frecurse  : boolean;

    ftsearch : ttisearch;
    fonadd   : taddevent;
    ffileevent: tfileevent;
    fscanevent: tfileevent;

    procedure setfilemask(val : string);
    function  getfilemask:string;
    function  getfirsttime:tdatetime;
    function  getlasttime:tdatetime;
    procedure setfirsttime(val:tdatetime);
    procedure setlasttime(val:tdatetime);
    procedure setgrepmask(val:string);
    function getattr : integer;
    procedure setattr(val : integer);
    function cmpmask(a:string):boolean;
    function cmpmask1(a,b:string):boolean;
    procedure setfilters (a:string);
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    constructor create(aowner : tcomponent);override;
    destructor destroy; override;
    // here we start searching for files, if the function has been canceled,
    // the result will be set to false
    // root is the start directory
    function find(root : string):boolean;
    // this is a useful routine to convert a tfiletime-struct to a delphi's tdatetime
    function convertdatetime (val:tfiletime):tdatetime;
    function convertfiletime (val:tdatetime):tfiletime;


  public
    // filemask (*.*;*.exe and so on)
    property FileMask : string read getfilemask write setfilemask;

    // earliest file-time to match
    property FirstTime : tdatetime read getfirsttime write setfirsttime;
    // latest filetime to match
    property LastTime : tdatetime read getlasttime write setlasttime;

    // least filesize to match
    property MinFileSize : longint read fsizemin write fsizemin default 0;
    // highest filesize to match
    property MaxFileSize : longint read fsizemax write fsizemax default maxint;

  published
    // fileattributes to search for (faanyfile,fasysfile ...)
    property Attributes : integer read getattr write setattr;

    // text to find in files (set to '' for no text-search)
    property FindString : string  read fgrepmask write setgrepmask;

    // shall we recurse thru all sub-directories?
    property RecurseDirs : boolean read frecurse write frecurse;

    // if we change to another directory (and/or if we search for text in another file)
    property OnChDir : tfileevent read ffileevent write ffileevent;
    // if a file matches the specified values, this event will be called
    property OnAddFile : taddevent read fonadd write fonadd;

    property OnScanFile:tfileevent read fscanevent write fscanevent;
  end;


procedure register;

implementation

procedure register;
begin
     RegisterComponents('SYSTEM', [TMyFF]);
end;

// helper-routines

function tfiletimetodatetime(const filetime: tfiletime): tdatetime;
// convert a win32's filetime-struct to a delphi tdatetime
var
  LocalFileTime: TFileTime;
  rs : integer;
begin
      FileTimeToLocalFileTime(filetime, LocalFileTime);
      if FileTimeToDosDateTime(LocalFileTime, LongRec(rs).Hi,
        LongRec(rs).Lo) then begin
                        result := filedatetodatetime(rs);
                        exit;
      end;
      Result := -1;
end;

procedure checkdate(var datetime:tdatetime);
// workaround for invalid dos-file-times (set them to valid values)
begin
     if datetime > 73050 then datetime := 73050; //later than 31.12.2099
     if datetime < 29221 then datetime := 29221; //earlier than 01.01.1974
end;

function datetimetotfiletime(datetime:tdatetime):tfiletime;
// convert a delphi tdatetime to a win32's filetime-struct
var
   localfiletime:tfiletime;
   rs:integer;
begin
     checkdate(datetime);
     rs := datetimetofiledate(datetime);
     if dosdatetimetofiletime(longrec(rs).hi,longrec(rs).lo,localfiletime)
        then begin
             localfiletimetofiletime(localfiletime,result);
             exit;
        end;
        result.dwLowDateTime:=$FFFF;
        result.dwHighDateTime:=$FFFF;
end;

// tMyFF implementation

procedure tmyff.setfilters (a:string);
// fills the ffilemask list with the parts of 'a' (divided by ',' or ';')

var ct : integer;
begin
     ffilemask.clear;
     ffilemask.sorted := false;
     if a = '' then begin
        ffilemask.add('*');
        exit;
     end;
     // replace all ',' by ';'
     ct := pos (',',a);
     while ct > 0 do begin
           a[ct] := ';';
           ct:=pos(',',a);
     end;
     if a[length(a)] <> ';' then a:=a+';';
     // divide the string
     ct := pos(';',a);
     while ct > 0 do begin
           ffilemask.add(ansilowercase(trim(copy(a,1,ct-1))));
           a:=copy(a,ct+1,maxint);
           ct:=pos(';',a);
     end;
     // replace a 'xxx' term (without a '.') with '*xxx*' (for compatibility
     // with win95's file-search-dialog)
      if ffilemask.count > 0 then for ct := 0 to pred(ffilemask.count) do begin
        a:=ffilemask[ct];
        if (pos('*',a) = 0) and (pos('.',a) = 0) then
           ffilemask[ct]:='*'+a+'*'
        else
        if pos('.',a) = 0 then if a[length(a)] <> '*' then
           ffilemask[ct]:=a+'*';
      end;
     ffilemask.sorted := true;
     ffilemask.duplicates := dupignore;
end;



function tmyff.cmpmask1(a,b:string):boolean;
// tests whether the string 'a' fits to the search mask in 'b'
var sr             : string;
    dontcare       : boolean;
    onechar        : char;
    ctl,cts,fg,tp : integer;


begin
     result := true;
     if b = '*' then exit; // fits always
     if b = '*.*' then if pos('.',a) > 0 then exit; // fits, too
     if (pos('*',b) = 0) and (pos('?',b)=0) then begin
           result := a = b;
           exit;
     end;

     result   := false;
     if b = '' then exit;

     ftmplist.clear;
     // divide partial strings ('?','*' or text) to Ftmplist
     repeat
           onechar := b[1];
           if (onechar='*') or (onechar='?') then begin
              ftmplist.add(onechar);
              delete(b,1,1);
           end else begin
               tp := pos('?',b);
               if tp = 0 then tp:=maxint;
               fg := pos('*',b);
               if fg = 0 then fg := maxint;
               if fg > tp then fg := tp;
               ftmplist.add(copy(b,1,fg-1));
               b:=copy(b,fg,maxint);
           end;
     until b = '';

     // now compare the string with the partial search masks
     dontcare := false;
     cts := 1;
     if ftmplist.count = 0 then exit;

     for ctl := 0 to pred(ftmplist.count) do begin
        sr := ftmplist[ctl];

        if sr <> '' then
        case sr[1] of
           '?' : cts:=cts+1;
           '*' : dontcare := true;

           else  begin
                 if dontcare then begin
                    tp := pos(sr,copy(a,cts,maxint));
                    dontcare := false;
                    if tp = 0 then break;
                    cts := tp+length(sr)+cts-1;
                 end else begin
                     if copy(a,cts,length(sr)) <> sr then break;
                     cts := cts+length(sr);
                 end;

           end;
        end;

     end;

     if not dontcare then if cts <> length(a)+1 then exit;
     if ctl <> ftmplist.count then exit;
     result := true;
end;

function tmyff.cmpmask(a:string):boolean;
// tests whether the string 'a' fits to the search masks in ffilemask
var ct : integer;
begin
     a:=ansilowercase(a);
     result := true;
     if a = '' then exit; // if no search string, then always return TRUE
     result:=false;
     if (ffilemask = nil) or (ffilemask.count < 1) then exit;
     result := true;
     for ct := 0 to pred(ffilemask.count) do
         if cmpmask1(a,ffilemask[ct]) then exit; // compare to the whole
                                                 // ffilemask until one fits
     result := false;
end;


constructor tMyFF.create;
begin
     inherited create(aowner);
     ffilemask := tstringlist.create;
     ftmplist := tstringlist.create;
     ftsearch := ttisearch.create;
     frecurse := true;
     attributes := faanyfile;
     findstring := '';
     firsttime := 0;
     lasttime  := maxint;
     minfilesize   := 0;
     maxfilesize   := maxint;
     filemask := '';
end;

destructor tMyFF.destroy;
begin
     ftsearch.free;
     ffilemask.free;
     ftmplist.free;
     inherited;
end;

function tMyFF.getattr : integer;
begin
     result := (not fattr) and faanyfile;
end;

procedure tMyFF.setattr(val : integer);
begin
     fattr := (not val) and faanyfile;
end;

procedure tMyFF.setgrepmask(val:string);
begin
     if val <> fgrepmask then begin
        fgrepmask := val;
        ftsearch.init(fgrepmask);
     end;
end;

function tMyFF.convertdatetime (val:tfiletime):tdatetime;
begin
     result := tfiletimetodatetime(val);
end;
function tmyff.convertfiletime (val:tdatetime):tfiletime;
begin
     result := datetimetotfiletime(val);
end;

procedure tMyFF.setlasttime(val:tdatetime);
begin
     // tdatetime nach filetime umsetzen
     ftimelast := datetimetotfiletime(val);
end;
procedure tMyFF.setfirsttime(val:tdatetime);
begin
     // tdatetime nach filetime umsetzen
     ftimefirst := datetimetotfiletime(val);
end;
function tMyFF.getlasttime;
begin
     // filetime nach tdatetime umsetzen
     result := tfiletimetodatetime(ftimelast);
end;
function tMyFF.getfirsttime;
begin
     // filetime nach tdatetime umsetzen
     result := tfiletimetodatetime(ftimefirst);
end;

function  tMyFF.getfilemask:string;
var ct : integer;
begin
     ct := ffilemask.count;
     result := '*.*';
     if ct = 0 then exit;
     result:='';
     for ct := 0 to ct-1 do
         if ct > 0 then result:=result+';'+ffilemask[ct]
         else result := ffilemask[ct];
end;

procedure tMyFF.setfilemask(val : string);
var ct : integer;
    sr1 : string;
begin
     setfilters(val);
end;

function tMyFF.find(root : string):boolean;




  function scantree(path:string):boolean;
  var handle : thandle;
      data   : twin32finddata;
      rs     : integer;
      fcancel: boolean;
      plist : tstrings;
  const wd : string = '.';

     function cmpkl(a,b:tfiletime):boolean;
     // berprfen, ob wert 1 kleiner wert2 ist
     begin
          if a.dwhighdatetime > b.dwhighdatetime then result := false
          else if a.dwhighdatetime < b.dwhighdatetime then result := true
          else result := (a.dwlowdatetime <= b.dwlowdatetime);
     end;
     function testfilename:boolean;
     // berprfen, ob dateimaske passt
     begin
          result := cmpmask(data.cfilename);
     end;
     function textfound:boolean;
     // berprfen, ob text gefunden
     var sr : string;
         fi : tfilestream;
     begin
          result := true;
          if fgrepmask = '' then exit;
          result := false;
          if assigned(fscanevent) then fscanevent(path+data.cfilename,fcancel);
          try
             fi := tfilestream.create(path+data.cfilename,fmopenread or fmsharedenynone);
          except
                exit;
          end;
          try
             setlength(sr,fi.size);
             fi.read(sr[1],fi.size);
             result := ftsearch.findfirst(sr) > 0;
          finally
                 fi.free;
                 sr := '';
          end;
     end;


     function ok : boolean;
     begin
          with data do begin
               // berprfen, ob dateigre stimmt
               result:= (nfilesizelow >= fsizemin) and (nfilesizelow <= fsizemax);
               // berprfen, ob dateialter passt
               if result then
                  result := cmpkl(ftlastwritetime,ftimelast) and cmpkl(ftimefirst,ftlastwritetime);
               // berprfen, ob attribute passen
               if result then
                  result := (dwfileattributes and fattr) = 0;
               // berprfen, ob dateimaske passt
               if result then
                  result := testfilename;
               // berprfen, ob text in suchtext vorhanden
               if result then
                  result := textfound;

          end;
     end;



  begin
     try
       plist := tstringlist.create;
       if path[length(path)] <> '\' then path:=path+'\';
       result := true;
       if assigned(ffileevent) then begin
          fcancel := false;
          ffileevent(path,fcancel);
          if fcancel then begin
             result := false;
             exit;
          end;
       end;
       handle := findfirstfile(pchar(path+'*.*'),data);
       fcancel := false;
       if handle <> invalid_handle_value then repeat
          // berprfen ob directory
          with data do begin
             if dwfileattributes and file_attribute_directory = file_attribute_directory then begin
                if (cfilename<>wd) and (cfilename <> '..') and frecurse then begin
                    plist.addobject(path+cfilename,pointer(0));
                end;

             end else begin
             if ok then
                if assigned(fonadd) then fonadd(path,data,fcancel);
             end;
          end;
          if fcancel then begin
             result := false;
             windows.findclose(handle);
             exit;
          end;
       until not findnextfile(handle,data);
       windows.findclose(handle);
       if plist.count > 0 then for rs := 0 to plist.count -1 do begin
          result := scantree(plist[rs]);

          if not result then begin
             windows.findclose(handle);
             exit;
          end;
       end;
     finally
            plist.free;
            windows.findclose(handle);
     end;
  end;

var sw : tdatetime;
    sw1 : longint;
begin
     if firsttime > lasttime then begin // if the filetimes are in wrong order
        sw := firsttime;
        firsttime := lasttime;
        lasttime := sw;
     end;
     if minfilesize > maxfilesize then begin // if the filesizes are in the wrong order
        sw1 := minfilesize;
        minfilesize := maxfilesize;
        maxfilesize := sw1;
     end;
     result := false;
     if root <> '' then if root[length(root)] = '\' then root := copy(root,1,length(root)-1);
     if directoryexists(root) then result :=scantree(root);
end;

end.
